<?php
/**
 * Template for used to display full post for gallery post formats
 *
 * For posts set to the post format Gallery, this template is used whenever
 * a single post is displayed.  This is called within the loop.
 * 
 * @since Planet Foundation 1.0.0
 *
 * @package ncp\wp\themes\planet_foundation
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 */

 $phpdoc_hack=0;  // parser won't parse summary without some code

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'pf-full-post pf-full-gallery-post' ); ?>>

	<?php if( pf_show_title() ) : ?>
		<header class="entry-header row">
			<div class="large-12 columns">
				<?php if ( current_user_can( 'edit_posts' ) ) : ?>
					<h2 class="pf-edit-post entry-title"><?php the_title(); ?></h2>
				<?php else: ?>
					<h2 class="entry-title"><?php the_title(); ?></h2>
				<?php endif; ?>

				<div class="entry-meta pf-edit-post-link-container">
					<?php if ( !is_page() ) : ?>
						<?php edit_post_link( __( 'Edit Post', 'planet-foundation' ) ); ?>
					<?php else : ?>
						<?php edit_post_link( __( 'Edit Page', 'planet-foundation' ) ); ?>
					<?php endif; ?>
				</div>
				<hr />
			</div>
		</header><!-- .entry-header -->
	<?php endif; ?>

	<div class="entry-content row">
		<div class="large-12 columns">
			<?php $gallery = get_post_gallery( get_the_ID() ); ?>
			<?php if ( ! $gallery ) : ?>
					<p><?php _e('Post is marked as a gallery but no gallery found','planet-foundation'); ?></p>
			<?php else :?>
					<?php the_content(); ?>
					<div class="entry-meta">
						<?php if( is_singular() ) : ?>
							<hr />
							<?php wp_link_pages(); ?>
						<?php endif; ?>

						<?php pf_categories() ?>
						<?php if( pf_show_tags() ) : ?>
							<?php pf_tags() ?>
						<?php endif; ?>
					</div>
			<?php endif; ?>
		</div>
	</div><!-- .entry-content -->

	<footer class="row">
		<div class="large-12 columns">
				<?php if ( pf_show_author() ) : ?>
					<?php echo pf_get_the_author( '', 'bio_w_posts'); ?>
				<?php endif; ?>
				<?php if ( comments_open() ) : ?>
					<div class="pf-comment-respond row">
						<div class="large-12 columns">
							<?php comments_template(); ?>
						</div>
					</div>
				<?php endif; ?>
			</div>
	</footer>
      
</article><!-- #post -->

