<?php
/**
 * Template for displaying archive pages (when you click on a category or tag)
 *
 * @since Planet Foundation 1.0.0
 *
 * @package ncp\wp\themes\planet_foundation
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 */

get_header(); ?>

	<div id="pf-main-content-container-row" class="row">

		<div id="pf-main-content-container-column" class="large-12 columns">

		  <div id="pf-main-content-container">

			<div class="off-canvas-wrap" data-offcanvas>
				<div class="inner-wrap">

				<?php pf_the_page_menu(); ?>

					<section class="main-section" data-equalizer>

						<?php
							$display_sidebars = get_theme_mod( 'pf_display_sidebars' );
							$left_sidebar = is_active_sidebar( 'left' );
							$right_sidebar = is_active_sidebar( 'primary' );
						?>

						<?php if ( $display_sidebars && $left_sidebar ) : ?>
							<div class="pf-left-sidebar hide-for-medium-down large-3 columns" data-equalizer-watch>
								<?php dynamic_sidebar( 'left' ); ?>
							</div>
						<?php endif; ?>

						<?php if ( $display_sidebars && $left_sidebar && $right_sidebar ) : ?>
							<div id="pf-middle-content" class="large-6 columns" data-equalizer-watch>
						<?php elseif ( ( $display_sidebars && $left_sidebar && !$right_sidebar ) || ( $display_sidebars && !$left_sidebar && $right_sidebar ) ) : ?>
							<div id="pf-middle-content" class="large-9 columns" data-equalizer-watch>
						<?php else : ?>
							<div id="pf-middle-content" class="large-12 columns" data-equalizer-watch>
						<?php endif; ?>

						<?php if ( is_category() ) : ?>
							<h2><?php _e( single_cat_title() ); ?></h2>
							<p><?php _e( category_description() ); ?></p>
							<hr />
						<?php endif; ?>

						<?php if ( have_posts() ) : ?>

							<?php while ( have_posts() ) : the_post(); ?>
								<?php get_template_part( 'excerpt', get_post_format() ); ?>
							<?php endwhile; ?>
		
						<?php else : ?>
							<?php get_template_part( 'content', 'none' ); ?>
						<?php endif; // end have_posts() check ?>
	
						<?php pf_pagination(); ?>
            </div>

						<?php if ( $display_sidebars && $right_sidebar ) : ?>
							<div class="pf-right-sidebar hide-for-medium-down large-3 columns" data-equalizer-watch>
								<?php dynamic_sidebar( 'primary' ); ?>
							</div>
						<?php endif; ?>

					</section><!-- End main-section -->

					<a class="exit-off-canvas"></a>

				</div><!-- .inner-wrap -->
			</div><!-- .off-canvas-wrap -->

		  </div><!-- #pf-main-content-container -->
		</div><!-- #pf-main-content-container-column -->
	</div><!-- pf-main-content-container-row -->

<?php get_footer(); ?>