<?php
/**
 * The catch all template.
 *
 * If a template file does not exist for a page, this one is loaded
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0
 */

get_header(); ?>

<!-- Row for main content area -->
	<div id="pf-main-content-container-row" class="row">
		<div id="pf-main-content-container-column" class="large-12 columns" role="main">
		  <div id="pf-main-content-container">

			<div class="off-canvas-wrap" data-offcanvas>
				<div class="inner-wrap">

          <?php pf_the_page_menu(); ?>

					<section class="main-section" data-equalizer>
  	
						<?php
							$display_sidebars = get_theme_mod( 'pf_display_sidebars' );
							$left_sidebar = is_active_sidebar( 'left' );
							$right_sidebar = is_active_sidebar( 'primary' );
						?>

						<?php if ( $display_sidebars && $left_sidebar ) : ?>
							<div class="pf-left-sidebar hide-for-medium-down large-3 columns" data-equalizer-watch>
								<?php dynamic_sidebar( 'left' ); ?>
							</div>
						<?php endif; ?>

						<?php if ( $display_sidebars && $left_sidebar && $right_sidebar ) : ?>
							<div id="pf-middle-content" class="large-6 columns" data-equalizer-watch>
						<?php elseif ( ( $display_sidebars && $left_sidebar && !$right_sidebar ) || ( $display_sidebars && !$left_sidebar && $right_sidebar ) ) : ?>
							<div id="pf-middle-content" class="large-9 columns" data-equalizer-watch>
						<?php else : ?>
							<div id="pf-middle-content" class="large-12 columns" data-equalizer-watch>
						<?php endif; ?>

						<article class="<?php echo pf_remove_hentry_class( get_post_class(), 'pf-full-post'); ?>">
							<header class="pf-full-post-header">
								<h2 class="entry-title"><?php _e('Oops! Page Not Found', 'planet-foundation'); ?></h2>
							</header>
							<div class="entry-content">
									<div class="error">
										<p class="bottom">
											<?php _e('This page might have been deleted, had its name changed, or is temporarily unavailable.', 'planet-foundation'); ?></p>
									</div>
									<p><?php _e('Are any of these options ever useful?  Well you can give them a try anyway:', 'planet-foundation'); ?></p>
									<ul class="panel"> 
										<li><?php _e('Check your spelling', 'planet-foundation'); ?></li>
										<li><?php printf(__('Return to the <a href="%s">home page</a>', 'planet-foundation'), home_url()); ?></li>
										<li><?php _e('Click the <a href="javascript:history.back()">Back</a> button', 'planet-foundation'); ?></li>
									</ul>
							</div>
						</article>

						</div>

						<?php if ( $display_sidebars && $right_sidebar ) : ?>
							<div class="pf-right-sidebar hide-for-medium-down large-3 columns" data-equalizer-watch>
								<?php dynamic_sidebar( 'primary' ); ?>
							</div>
						<?php endif; ?>

          </section><!-- .main-section -->

				</div><!-- .inner-wrap -->
			</div><!-- .off-canvas-wrap -->

		  </div><!-- #pf-main-content-container -->
		</div><!-- #pf-main-content-container-column -->
	</div><!-- #pf-main-content-container-row -->

<?php get_footer(); ?>