<?php
global $plain_fields;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
<head>
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<?php
//	Front page title
if (is_front_page() == TRUE)
{
	//	If we are on 2nd, 3rd,... page, add "Page 1" to the title.
	if (is_paged() == TRUE)
	{
		$ltw_pf_title = $plain_fields->get_current_subpage().$plain_fields->get_title_separator().$plain_fields->show_blog_description_title().get_bloginfo('name');
	}
	else
	{
		$ltw_pf_title = $plain_fields->show_blog_description_title().get_bloginfo('name');
	}
}
//	404 error page title
else if (is_404() == TRUE)
{
	$ltw_pf_title = __('Oops, page not found', LTW_PLAIN_FIELDS_UN).$plain_fields->get_title_separator().get_bloginfo('name');
}
//	Search pages title
else if (is_search() == TRUE)
{
	$ltw_pf_title = __('Search results for:', LTW_PLAIN_FIELDS_UN).' '.esc_attr(get_search_query()).$plain_fields->get_title_separator().get_bloginfo('name');
}
//	Title for the rest of the pages
else
{
	$ltw_pf_title = wp_title($plain_fields->get_title_separator(), FALSE, 'right').$plain_fields->get_current_subpage(TRUE, 'right').get_bloginfo('name');
}
?>
<title><?php echo $ltw_pf_title; ?></title>
<?php
$ltw_pl_meta_description = '';

//	Display meta description for front page
if (is_home() == TRUE && $plain_fields->get_front_page_meta_description() !== FALSE)
{
	$ltw_pl_meta_description = $plain_fields->get_front_page_meta_description().$plain_fields->get_current_subpage(TRUE);
}
//	Else display meta description if its set up on pages or posts only!
else if (is_single() == TRUE || is_page() == TRUE)
{
	if ($plain_fields->get_custom_meta_description() != '')
	{
		$ltw_pl_meta_description = $plain_fields->get_custom_meta_description().$plain_fields->get_current_subpage(TRUE);
	}
}

if ($ltw_pl_meta_description != '')
{
?>
<meta name="description" content="<?php echo $ltw_pl_meta_description; ?>" />
<?php
}

$ltw_pl_meta_keywords = '';

//	Display meta keywords for front page
if (is_home() == TRUE && $plain_fields->get_front_page_meta_keywords() !== FALSE)
{
	$ltw_pl_meta_keywords = $plain_fields->get_front_page_meta_keywords();
}
//	Else display meta keywords for current page if there are any
else if (is_single() == TRUE || is_page() == TRUE)
{
	if ($plain_fields->get_custom_meta_keywords() != '')
	{
		$ltw_pl_meta_keywords =  $plain_fields->get_custom_meta_keywords();
	}
}

if ($ltw_pl_meta_keywords != '')
{
?>
<meta name="keywords" content="<?php echo $ltw_pl_meta_keywords; ?>" />
<?php
}
?>
<link rel="stylesheet" type="text/css" href="<?php bloginfo('stylesheet_url'); ?>" />
<?php
if ($plain_fields->rss_feed() == FALSE)
{
?>
<link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php bloginfo('rss_url'); ?>" />
<?php
}
else
{
?>
<link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php echo $plain_fields->rss_feed(); ?>" />
<?php
}
?>
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<meta name="themename" content="<?php echo $plain_fields->ltw_theme_name.' '.$plain_fields->ltw_theme_version; ?>" />
<meta name="createdby" content="http://www.lessthanweb.com" />
<?php
//	Will output robots meta..
echo $plain_fields->set_privacy();

if (is_singular() && get_option('thread_comments'))
	wp_enqueue_script('comment-reply');

wp_head();
?>
</head>
<body <?php body_class(); ?>>

<div id="wrapper">

	<div id="top_cont">
		<div id="tc_title">
<?php
//	Add text color style if its different from default
?>
			<div><a href="<?php echo home_url(); ?>" style="color: #<?php header_textcolor(); ?>"><?php bloginfo('name'); ?></a></div>
<?php
if ($plain_fields->hide_top_tagline() == FALSE)
{
?>
			<p style="color: #<?php header_textcolor(); ?>"><?php bloginfo('description'); ?></p>
<?php
}
?>
		</div>
		<div id="tc_search_cont">

			<div id="tc_search_form">
				<form method="get" action="<?php echo home_url(); ?>">
					<div>
						<input type="text" name="s" id="search_box_input" value="" />
						<input type="image" id="search_box_submit" src="<?php echo get_template_directory_uri(); ?>/images/search_button.png" alt="<?php _e('Search', LTW_PLAIN_FIELDS_UN); ?>"/>
					</div>
				</form>
			</div>

			<div id="tc_sc_cont">
<?php
if ($plain_fields->hide_rss_icon() == FALSE)
{
?>
				<div id="tc_sc_rss"><a href="<?php bloginfo('rss_url'); ?>"><img id="rss_icon" class="rss_sprite" src="<?php echo get_template_directory_uri(); ?>/images/blank.gif" alt="<?php _e('RSS Feed', LTW_PLAIN_FIELDS_UN); ?>"/></a></div>
<?php
}
?>
			</div>
		</div>
	</div><?php //	end #top_cont ?>

	<div id="top_menu">
		<div id="menu_cont">
			<?php wp_nav_menu(array('container' => '', 'theme_location'  => 'primary', 'fallback_cb' => 'ltw_pl_wp_nav_menu_fallback')); ?>
		</div>
	</div><?php	//	end #top_menu ?>

	<div id="mt_separator"></div>

<?php
//	Output teaser text
echo $plain_fields->output_teaser_text('<div id="tagline">', '</div>');
?>