<?php
//	Unique name used for translations..
define('LTW_PLAIN_FIELDS_UN', 'LTW_Plain_Fields');

//	Include the classes for admin pages
if (is_file(STYLESHEETPATH.'/admin/admin.php'))
	require_once(STYLESHEETPATH.'/admin/admin.php');
else
	require_once(TEMPLATEPATH.'/admin/admin.php');

if (!isset($content_width))
	$content_width = 700;

/**
 * Returns number of comments only, ignoring the pings
 *
 */
function ltw_pf_comment_count($count)
{
	global $id;

	$comments_by_type = &separate_comments(get_comments('status=approve&post_id=' . $id));

	return count($comments_by_type['comment']);
}
add_filter('get_comments_number', 'ltw_pf_comment_count', 0);

/**
 * Returns number of pings only, ignoring the comments
 *
 */
function ltw_pf_pings_count()
{
	global $id;

	$comments_by_type = &separate_comments(get_comments('status=approve&post_id='.$id));

	return count($comments_by_type['pings']);
}

/**
 * Displays the comments
 *
 */
function ltw_pf_list_comments($comment, $args, $depth)
{
	global $post;

	$GLOBALS['comment'] = $comment;

	if ($comment->comment_type == '')
	{
?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>">
			<div class="comment_info">
				<div class="comment_gravatar"><?php echo get_avatar($comment, 24); ?></div>
				<div class="comment_author"><?php printf(__('On <span>%1$s</span> at <span>%2$s</span> %3$s said', LTW_PLAIN_FIELDS_UN), get_comment_date(), get_comment_time(), get_comment_author_link()); ?> <?php edit_comment_link(__('(Edit)', LTW_PLAIN_FIELDS_UN), ' '); ?></div>
			</div>
			<div class="comment_body">
<?php
		if ($comment->comment_approved == '0')
		{
?>
						<p><strong><?php _e('Your comment is waiting for approval.', LTW_PLAIN_FIELDS_UN); ?></strong></p>
<?php
		}
?>
				<?php comment_text(); ?>
				<p>
					<?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); ?>
				</p>
			</div>
		</div>
<?php
	}
}

/**
 * Display the pings
 *
 */
function ltw_pf_list_pings($comment, $args, $depth)
{
	global $post;

	$GLOBALS['comment'] = $comment;

	if ($comment->comment_type == 'pingback' || $comment->comment_type == 'trackback')
	{
?>
	<li <?php comment_class(); ?>>
		<p><?php comment_author_link(); ?><?php edit_comment_link(__('(Edit)', LTW_PLAIN_FIELDS_UN), ' '); ?></p>
<?php
	}
}

/**
 * Fallback function for menu
 *
 */
function ltw_pl_wp_nav_menu_fallback()
{
	global $plain_fields;

	$plain_fields->wp_nav_menu_fallback();
}

/**
 * Replace default WP RSS feed url to a custom one
 *
 */
function ltw_rss_feed($output, $feed)
{
	global $plain_fields;

	if ($plain_fields->rss_feed() == FALSE)
	{
		$feed_url = $output;
	}
	else
	{
		$feed_url = $plain_fields->rss_feed();
	}

	$feed_array = array('rss' => $feed_url, 'rss2' => $feed_url, 'atom' => $feed_url, 'rdf' => $feed_url, 'comments_rss2' => '');
	$feed_array[$feed] = $feed_url;
	$output = $feed_array[$feed];

	return $output;
}
add_filter('feed_link', 'ltw_rss_feed', 1, 2);
?>