<?php
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die('Please do not load this page directly. Thanks!');
?>
<div id="comments_cont">
<?php
if (post_password_required() == TRUE)
{
?>
	<p class="nopassword"><?php _e('This post is password protected. Enter the password to view any comments.', LTW_PLAIN_FIELDS_UN); ?></p>
</div>
<?php
	return;
}

if (have_comments())
{
?>
	<h2><?php printf(_n('1 Comment', '%1$s Comments', get_comments_number(), LTW_PLAIN_FIELDS_UN), number_format_i18n(get_comments_number())); ?></h2>
	<a name="comments"></a>
	<ul class="comment">
		<?php wp_list_comments('type=comment&callback=ltw_pf_list_comments'); ?>
	</ul>
<?php
	if (get_comment_pages_count() > 1 && get_option('page_comments'))
	{
?>
	<div id="comments_navigation">
		<div><?php previous_comments_link(__('<span class="meta-nav">&larr;</span> Older Comments', LTW_PLAIN_FIELDS_UN)); ?></div>
		<div><?php next_comments_link(__('Newer Comments <span class="meta-nav">&rarr;</span>', LTW_PLAIN_FIELDS_UN)); ?></div>
	</div>
<?php
	}
}
else
{
	//	No comments yet
	if (comments_open())
	{
?>
	<h2><?php _e('0 Comments', LTW_PLAIN_FIELDS_UN); ?></h2>
	<p><?php _e('You can be the first to comment!', LTW_PLAIN_FIELDS_UN); ?></p>
<?php
	}
}

comment_form();

if (have_comments())
{
	if (ltw_pf_pings_count() > 0)
	{
?>
	<h3><?php _e('Pingbacks / Trackbacks', LTW_PLAIN_FIELDS_UN); ?></h3>
	<ul id="pings">
		<?php wp_list_comments('type=pings&callback=ltw_pf_list_pings&per_page=100'); ?>
	</ul>
<?php
	}
}
?>
</div>