<?php
/**
 * Core class
 *
 */
class ltw_core
{
	var $ltw_theme_folder = 'plain-fields';
	var $ltw_theme_name = 'Plain Fields';
	var $ltw_theme_version = '1.1.1';
	var $ltw_theme_pro = FALSE;

	var $ltw_menu = array();
	var $ltw_meta_box = array();
	var $ltw_set_styles = array();
	var $ltw_set_styles_extra = array();
	var $ltw_set_scripts = array();
	var $ltw_set_scripts_extra = array();

	var $ltw_page_options = array();

	/**
	 * PHP 4 Constructor
	 * Come on server admins, upgrade to 5 already!! :)
	 */
	function ltw_core()
	{
		add_action('admin_menu', array(&$this, 'create_admin_menu'));
		add_action('admin_init', array(&$this, 'register_settings'));
		add_action('add_meta_boxes', array(&$this, 'create_meta_box'));
		add_action('save_post', array(&$this, 'save_meta_box'));
		add_action('admin_enqueue_scripts', array(&$this, 'extra_stylesheet'), 10, 1);
		add_action('after_setup_theme', array(&$this, 'create_menu_navigation'));
		add_action('widgets_init', array(&$this, 'widgets_setup'));

		add_shortcode('columns', array(&$this, 'column_shortcode'));

		add_theme_support('automatic-feed-links');
		add_theme_support('post-thumbnails');

		//	Make theme available for translation
		if (file_exists(STYLESHEETPATH.'/languages'))
			$language_folder = (STYLESHEETPATH.'/languages');
		else
			$language_folder = (TEMPLATEPATH.'/languages');

		load_theme_textdomain(LTW_PLAIN_FIELDS_UN, $language_folder);

		$locale = get_locale();

		$locale_file = $language_folder.'/'.$locale.'.php';

		if (is_readable($locale_file))
			require_once($locale_file);

		define('HEADER_TEXTCOLOR', '030303');
		define('HEADER_IMAGE', '%s/images/header_background.png');

		define('HEADER_IMAGE_WIDTH', apply_filters('plainfields_header_image_width', 940));
		define('HEADER_IMAGE_HEIGHT', apply_filters('plainfields_header_image_height', 100));

		add_custom_image_header(array(&$this, 'custom_header_image'), array(&$this, 'custom_admin_header_image'));
	}

	/**
	 * Set primary menu navigation
	 *
	 */
	function create_menu_navigation()
	{
		//	Register the menu in one area
		register_nav_menus(
			array(
				'primary' => __('Primary Navigation', LTW_PLAIN_FIELDS_UN),
			)
		);
	}

	/**
	 * Setup widget areas
	 *
	 */
	function widgets_setup()
	{
		// All pages
		register_sidebar(
			array(
				'name' => __('Sidebar - All Pages', LTW_PLAIN_FIELDS_UN),
				'id' => 'all-pages-widget-area',
				'description' => __('Sidebar - All Pages', LTW_PLAIN_FIELDS_UN),
				'before_widget' => '<div class="widget_cont">',
				'after_widget' => '</div>',
				'before_title' => '<h3>',
				'after_title' => '</h3>',
			)
		);

		// Front page only
		register_sidebar(
			array(
				'name' => __('Sidebar - Front Page Only', LTW_PLAIN_FIELDS_UN),
				'id' => 'front-page-widget-area',
				'description' => __('Sidebar - Front Page Only', LTW_PLAIN_FIELDS_UN),
				'before_widget' => '<div class="widget_cont">',
				'after_widget' => '</div>',
				'before_title' => '<h3>',
				'after_title' => '</h3>',
			)
		);

		// Pages only
		register_sidebar(
			array(
				'name' => __('Sidebar - Pages Only', LTW_PLAIN_FIELDS_UN),
				'id' => 'pages-only-widget-area',
				'description' => __('Sidebar - Pages Only', LTW_PLAIN_FIELDS_UN),
				'before_widget' => '<div class="widget_cont">',
				'after_widget' => '</div>',
				'before_title' => '<h3>',
				'after_title' => '</h3>',
			)
		);

		// Blog posts
		register_sidebar(
			array(
				'name' => __('Sidebar - Posts Only', LTW_PLAIN_FIELDS_UN),
				'id' => 'posts-only-widget-area',
				'description' => __('Sidebar - Posts Only', LTW_PLAIN_FIELDS_UN),
				'before_widget' => '<div class="widget_cont">',
				'after_widget' => '</div>',
				'before_title' => '<h3>',
				'after_title' => '</h3>',
			)
		);
	}

	/**
	 * Creates admin menu
	 *
	 */
	function create_admin_menu()
	{
		if (count($this->ltw_menu) > 0)
		{
			foreach ($this->ltw_menu as $menu_item)
			{
				if ($menu_item['type'] == 'menu')
				{
					//	Creates main menu
					add_menu_page($menu_item['page_title'], $menu_item['menu_title'], $menu_item['capability'], $menu_item['menu_slug'], array(&$this, $menu_item['function']), $menu_item['icon']);
				}
				else
				{
					//	Create submenu
					$ltw_submenu[$menu_item['menu_slug']] = add_submenu_page($menu_item['parent_slug'], $menu_item['page_title'], $menu_item['menu_title'], $menu_item['capability'], $menu_item['menu_slug'], array(&$this, $menu_item['function']));

					//	Print admin JS
					add_action('admin_print_scripts-'.$ltw_submenu[$menu_item['menu_slug']], array(&$this, 'print_admin_scripts'));

					//	Print admin CSS style
					add_action('admin_print_styles-'.$ltw_submenu[$menu_item['menu_slug']], array(&$this, 'print_admin_styles'));
				}
			}
		}
	}

	/**
	 * Print admin styles
	 *
	 */
	function print_admin_styles()
	{
		if (count($this->ltw_set_styles) > 0)
		{
			foreach ($this->ltw_set_styles as $style_item)
			{
				if ($style_item['type'] == 'custom')
				{
					//	Custom style
					wp_enqueue_style($style_item['name'], $style_item['url'], $style_item['depends_on'], $style_item['version'], $style_item['media']);
				}
				else
				{
					//	Load style that comes with WP
					wp_enqueue_style($style_item['name']);
				}
			}
		}
	}

	/**
	 * Print admin scripts
	 *
	 */
	function print_admin_scripts()
	{
		if (count($this->ltw_set_scripts) > 0)
		{
			foreach ($this->ltw_set_scripts as $script_item)
			{
				if ($script_item['type'] == 'custom')
				{
					//	Custom JS
					wp_enqueue_script($script_item['name'], $script_item['url'], $script_item['depends_on'], $script_item['version'], $script_item['in_footer']);
				}
				else
				{
					//	Load script that comes with WP
					wp_enqueue_script($script_item['name']);
				}
			}
		}
	}

	/**
	 * Display the "PRO" image
	 *
	 */
	function pro_img($pro_only = FALSE)
	{
		if ($pro_only == TRUE)
		{
			return '<img src="'.get_template_directory_uri().'/admin/images/pro_icon.png" alt="This function is available only in the PRO version of this theme" title="This function is available only in the PRO version of this theme" style="vertical-align: middle;"/>';
		}

		return '';
	}

	/**
	 * Disables the field if its for pro only
	 *
	 */
	function pro_field($pro_only = FALSE)
	{
		if ($pro_only == TRUE)
		{
			return 'disabled="disabled"';
		}

		return '';
	}

	/**
	 * Output the HTML in the admin area
	 *
	 */
	function build_html($form_name)
	{
		if (count($this->ltw_page_options) > 0)
		{
?>
<form method="post" action="">
	<div>
		<?php wp_nonce_field('ltw_submit_form_nonce'); ?>
		<input type="hidden" name="form_submit" value="yes"/>
	</div>
	<div id="ltw_theme_container" class="wrap form-table">
		<div id="header_cont">
			<div id="hc_theme_cont">
				<div id="name"><?php echo $this->ltw_theme_name; ?></div>
				<div id="version"><?php _e('version', LTW_PLAIN_FIELDS_UN); ?> <?php echo $this->ltw_theme_version; ?></div>
			</div>
			<div id="hc_theme_by">Theme by <a href="http://www.lessthanweb.com">LessThanWeb</a></div>
		</div>
		<div id="ltw_menu">
			<a href="http://www.lessthanweb.com/contact">Support</a>
<?php
			if ($this->ltw_theme_pro == FALSE)
			{
?>
			<a href="http://www.lessthanweb.com/products/plain-fields">Buy Now</a>
<?php
			}
?>
		</div>
		<div id="options_cont">
<?php
			if ($this->ltw_theme_pro == FALSE)
			{
?>
			<div id="ltw_go_pro">
				<div id="left">Go Pro!</div>
				<div id="right">
					<p>You are currently using the free version of the theme &quot;<?php echo $this->ltw_theme_name; ?>&quot;.</p>
					<p>If you wish to have access to all the features shown below then Go Pro!</p>
					<p>Pro version unlocks all the features and you can use it on unlimited number of sites.</p>
					<p><a href="http://www.lessthanweb.com/products/plain-fields">Go Pro now</a>.</p>
				</div>
			</div>
<?php
			}

			$form_cont = $this->ltw_page_options;

			foreach ($form_cont[$form_name] as $option)
			{
				switch($option['type'])
				{
					//	h3 header
					case 'header':
?>
			<h3><?php echo esc_html(stripslashes($option['title'])); ?></h3>
<?php
					break;

					//	h4 header
					case 'subheader':
?>
			<h4><?php echo esc_html(stripslashes($option['title'])); ?></h4>
<?php
					break;

					//	note
					case 'note':
?>
			<div class="ltw_note">
				<div class="left">Note!</div>
				<div class="right"><?php echo $option['title']; ?></div>
			</div>
<?php
					break;

					//	Media upload
					case 'upload':
?>
			<div class="field_cont">
				<div class="field">
					<p><?php echo esc_html(stripslashes($option['title'])).' '.$this->pro_img($option['pro_only']); ?></p>
					<input id="<?php echo $option['field_id']; ?>_img" type="text" size="36" name="<?php echo $option['field_name']; ?>" value="<?php echo $this->pro_field($option['pro_only']) != '' ? $option['field_value'] : esc_html(stripslashes($this->load_option($form_name, $option['field_name']) == FALSE ? $option['field_value'] : $this->load_option($form_name, $option['field_name']))); ?>" <?php echo $this->pro_field($option['pro_only']); ?>/>
					<input id="<?php echo $option['field_id']; ?>_button" alt="<?php echo $option['field_id']; ?>" type="button" class="upload_button" value="<?php _e('Upload', LTW_PLAIN_FIELDS_UN); ?>" <?php echo $this->pro_field($option['pro_only']); ?>/>
				</div>
<?php
						if ($option['help'] != '')
						{
?>
				<div class="help">
					<p><?php echo $option['help']; ?></p>
				</div>
<?php
						}
?>
			</div>
<?php
					break;

					//	Text field
					case 'text':
?>
			<div class="field_cont">
				<div class="field">
					<p><?php echo esc_html(stripslashes($option['title'])).' '.$this->pro_img($option['pro_only']); ?></p>
					<input name="<?php echo $option['field_name']; ?>" id="<?php echo $option['field_id']; ?>" type="text" class="<?php echo $option['field_class']; ?>" value="<?php echo $this->pro_field($option['pro_only']) != '' ? $option['field_value'] : esc_html(stripslashes($this->load_option($form_name, $option['field_name']) == FALSE ? $option['field_value'] : $this->load_option($form_name, $option['field_name']))); ?>" <?php echo $this->pro_field($option['pro_only']); ?>/>
				</div>
<?php
						if ($option['help'] != '')
						{
?>
				<div class="help">
					<p><?php echo $option['help']; ?></p>
				</div>
<?php
						}
?>
			</div>
<?php
					break;

					//	Textarea field
					case 'textarea':
?>
			<div class="field_cont">
				<div class="field">
					<p><?php echo esc_html(stripslashes($option['title'])).' '.$this->pro_img($option['pro_only']); ?></p>
					<textarea cols="0" rows="0" style="width: 450px; height: 150px;" name="<?php echo $option['field_name']; ?>" id="<?php echo $option['field_id']; ?>" class="<?php echo $option['field_class']; ?>" <?php echo $this->pro_field($option['pro_only']); ?>><?php echo $this->pro_field($option['pro_only']) != '' ? $option['field_value'] : esc_html(stripslashes($this->load_option($form_name, $option['field_name']) == FALSE ? $option['field_value'] : $this->load_option($form_name, $option['field_name']))); ?></textarea>
				</div>
<?php
						if ($option['help'] != '')
						{
?>
				<div class="help">
					<p><?php echo $option['help']; ?></p>
				</div>
<?php
						}
?>
			</div>
<?php
					break;

					//	Checkbox field
					case 'checkbox':
						$checked = '';
						$hidden_value = '';

						if ($this->load_option($form_name, $option['field_name']) == FALSE || $this->pro_field($option['pro_only']) != '')
						{
							$checked = $option['field_checked'] == TRUE ? ' checked="checked"' : '';
							$hidden_value = $option['field_checked'] == TRUE ? esc_html(stripslashes($option['field_value'])) : '';
						}
						else
						{
							$checked = $this->load_option($form_name, $option['field_name']) != '' ? ' checked="checked"' : '';
							$hidden_value = $this->load_option($form_name, $option['field_name']) != '' ? esc_html(stripslashes($option['field_value'])) : '';
						}
?>
			<div class="field_cont">
				<div class="field">
					<p><?php echo esc_html(stripslashes($option['title'])).' '.$this->pro_img($option['pro_only']); ?></p>
					<label for="<?php echo $option['field_id']; ?>"><input name="<?php echo $option['field_name']; ?>" id="<?php echo $option['field_id']; ?>" class="ltw_checkbox" type="checkbox" value="<?php echo esc_html(stripslashes($option['field_value'])); ?>"<?php echo $checked; ?> <?php echo $this->pro_field($option['pro_only']); ?>/> <span<?php echo $this->pro_field($option['pro_only']) != '' ? ' class="span_disabled"' : ''; ?>><?php echo esc_html(stripslashes($option['field_text'])); ?></span></label>
					<input name="<?php echo $option['field_name']; ?>_checkbox" id="<?php echo $option['field_id']; ?>_checkbox" type="hidden" value="<?php echo $hidden_value; ?>" />
				</div>
<?php
						if ($option['help'] != '')
						{
?>
				<div class="help">
					<p><?php echo $option['help']; ?></p>
				</div>
<?php
						}
?>
			</div>
<?php
					break;

					//	Select field
					case 'select':
?>
			<div class="field_cont">
				<div class="field">
					<p><?php echo esc_html(stripslashes($option['title'])).' '.$this->pro_img($option['pro_only']); ?></p>
					<select name="<?php echo $option['field_name']; ?>" id="<?php echo $option['field_id']; ?>" <?php echo $this->pro_field($option['pro_only']); ?>>
<?php
						if (count($option['field_options']) > 0)
						{
							foreach ($option['field_options'] as $select_option)
							{
								$selected = '';
								if ($this->load_option($form_name, $option['field_name']) == FALSE || $this->pro_field($option['pro_only']) != '')
								{
									$selected = $select_option['selected'] == TRUE ? ' selected="selected"' : '';
								}
								else
								{
									$selected = $this->load_option($form_name, $option['field_name']) == $select_option['value'] ? ' selected="selected"' : '';
								}
?>
						<option value="<?php echo $select_option['value']; ?>"<?php echo $selected; ?>><?php echo esc_html(stripslashes($select_option['text'])); ?></option>
<?php
							}
						}
?>
					</select>
				</div>
<?php
						if ($option['help'] != '')
						{
?>
				<div class="help">
					<p><?php echo $option['help']; ?></p>
				</div>
<?php
						}
?>
			</div>
<?php
					break;

					//	Radio field
					case 'radio':
?>
			<div class="field_cont">
				<div class="field">
					<p><?php echo esc_html(stripslashes($option['title'])).' '.$this->pro_img($option['pro_only']); ?></p>
<?php
						if (count($option['field_options']) > 0)
						{
							foreach ($option['field_options'] as $radio_option)
							{
								$checked = '';
								if ($this->load_option($form_name, $option['field_name']) == FALSE || $this->pro_field($option['pro_only']) != '')
								{
									$checked = $radio_option['checked'] == TRUE ? ' checked="checked"' : '';
								}
								else
								{
									$checked = $this->load_option($form_name, $option['field_name']) == $radio_option['value'] ? ' checked="checked"' : '';
								}
?>
						<div><label for="<?php echo $radio_option['id']; ?>"><input name="<?php echo $option['field_name']; ?>" id="<?php echo $radio_option['id']; ?>" class="ltw_radio" type="radio" value="<?php echo esc_html(stripslashes($radio_option['value'])); ?>"<?php echo $checked; ?> <?php echo $this->pro_field($option['pro_only']); ?>/> <span<?php echo $this->pro_field($option['pro_only']) != '' ? ' class="span_disabled"' : ''; ?>><?php echo esc_html(stripslashes($radio_option['text'])); ?></span></label></div>
<?php
							}
						}
?>
				</div>
<?php
						if ($option['help'] != '')
						{
?>
				<div class="help">
					<p><?php echo $option['help']; ?></p>
				</div>
<?php
						}
?>
			</div>
<?php
					break;
				} // switch
			}
?>
			<div class="button_cont">
				<input type="submit" class="button submit-button" value="<?php _e('Save Changes', LTW_PLAIN_FIELDS_UN); ?>">
			</div>
		</div>
	</div>
</form>
<?php
		}
	}

	/**
	 * Register settings
	 *
	 */
	function register_settings()
	{
		register_setting($this->ltw_theme_folder, 'ltw_pf_settings');
	}

	/**
	 * If form submitted, update data
	 *
	 */
	function check_form($form_name)
	{
		//	Was form submitted?
		if (isset($_POST['form_submit']) && $_POST['form_submit'] == 'yes')
		{
			check_admin_referer('ltw_submit_form_nonce');

			$page_options = $this->ltw_page_options;

			$fields[$form_name] = array();

			//	Loop over form items array
			foreach ($page_options[$form_name] as $page_key => $page_item)
			{
				if (isset($page_item['field_name']) == TRUE && isset($_POST[$page_item['field_name']]) == TRUE)
				{
					//	Set the value
					$fields[$form_name][$page_item['field_name']] = $_POST[$page_item['field_name']];

					//	Also set the checked value to TRUE if the key exist
					if (isset($page_options[$form_name][$page_key]['field_checked']) == TRUE)
					{
						//	Set the value
						$fields[$form_name][$page_item['field_name']] = $_POST[$page_item['field_name']];
					}
				}
				else if (isset($page_item['field_name']) == TRUE)
				{
					//	Checkbox?
					if (isset($_POST[$page_item['field_name'].'_checkbox']) == TRUE)
					{
						//	Set the value as empty
						$fields[$form_name][$page_item['field_name']] = '';
					}
				}
			}

			//	First, let's load all the settings
			$settings = get_option('ltw_pf_settings');

			//	Update the array in questions
			$settings[$form_name] = $fields[$form_name];

			//	Update option
			update_option('ltw_pf_settings', $settings);
		}

		return '';
	}

	/**
	 * Find the requested setting and return it
	 *
	 */
	function load_option($category, $option)
	{
		$options = get_option('ltw_pf_settings');

		if (isset($options[$category][$option]) == TRUE)
		{
			return $options[$category][$option];
		}

		return FALSE;
	}

	/**
	 * Create meta box.
	 *
	 */
	function create_meta_box()
	{
		$options = $this->ltw_meta_box;

		if (count($options) > 0)
		{
			foreach ($options as $option)
			{
				foreach ($option['page'] as $type)
				{
					add_meta_box($option['html_id'], $option['title'], array(&$this, 'build_meta_box'), $type, $option['context'], $option['priority']);
				}
			}
		}
	}

	/**
	 * Build meta box HTML
	 *
	 */
	function build_meta_box()
	{
		global $post;

		$options = $this->ltw_meta_box;

		if (count($options) > 0)
		{
?>
<div id="pl_post_new">
<?php
			foreach ($options as $option)
			{
				if (count($option['fields']) > 0)
				{
					foreach ($option['fields'] as $field)
					{
						if ($field['show_on'] == 'all' || $post->post_type == $field['show_on'])
						{
							switch($field['type'])
							{
								case 'nonce':
									echo '<input type="hidden" name="'.$field['field_name'].'" id="'.$field['field_name'].'" value="'.wp_create_nonce(plugin_basename(__FILE__)).'" />';
								break;

								case 'text':
?>
	<div class="field_cont">
		<div class="field">
			<p><?php echo esc_html(stripslashes($field['title'])).' '.$this->pro_img($field['pro_only']); ?></p>
			<input name="<?php echo $field['field_name']; ?>" style="width:<?php echo $field['field_width']; ?>;" id="<?php echo $field['field_id']; ?>" type="text" class="<?php echo $field['field_class']; ?>" value="<?php echo $this->pro_field($field['pro_only']) != '' ? $field['field_value'] : esc_html(stripslashes(get_post_meta($post->ID, $field['field_name'], TRUE))); ?>" <?php echo $this->pro_field($field['pro_only']); ?>/>
		</div>
<?php
									if ($field['help'] != '')
									{
?>
		<div class="help">
			<p><?php echo $field['help']; ?></p>
		</div>
<?php
									}
?>
	</div>
<?php
								break;

								//	Textarea field
								case 'textarea':
?>
	<div class="field_cont">
		<div class="field">
			<p><?php echo esc_html(stripslashes($field['title'])).' '.$this->pro_img($field['pro_only']); ?></p>
			<textarea cols="0" rows="0" style="width: <?php echo $field['field_width']; ?>; height: 70px;" name="<?php echo $field['field_name']; ?>" id="<?php echo $field['field_id']; ?>" class="<?php echo $field['field_class']; ?>" <?php echo $this->pro_field($field['pro_only']); ?>><?php echo $this->pro_field($field['pro_only']) != '' ? $field['field_value'] : esc_html(stripslashes(get_post_meta($post->ID, $field['field_name'], TRUE))); ?></textarea>
		</div>
<?php
									if ($field['help'] != '')
									{
?>
		<div class="help">
			<p><?php echo $field['help']; ?></p>
		</div>
<?php
									}
?>
	</div>
<?php
								break;

								//	Media upload
								case 'upload':
?>
			<div class="field_cont">
				<div class="field">
					<p><?php echo esc_html(stripslashes($field['title'])).' '.$this->pro_img($field['pro_only']); ?></p>
					<input id="<?php echo $field['field_id']; ?>_img" type="text" size="36" name="<?php echo $field['field_name']; ?>" value="<?php echo $this->pro_field($field['pro_only']) != '' ? $field['field_value'] : esc_html(stripslashes(get_post_meta($post->ID, $field['field_name'], TRUE))); ?>" <?php echo $this->pro_field($field['pro_only']); ?>/>
					<input name="button_<?php echo $post->ID; ?>" id="<?php echo $field['field_id']; ?>_button" alt="<?php echo $field['field_id']; ?>" type="button" class="upload_button" value="<?php _e('Upload', LTW_PLAIN_FIELDS_UN); ?>" <?php echo $this->pro_field($field['pro_only']); ?>/>
				</div>
<?php
									if ($field['help'] != '')
									{
?>
				<div class="help">
					<p><?php echo $field['help']; ?></p>
				</div>
<?php
									}
?>
			</div>
<?php
								break;

								//	Checkbox field
								case 'checkbox':
									$checked = '';
									$hidden_value = '';

									if (get_post_meta($post->ID, $field['field_name'], TRUE) == '' || $this->pro_field($field['pro_only']) != '')
									{
										$checked = $field['field_checked'] == TRUE ? ' checked="checked"' : '';
										$hidden_value = $field['field_checked'] == TRUE ? esc_html(stripslashes($field['field_value'])) : '';
									}
									else
									{
										$checked = get_post_meta($post->ID, $field['field_name'], TRUE) != '' ? ' checked="checked"' : '';
										$hidden_value = get_post_meta($post->ID, $field['field_name'], TRUE) != '' ? esc_html(stripslashes($field['field_value'])) : '';
									}
?>
			<div class="field_cont">
				<div class="field">
					<p><?php echo esc_html(stripslashes($field['title'])).' '.$this->pro_img($field['pro_only']); ?></p>
					<label for="<?php echo $field['field_id']; ?>"><input name="<?php echo $field['field_name']; ?>" id="<?php echo $field['field_id']; ?>" class="ltw_checkbox" type="checkbox" value="<?php echo esc_html(stripslashes($field['field_value'])); ?>"<?php echo $checked; ?> <?php echo $this->pro_field($field['pro_only']); ?>/> <span<?php echo $this->pro_field($field['pro_only']) != '' ? ' class="span_disabled"' : ''; ?>><?php echo esc_html(stripslashes($field['field_text'])); ?></span></label>
					<input name="<?php echo $field['field_name']; ?>_checkbox" id="<?php echo $field['field_id']; ?>_checkbox" type="hidden" value="<?php echo $hidden_value; ?>" />
				</div>
<?php
									if ($field['help'] != '')
									{
?>
				<div class="help">
					<p><?php echo $field['help']; ?></p>
				</div>
<?php
									}
?>
			</div>
<?php
								break;
							}
						}
					}
				}
			}
?>
</div>
<?php
		}
	}

	/**
	 * Function that adds stylesheet to extra non-theme pages
	 *
	 */
	function extra_stylesheet($hook)
	{
		if ($hook == 'post.php' || $hook == 'post-new.php')
		{
		   	if (count($this->ltw_set_scripts_extra) > 0)
			{
				foreach ($this->ltw_set_scripts_extra as $script_item)
				{
					if ($script_item['type'] == 'custom')
					{
						//	Custom JS
						wp_enqueue_script($script_item['name'], $script_item['url'], $script_item['depends_on'], $script_item['version'], $script_item['in_footer']);
					}
					else
					{
						//	Load script that comes with WP
						wp_enqueue_script($script_item['name']);
					}
				}
			}

			if (count($this->ltw_set_styles_extra) > 0)
			{
				foreach ($this->ltw_set_styles_extra as $style_item)
				{
					if ($style_item['type'] == 'custom')
					{
						//	Custom style
						wp_enqueue_style($style_item['name'], $style_item['url'], $style_item['depends_on'], $style_item['version'], $style_item['media']);
					}
					else
					{
						//	Load style that comes with WP
						wp_enqueue_style($style_item['name']);
					}
				}
			}
		}
	}

	/**
	 * Save data from meta box
	 *
	 */
	function save_meta_box($post_id)
	{
		//	Is this auto save routine? Do nothing if it is!
	  	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
	    	return $post_id;

		//	Save the data
		if (isset($_POST) == TRUE)
		{
			$options = $this->ltw_meta_box;

			if (count($options) > 0)
			{
				foreach ($options as $option)
				{
					if (count($option['fields']) > 0)
					{
						foreach ($option['fields'] as $field)
						{
							if ($field['type'] == 'nonce')
							{
								//	Verify that the data came from the safe location.
							  	if (isset($_POST[$field['field_name']]) == FALSE || wp_verify_nonce($_POST[$field['field_name']], plugin_basename(__FILE__)) == FALSE)
								{
									return $post_id;
							  	}
							}
							else if (isset($_POST[$field['field_name']]) == TRUE)
							{
								update_post_meta($post_id, $field['field_name'], $_POST[$field['field_name']]);
							}
							else if (isset($_POST[$field['field_name'].'_checkbox']) == TRUE)
							{
								update_post_meta($post_id, $field['field_name'], $_POST[$field['field_name'].'_checkbox']);
							}
						}
					}
				}
			}
		}

		return $post_id;
	}

	/**
	 * Get subpages number
	 *
	 */
	function get_current_subpage($add_separator = FALSE, $separator_location = 'left')
	{
		global $wp_query;

		$separator = '';

		if ($add_separator == TRUE)
		{
			$separator = $this->get_title_separator();
		}

		if (isset($wp_query->is_paged) == TRUE && $wp_query->is_paged == TRUE && isset($wp_query->query_vars['paged']) == TRUE && $wp_query->query_vars['paged'] >= 2)
		{
			if ($separator_location == 'left')
			{
				return esc_html(stripslashes($separator.__('Page ', LTW_PLAIN_FIELDS_UN).$wp_query->query_vars['paged']));
			}
			else
			{
				return esc_html(stripslashes(__('Page ', LTW_PLAIN_FIELDS_UN).$wp_query->query_vars['paged']).$separator);
			}
		}
		else if (isset($wp_query->query_vars['page']) == TRUE && $wp_query->query_vars['page'] >= 2)
		{
			if ($separator_location == 'left')
			{
				return esc_html(stripslashes($separator.__('Subpage ', LTW_PLAIN_FIELDS_UN).$wp_query->query_vars['page']));
			}
			else
			{
				return esc_html(stripslashes(__('Subpage ', LTW_PLAIN_FIELDS_UN).$wp_query->query_vars['page']).$separator);
			}
		}
	}

	/**
	 * wp_nav_menu fallback
	 *
	 */
	function wp_nav_menu_fallback()
	{
		$menu = '<ul>';

		if (is_front_page() == TRUE)
		{
			$menu .= '<li class="page_item current_page_item"><a href="'.get_home_url().'">'.__('Home', LTW_PLAIN_FIELDS_UN).'</a></li>';
		}
		else
		{
			$menu .= '<li class="page_item"><a href="'.get_home_url().'">'.__('Home', LTW_PLAIN_FIELDS_UN).'</a></li>';
		}

		$hide_all_menu_pages = $this->load_option('menu', 'pf_hide_all_pages');

		if ($hide_all_menu_pages == FALSE || $hide_all_menu_pages == '')
		{
			//	Exclude certain pages from the menu
			$exclude_menu_pages = $this->load_option('menu', 'pf_exclude_specific_pages');

			if ($exclude_menu_pages == FALSE)
			{
				$exclude_menu_pages = '';
			}

			//	Menu depth
			$menu_pages_depth = $this->load_option('menu', 'pf_submenu_depth_pages');

			if ($menu_pages_depth == FALSE)
			{
				$menu_pages_depth = '0';
			}

			$menu .= wp_list_pages('title_li=&depth='.$menu_pages_depth.'&exclude='.$exclude_menu_pages.'&echo=0');
		}

		$hide_all_categories = $this->load_option('menu', 'pf_hide_all_categories');

		if ($hide_all_categories == FALSE || $hide_all_categories == '')
		{
			$menu .= wp_list_categories('title_li=&echo=0&depth=0');
		}

		$menu .= '</ul>';

		echo $menu;
	}

	/**
	 * Calculate the column width for shortcode
	 * There are
	 *
	 */
	function column_width_shortcode($size, $no_sidebar = FALSE)
	{
		switch($size)
		{
			//	Two columns
			case '1/2':
				if ($no_sidebar == TRUE)
				{
					return ' column_1_2_no_sidebar';
				}
				else
				{
					return ' column_1_2';
				}
			break;

			//	Three columns
			case '1/3':
				if ($no_sidebar == TRUE)
				{
					return ' column_1_3_no_sidebar';
				}
				else
				{
					return ' column_1_3';
				}
			break;

			//	Four columns
			case '1/4':
				if ($no_sidebar == TRUE)
				{
					return ' column_1_4_no_sidebar';
				}
				else
				{
					return ' column_1_4';
				}
			break;

			//	Five columns
			case '1/5':
				if ($no_sidebar == TRUE)
				{
					return ' column_1_5_no_sidebar';
				}
				else
				{
					return ' column_1_5';
				}
			break;

			//	Six columns
			case '1/6':
				if ($no_sidebar == TRUE)
				{
					return ' column_1_6_no_sidebar';
				}
				else
				{
					return ' column_1_6';
				}
			break;
		}
	}

	/**
	 * Short code for start column
	 *
	 */
	function start_column_shortcode($attr, $content)
	{
		$output = '';

		//	Set width of the column
		if (isset($attr['width']) == TRUE && $attr['width'] != '')
		{
			$output = '<div class="columns_cont">';

			$no_sidebar = FALSE;

			if (isset($attr['nosidebar']) == TRUE)
			{
				$no_sidebar = TRUE;
			}

			$output .= '<div class="column_start'.$this->column_width_shortcode($attr['width'], $no_sidebar).'">';

			//	Is there any title for this column?
			if (isset($attr['title']) == TRUE && $attr['title'] != '')
			{
				$output .= '<h3>'.$attr['title'].'</h3>';
			}

			$output .= '<div class="column_content"><p>'.$content.'</p></div>';

			$output .= '</div>';
		}

		return $output;
	}

	/**
	 * Shortcode for columns between start and end ;)
	 *
	 */
	function column_shortcode($attr, $content)
	{
		$output = '';

		//	Set width of the column
		if (isset($attr['width']) == TRUE && $attr['width'] != '')
		{
			$no_sidebar = FALSE;

			if (isset($attr['nosidebar']) == TRUE)
			{
				$no_sidebar = TRUE;
			}

			$output = '<div class="column_middle'.$this->column_width_shortcode($attr['width'], $no_sidebar).'">';

			//	Is there any title for this column?
			if (isset($attr['title']) == TRUE && $attr['title'] != '')
			{
				$output .= '<h3>'.$attr['title'].'</h3>';
			}

			$output .= '<div class="column_content"><p>'.$content.'</p></div>';

			$output .= '</div>';
		}

		return $output;
	}

	/**
	 * Short code for end column
	 *
	 */
	function end_column_shortcode($attr, $content)
	{
		$output = '';

		//	Set width of the column
		if (isset($attr['width']) == TRUE && $attr['width'] != '')
		{
			$no_sidebar = FALSE;

			if (isset($attr['nosidebar']) == TRUE)
			{
				$no_sidebar = TRUE;
			}

			$output = '<div class="column_end'.$this->column_width_shortcode($attr['width'], $no_sidebar).'">';

			//	Is there any title for this column?
			if (isset($attr['title']) == TRUE && $attr['title'] != '')
			{
				$output .= '<h3>'.$attr['title'].'</h3>';
			}

			$output .= '<div class="column_content"><p>'.$content.'</p></div>';

			$output .= '</div>';

			$output .= '</div>';
		}

		return $output;
	}

	function custom_header_image()
	{
?>
<style type="text/css">
#top_cont {
	background-image: url(<?php header_image(); ?>);
	background-repeat: no-repeat;
}
</style>
<?php
	}

	function custom_admin_header_image()
	{
?>
<style type="text/css">
#headimg {
	width: <?php echo HEADER_IMAGE_WIDTH; ?>px;
    height: <?php echo HEADER_IMAGE_HEIGHT; ?>px;
}
</style>
<?php
	}
}
?>