<?php
//	Include the core class
require_once('core.php');

/**
 *	Main class for admin pages.
 *
 */
class ltw_admin extends ltw_core
{
	var $ltw_options = array();

	/**
	 * PHP 4 constructor
	 */
	function ltw_admin()
	{
		parent::ltw_core();

		remove_action('wp_head', 'noindex', 1);
		add_action('wp_head', array(&$this, 'set_privacy'), 1);

		//	Create menu and submenu items
		$this->ltw_menu = array(
			array(
				'type' => 'menu',
				'page_title' => $this->ltw_theme_name,
				'menu_title' => $this->ltw_theme_name,
				'capability' => 'edit_themes',
				'menu_slug' => 'ltw_general_settings',
				'function' => 'ltw_general_settings_page',
				'icon' => get_template_directory_uri().'/images/icon.png'
			),
			array(
				'type' => 'submenu',
				'parent_slug' => 'ltw_general_settings',
				'page_title' => $this->ltw_theme_name.__(' - General Settings', LTW_PLAIN_FIELDS_UN),
				'menu_title' => __('General Settings', LTW_PLAIN_FIELDS_UN),
				'capability' => 'edit_themes',
				'menu_slug' => 'ltw_general_settings',
				'function' => 'ltw_general_settings_page'
			),
			array(
				'type' => 'submenu',
				'parent_slug' => 'ltw_general_settings',
				'page_title' => $this->ltw_theme_name.__(' - Menu', LTW_PLAIN_FIELDS_UN),
				'menu_title' => __('Menu', LTW_PLAIN_FIELDS_UN),
				'capability' => 'edit_themes',
				'menu_slug' => 'ltw_menu',
				'function' => 'ltw_menu_page'
			),
			array(
				'type' => 'submenu',
				'parent_slug' => 'ltw_general_settings',
				'page_title' => $this->ltw_theme_name.__(' - Teaser Text', LTW_PLAIN_FIELDS_UN),
				'menu_title' => __('Teaser Text', LTW_PLAIN_FIELDS_UN),
				'capability' => 'edit_themes',
				'menu_slug' => 'ltw_teaser',
				'function' => 'ltw_teaser_page'
			),
			array(
				'type' => 'submenu',
				'parent_slug' => 'ltw_general_settings',
				'page_title' => $this->ltw_theme_name.__(' - SEO', LTW_PLAIN_FIELDS_UN),
				'menu_title' => __('SEO', LTW_PLAIN_FIELDS_UN),
				'capability' => 'edit_themes',
				'menu_slug' => 'ltw_seo',
				'function' => 'ltw_seo_page'
			)
		);

		//	Load JS
		$this->ltw_set_scripts = array(
			array(
				'type' => 'custom',
				'name' => 'ltw_upload_manager',
				'url' => get_template_directory_uri().'/admin/js/upload_manager.js',
				'depends_on' => array('jquery', 'media-upload', 'thickbox'),
				'version' => $this->ltw_theme_version,
				'in_footer' => false
			),
			array(
				'type' => 'custom',
				'name' => 'ltw_general_functions',
				'url' => get_template_directory_uri().'/admin/js/general_functions.js',
				'depends_on' => array('jquery'),
				'version' => $this->ltw_theme_version,
				'in_footer' => false
			)
		);

		//	Load JS that are shown on non-theme pages in the admin area
		$this->ltw_set_scripts_extra = array(
			array(
				'type' => 'custom',
				'name' => 'ltw_general_functions',
				'url' => get_template_directory_uri().'/admin/js/general_functions.js',
				'depends_on' => array('jquery'),
				'version' => $this->ltw_theme_version,
				'in_footer' => false
			)
		);

		//	Load CSS styles
		$this->ltw_set_styles = array(
			array(
				'type' => 'custom',
				'name' => 'ltw_admin_style',
				'url' => get_template_directory_uri().'/admin/css/style.css',
				'depends_on' => array(),
				'version' => $this->ltw_theme_version,
				'media' => 'all'
			),
			array(
				'type' => '',
				'name' => 'thickbox'
			)
		);

		//	Load CSS styles that are shown on non-theme pages in the admin area
		$this->ltw_set_styles_extra = array(
			array(
				'type' => 'custom',
				'name' => 'ltw_admin_style',
				'url' => get_template_directory_uri().'/admin/css/style.css',
				'depends_on' => array(),
				'version' => $this->ltw_theme_version,
				'media' => 'all'
			),
			array(
				'type' => '',
				'name' => 'thickbox'
			)
		);

		//	Create Meta Box
		$this->ltw_meta_box = array(
			array(
				'html_id' => 'ltw_pl_mb',
				'title' => __('Plain Fields Options', LTW_PLAIN_FIELDS_UN),
				'page' => array('page', 'post'),
				'context' => 'normal',
				'priority' => 'high',
				'fields' => array(
					array(
						'type' => 'nonce',
						'show_on' => 'all',
						'field_name' => '_ltw_pl_seo_nonce'
					),
					array(
						'type' => 'text',
						'show_on' => 'all',
						'title' => __('Custom Title Tag', LTW_PLAIN_FIELDS_UN),
						'field_name' => '_pf_custom_title_tag',
						'field_id' => '_pf_custom_title_tag',
						'field_value' => '',
						'field_width' => '100%',
						'field_class' => 'regular-text',
						'help' => __('You can override the title. If empty, the name of the page/post will be used as the title.', LTW_PLAIN_FIELDS_UN),
						'pro_only' => TRUE
					),
					array(
						'type' => 'textarea',
						'show_on' => 'all',
						'title' => __('Custom Meta Description', LTW_PLAIN_FIELDS_UN),
						'field_name' => '_pf_custom_meta_description',
						'field_id' => '_pf_custom_meta_description',
						'field_value' => '',
						'field_width' => '100%',
						'field_class' => 'regular-text',
						'help' => __('Make the description descriptive of the pages content.', LTW_PLAIN_FIELDS_UN),
						'pro_only' => FALSE
					),
					array(
						'type' => 'text',
						'show_on' => 'all',
						'title' => __('Custom Meta Keywords', LTW_PLAIN_FIELDS_UN),
						'field_name' => '_pf_custom_meta_keywords',
						'field_id' => '_pf_custom_meta_keywords',
						'field_value' => '',
						'field_width' => '100%',
						'field_class' => 'regular-text',
						'help' => __('Separate keywords by comma.', LTW_PLAIN_FIELDS_UN),
						'pro_only' => FALSE
					),
					array(
						'type' => 'text',
						'show_on' => 'all',
						'title' => __('Custom Teaser Text', LTW_PLAIN_FIELDS_UN),
						'field_name' => '_pf_custom_teaser_text',
						'field_id' => '_pf_custom_teaser_text',
						'field_value' => '',
						'field_width' => '100%',
						'field_class' => 'regular-text',
						'help' => __('Here you can set certain teaser text that will be visible only on this blog post/page.', LTW_PLAIN_FIELDS_UN),
						'pro_only' => TRUE
					),
					array(
						'type' => 'checkbox',
						'show_on' => 'all',
						'title' => __('Hide Teaser Text', LTW_PLAIN_FIELDS_UN),
						'field_name' => '_pf_hide_teaser_text',
						'field_id' => '_pf_hide_teaser_text',
						'field_value' => '1',
						'field_checked' => FALSE,
						'field_text' => __('If checked, the teaser text on this blog post/page will be hidden', LTW_PLAIN_FIELDS_UN),
						'help' => '',
						'pro_only' => TRUE
					),
					array(
						'type' => 'checkbox',
						'show_on' => 'all',
						'title' => __('Set noindex on this post/page', LTW_PLAIN_FIELDS_UN),
						'field_name' => '_pf_set_noindex',
						'field_id' => '_pf_set_noindex',
						'field_value' => '1',
						'field_checked' => $this->load_option('seo', 'pf_seo_default_noindex') !== '2' ? FALSE : TRUE,
						'field_text' => __('If checked, this page will not be indexed by the search engines', LTW_PLAIN_FIELDS_UN),
						'help' => '',
						'pro_only' => FALSE
					),
					array(
						'type' => 'checkbox',
						'show_on' => 'all',
						'title' => __('Set nofollow on this post/page', LTW_PLAIN_FIELDS_UN),
						'field_name' => '_pf_set_nofollow',
						'field_id' => '_pf_set_nofollow',
						'field_value' => '1',
						'field_checked' => $this->load_option('seo', 'pf_seo_default_nofollow') !== '2' ? FALSE : TRUE,
						'field_text' => __('If checked, search engines will not follow any links on this page', LTW_PLAIN_FIELDS_UN),
						'help' => '',
						'pro_only' => FALSE
					),
					array(
						'type' => 'text',
						'show_on' => 'all',
						'title' => __('Custom Widget Area Name', LTW_PLAIN_FIELDS_UN),
						'field_name' => '_pf_custom_widget_area',
						'field_id' => '_pf_custom_widget_area',
						'field_value' => '',
						'field_width' => '100%',
						'field_class' => 'regular-text',
						'help' => __('Enter the name for the custom widget area.<br /><br />This custom widget area will be available only for this page/post.<br /><br />Go to &quot;Appearance-&gt;Widgets&quot; to add a widget to the custom widget area for this page/post.', LTW_PLAIN_FIELDS_UN),
						'pro_only' => TRUE
					)
				)
			)
		);

		$startup_data = array(
			'teaser' => array(
				'pf_front_page_teaser_text' => __('Hello, my name is teaser text and you can change me!', LTW_PLAIN_FIELDS_UN)
			),
			'menu' => array(
				'pf_hide_all_categories' => '1'
			)
		);
		//	Add some default settings..
		add_option('ltw_pf_settings', $startup_data, '', 'yes');
	}

	/**
	 * Create general settings page
	 *
	 */
	function ltw_general_settings_page()
	{
		//	General settings page
		$this->ltw_page_options['general_settings'] = array(
			array(
				'type' => 'header',
				'title' => __('General Settings', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'subheader',
				'title' => __('Logo', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'upload',
				'title' => __('Custom logo', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_upload_image',
				'field_id' => 'pf_upload_image',
				'field_value' => '',
				'help' => __('Upload logo image or enter URL to the logo image.<br /><br />Recommended size for a logo is 630px width and 80px height or less.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'text',
				'title' => __('Logo Image ALT', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_logo_alt',
				'field_id' => 'pf_logo_alt',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Enter text for the ALT tag of the logo image.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'checkbox',
				'title' => __('Hide Tagline', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_hide_tagline',
				'field_id' => 'pf_hide_tagline',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, the tagline below the logo text or image will be hidden', LTW_PLAIN_FIELDS_UN),
				'help' => __('It is recommended to hide tagline if you are using logo image that is higher then 50px.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'subheader',
				'title' => __('Header', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'textarea',
				'title' => __('Custom CSS', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_custom_css',
				'field_id' => 'pf_custom_css',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('You can add custom CSS styles. CSS styles will be inserted into the head part of the website.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'textarea',
				'title' => __('Insert Javascripts', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_header_javascripts',
				'field_id' => 'pf_header_javascripts',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Here you can add Javascript code that will be inserted into the head of the website. It will be inserted right before the &lt;/body&gt; tag.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'subheader',
				'title' => __('Footer', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'text',
				'title' => __('Set Copyright Text', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_copyright_text',
				'field_id' => 'pf_copyright_text',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Copyright text will be displayed after the year number in the bottom right corner.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'textarea',
				'title' => __('Insert Javascripts', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_footer_javascripts',
				'field_id' => 'pf_footer_javascripts',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Here you can add Google Analytics code or any other JS code. It will be inserted right before the &lt;/body&gt; tag.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'subheader',
				'title' => __('Other', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'upload',
				'title' => __('Custom Favicon', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_upload_favicon',
				'field_id' => 'pf_upload_favicon',
				'field_value' => '',
				'help' => __('Upload or enter URL to the Favicon.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'text',
				'title' => __('RSS URL', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_rss_url',
				'field_id' => 'pf_rss_url',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Here you can enter URL to the Feedburner or any other RSS service that you might use. If empty, the default Wordpress RSS Feed will be used.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'checkbox',
				'title' => __('Hide RSS Icon', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_rss_icon',
				'field_id' => 'pf_rss_icon',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, RSS icon on the right side above the menu will be hidden', LTW_PLAIN_FIELDS_UN),
				'help' => '',
				'pro_only' => FALSE
			),
			array(
				'type' => 'select',
				'title' => __('Sidebar Position', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_sidebar_position',
				'field_id' => 'pf_sidebar_position',
				'field_options' => array(
					array('value' => 'right', 'text' => __('Right Side', LTW_PLAIN_FIELDS_UN), 'selected' => TRUE),
					array('value' => 'left', 'text' => __('Left Side', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE)
				),
				'help' => __('This will set the sidebar position for all pages on your blog.<br /><br />You can also set sidebar position by using left, right or no sidebar at all templates for certain pages.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'subheader',
				'title' => __('Social Icons', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'text',
				'title' => __('Twitter Username', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_twitter_username',
				'field_id' => 'pf_twitter_username',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Leave empty if you do not want to show the Twitter icon on the right side above the menu.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'text',
				'title' => __('Digg Username', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_digg_username',
				'field_id' => 'pf_digg_username',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Leave empty if you do not want to show the Digg icon on the right side above the menu.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'text',
				'title' => __('Flickr Username', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_flickr_username',
				'field_id' => 'pf_flickr_username',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Leave empty if you do not want to show the Flickr icon on the right side above the menu.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			)
		);

		//	Form submitted? If so, process it
		$this->check_form('general_settings');

		$this->build_html('general_settings');
	}

	/**
	 * Tagline, hide it?
	 *
	 */
	function hide_top_tagline()
	{
		$option = $this->load_option('general_settings', 'pf_hide_tagline');

		if ($option == FALSE || $option == '')
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

	/**
	 * RSS feed, replace the WP version?
	 *
	 */
	function rss_feed()
	{
		$option = $this->load_option('general_settings', 'pf_rss_url');

		if ($option == FALSE || $option == '')
		{
			return FALSE;
		}
		else
		{
			return stripslashes($option);
		}
	}

	/**
	 * Set copyright text
	 *
	 */
	function set_copyright()
	{
		$option = $this->load_option('general_settings', 'pf_copyright_text');

		if ($option == FALSE || $option == '')
		{
			return FALSE;
		}
		else
		{
			return stripslashes($option);
		}
	}

	/**
	 * Set footer javascript
	 *
	 */
	function set_footer_javascript()
	{
		$option = $this->load_option('general_settings', 'pf_footer_javascripts');

		if ($option == FALSE || $option == '')
		{
			return FALSE;
		}
		else
		{
			return "\n".stripslashes($option)."\n";
		}
	}

	/**
	 * RSS Icon, hide it?
	 *
	 */
	function hide_rss_icon()
	{
		$option = $this->load_option('general_settings', 'pf_rss_icon');

		if ($option == FALSE || $option != '1')
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

	/**
	 *	Create menu admin page
	 *
	 */
	function ltw_menu_page()
	{
		//	Menu page
		$this->ltw_page_options['menu'] = array(
			array(
				'type' => 'header',
				'title' => __('Menu', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'checkbox',
				'title' => __('Hide All Pages', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_hide_all_pages',
				'field_id' => 'pf_hide_all_pages',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, all pages will be removed from the menu', LTW_PLAIN_FIELDS_UN),
				'help' => '',
				'pro_only' => FALSE
			),
			array(
				'type' => 'text',
				'title' => __('Exclude Specific Pages', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_exclude_specific_pages',
				'field_id' => 'pf_exclude_specific_pages',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Enter comma separated list of page ID\'s that you do not wish to show in the menu.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'text',
				'title' => __('Pages Submenu Depth', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_submenu_depth_pages',
				'field_id' => 'pf_submenu_depth_pages',
				'field_value' => '0',
				'field_class' => 'small-text',
				'help' => __('Enter a number of submenu levels that you wish to show (0 - show all submenus, 1 - only first level).', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'checkbox',
				'title' => __('Hide All Categories', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_hide_all_categories',
				'field_id' => 'pf_hide_all_categories',
				'field_value' => '1',
				'field_checked' => TRUE,
				'field_text' => __('If checked, all categories will be removed from the menu', LTW_PLAIN_FIELDS_UN),
				'help' => '',
				'pro_only' => FALSE
			),
			array(
				'type' => 'text',
				'title' => __('Exclude Specific Categories', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_exclude_specific_categories',
				'field_id' => 'pf_exclude_specific_categories',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Enter comma separated list of category ID&#39;s that you do not wish to show in the menu.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'text',
				'title' => __('Categories Submenu Depth', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_submenu_depth_categories',
				'field_id' => 'pf_submenu_depth_categories',
				'field_value' => '0',
				'field_class' => 'small-text',
				'help' => __('Enter a number of submenu levels that you wish to show (0 - show all submenus, 1 - only first level).', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'checkbox',
				'title' => __('Remove Home Link', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_remove_home_link',
				'field_id' => 'pf_remove_home_link',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, the Home link the in the menu will be removed', LTW_PLAIN_FIELDS_UN),
				'help' => '',
				'pro_only' => TRUE
			)
		);

		//	Form submitted? If so, process it
		$this->check_form('menu');

		//	Output the HTML based on the above array
		$this->build_html('menu');
	}

	/**
	 * Create teaser text admin page
	 *
	 */
	function ltw_teaser_page()
	{
		//	Menu page
		$this->ltw_page_options['teaser'] = array(
			array(
				'type' => 'header',
				'title' => __('Teaser Text', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'note',
				'title' => __('Did you know that you can set teaser text for specific page or post?<br />Check out the options below the editor on the add new/edit page or post.', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'checkbox',
				'title' => __('Hide Teaser Text On All Pages', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_hide_teaser_text_all_pages',
				'field_id' => 'pf_hide_teaser_text_all_pages',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, teaser text will be hidden on ALL pages', LTW_PLAIN_FIELDS_UN),
				'help' => '',
				'pro_only' => FALSE
			),
			array(
				'type' => 'text',
				'title' => __('Front Page Teaser Text', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_front_page_teaser_text',
				'field_id' => 'pf_front_page_teaser_text',
				'field_value' => __('Hello, my name is teaser text and you can change me!', LTW_PLAIN_FIELDS_UN),
				'field_class' => 'regular-text',
				'help' => __('Front page teaser text will also be shown on all other pages unless you override it with one of the options below.<br /><br />You can use HTML/CSS to style the text.<br /><br />Text will be inserted inside the H1 tag.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'checkbox',
				'title' => __('Hide Teaser Text On Front Page', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_hide_front_page_teaser_text',
				'field_id' => 'pf_hide_front_page_teaser_text',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, teaser text will be hidden on front page', LTW_PLAIN_FIELDS_UN),
				'help' => '',
				'pro_only' => FALSE
			),
			array(
				'type' => 'text',
				'title' => __('Pages Only Teaser Text', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_pages_only_teaser_text',
				'field_id' => 'pf_pages_only_teaser_text',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Shown on pages only. If empty and not hidden, front page teaser text will be shown.<br /><br />You can override the teaser text on specific page.<br /><br />You can use HTML/CSS to style the text.<br /><br />Text will be inserted inside the P tag.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'checkbox',
				'title' => __('Hide Teaser Text On Pages Only', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_hide_teaser_text_on_pages_only',
				'field_id' => 'pf_hide_teaser_text_on_pages_only',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, teaser text will be hidden on pages only', LTW_PLAIN_FIELDS_UN),
				'help' => __('You can override this on specific page.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'text',
				'title' => __('Blog Posts Only Teaser Text', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_blog_posts_only_teaser_text',
				'field_id' => 'pf_blog_posts_only_teaser_text',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Shown on blog posts only. If empty and not hidden, front page teaser text will be shown.<br /><br />You can override the teaser text on specific blog post page.<br /><br />You can use HTML/CSS to style the text.<br /><br />Text will be inserted inside the P tag.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'checkbox',
				'title' => __('Hide Teaser Text On Blog Posts Only', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_hide_teaser_text_on_blog_posts_only',
				'field_id' => 'pf_hide_teaser_text_on_blog_posts_only',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, teaser text will be hidden on blog posts only', LTW_PLAIN_FIELDS_UN),
				'help' => __('You can override this on specific post.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'text',
				'title' => __('Category Pages Teaser Text', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_categories_teaser_text',
				'field_id' => 'pf_categories_teaser_text',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Shown on category pages. If empty and not hidden, front page teaser text will be shown.<br /><br />You can use HTML/CSS to style the text.<br /><br />Text will be inserted inside the P tag.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'checkbox',
				'title' => __('Hide Teaser Text On Category Pages', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_hide_teaser_text_on_category_pages',
				'field_id' => 'pf_hide_teaser_text_on_category_pages',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, teaser text will be hidden on category pages', LTW_PLAIN_FIELDS_UN),
				'help' => '',
				'pro_only' => TRUE
			),
			array(
				'type' => 'text',
				'title' => __('Date Archive Pages Teaser Text', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_archives_teaser_text',
				'field_id' => 'pf_archives_teaser_text',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Shown on date archives pages. If empty and not hidden, front page teaser text will be shown.<br /><br />You can use HTML/CSS to style the text.<br /><br />Text will be inserted inside the P tag.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'checkbox',
				'title' => __('Hide Teaser Text On Date Archive Pages', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_hide_teaser_text_on_archive_pages',
				'field_id' => 'pf_hide_teaser_text_on_archive_pages',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, teaser text will be hidden on date archive pages', LTW_PLAIN_FIELDS_UN),
				'help' => '',
				'pro_only' => TRUE
			),
			array(
				'type' => 'text',
				'title' => __('Tag Pages Teaser Text', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_tags_teaser_text',
				'field_id' => 'pf_tags_teaser_text',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Shown on tags pages. If empty and not hidden, front page teaser text will be shown.<br /><br />You can use HTML/CSS to style the text.<br /><br />Text will be inserted inside the P tag.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'checkbox',
				'title' => __('Hide Teaser Text On Tags Pages', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_hide_teaser_text_on_tags_pages',
				'field_id' => 'pf_hide_teaser_text_on_tags_pages',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, teaser text will be hidden on tags pages', LTW_PLAIN_FIELDS_UN),
				'help' => '',
				'pro_only' => TRUE
			),
			array(
				'type' => 'text',
				'title' => __('Search Pages Teaser Text', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_search_teaser_text',
				'field_id' => 'pf_search_teaser_text',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Shown on search pages. If empty and not hidden, front page teaser text will be shown.<br /><br />You can use HTML/CSS to style the text.<br /><br />Text will be inserted inside the P tag.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'checkbox',
				'title' => __('Hide Teaser Text On Search Pages', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_hide_teaser_text_on_search_pages',
				'field_id' => 'pf_hide_teaser_text_on_search_pages',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, teaser text will be hidden on search pages', LTW_PLAIN_FIELDS_UN),
				'help' => '',
				'pro_only' => TRUE
			),
			array(
				'type' => 'text',
				'title' => __('Author pages Teaser Text', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_author_teaser_text',
				'field_id' => 'pf_author_teaser_text',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Shown on author pages. If empty and not hidden, front page teaser text will be shown.<br /><br />You can use HTML/CSS to style the text.<br /><br />Text will be inserted inside the P tag.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'checkbox',
				'title' => __('Hide Teaser Text On Author Pages', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_hide_teaser_text_on_author_pages',
				'field_id' => 'pf_hide_teaser_text_on_author_pages',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, teaser text will be hidden on author pages', LTW_PLAIN_FIELDS_UN),
				'help' => '',
				'pro_only' => TRUE
			),
			array(
				'type' => 'text',
				'title' => __('404 Error Page Teaser Text', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_404_teaser_text',
				'field_id' => 'pf_404_teaser_text',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Shown on 404 error page. If empty and not hidden, front page teaser text will be shown.<br /><br />You can use HTML/CSS to style the text.<br /><br />Text will be inserted inside the P tag.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => TRUE
			),
			array(
				'type' => 'checkbox',
				'title' => __('Hide Teaser Text On 404 Error Page', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_hide_teaser_text_on_404_page',
				'field_id' => 'pf_hide_teaser_text_on_404_page',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, teaser text will be hidden on 404 error page', LTW_PLAIN_FIELDS_UN),
				'help' => '',
				'pro_only' => TRUE
			)
		);

		//	Form submitted? If so, process it
		$this->check_form('teaser');

		//	Output the HTML based on the above array
		$this->build_html('teaser');
	}

	/**
	 * Hide teaser text on all pages?
	 *
	 */
	function hide_teaser_text()
	{
		$option = $this->load_option('teaser', 'pf_hide_teaser_text_all_pages');

		if ($option == FALSE || $option == '')
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

	/**
	 * Hide teaser text on front page?
	 * If not, display the text.
	 *
	 */
	function front_page_teaser_text()
	{
		$option = $this->load_option('teaser', 'pf_hide_front_page_teaser_text');

		if ($option == FALSE || $option == '')
		{
			return stripslashes($this->load_option('teaser', 'pf_front_page_teaser_text'));
		}
		else
		{
			return TRUE;
		}
	}

	/**
	 * Hide teaser text on pages only?
	 *
	 */
	function hide_teaser_text_on_pages()
	{
		$option = $this->load_option('teaser', 'pf_hide_teaser_text_on_pages_only');

		if ($option == FALSE || $option == '')
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

	/**
	 * Load teaser text for pages only
	 *
	 */
	function load_teaser_text_pages_only()
	{
		$option = $this->load_option('teaser', 'pf_pages_only_teaser_text');

		if ($option == FALSE || $option == '')
		{
			return stripslashes($this->load_option('teaser', 'pf_front_page_teaser_text'));
		}
		else
		{
			return stripslashes($this->load_option('teaser', 'pf_pages_only_teaser_text'));
		}
	}

	/**
	 * Load teaser text for blog posts only
	 *
	 */
	function load_teaser_text_blog_posts_only()
	{
		$option = $this->load_option('teaser', 'pf_blog_posts_only_teaser_text');

		if ($option == FALSE || $option == '')
		{
			return stripslashes($this->load_option('teaser', 'pf_front_page_teaser_text'));
		}
		else
		{
			return stripslashes($this->load_option('teaser', 'pf_blog_posts_only_teaser_text'));
		}
	}

	/**
	 * Hide teaser text on blog posts only?
	 *
	 */
	function hide_teaser_text_on_blog_posts()
	{
		$option = $this->load_option('teaser', 'pf_hide_teaser_text_on_blog_posts_only');

		if ($option == FALSE || $option == '')
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

	/**
	 * Output the teaser text
	 *
	 */
	function output_teaser_text($start_div, $end_div)
	{
		if ($this->hide_teaser_text() == FALSE)
		{
			//	Teaser text on front page
			if (is_home() == TRUE && $this->front_page_teaser_text() !== TRUE)
			{
				return $start_div.'<h1>'.$this->front_page_teaser_text().'</h1>'.$end_div;
			}
			//	Teaser text for pages only
			else if (is_page() == TRUE && $this->hide_teaser_text_on_pages() == FALSE)
			{
				return $start_div.'<p>'.$this->load_teaser_text_pages_only().'</p>'.$end_div;
			}
			//	Teaser text for blog posts only
			else if (is_single() == TRUE && $this->hide_teaser_text_on_blog_posts() == FALSE)
			{
				return $start_div.'<p>'.$this->load_teaser_text_blog_posts_only().'</p>'.$end_div;
			}
			//	Show teaser text on all other pages
			else if (is_archive() == TRUE || is_search() == TRUE || is_404() == TRUE)
			{
				return $start_div.'<h1><p>'.$this->front_page_teaser_text().'</p></h1>'.$end_div;
			}
		}
	}

	/**
	 * Get custom meta description
	 *
	 */
	function get_custom_meta_description()
	{
		global $post;

		return esc_html(stripslashes(get_post_meta($post->ID, '_pf_custom_meta_description', TRUE)));
	}

	/**
	 * Get custom meta keywords
	 *
	 */
	function get_custom_meta_keywords()
	{
		global $post;

		return esc_html(stripslashes(get_post_meta($post->ID, '_pf_custom_meta_keywords', TRUE)));
	}

	/**
	 * Set noindex for specific post/page
	 *
	 */
	function set_privacy()
	{
		global $post;

		//	If privacy is set, just do it.
		if (get_option('blog_public') == '0')
		{
			return '<meta name="robots" content="noindex,nofollow" />'."\n";
		}
		//	Get index settings per page
		else if ((isset($post->post_type) == TRUE && $post->post_type == 'page') || (isset($post->post_type) == TRUE && $post->post_type == 'post'))
		{
			$output_array = array();

			if (get_post_meta($post->ID, '_pf_set_noindex', TRUE) != '')
			{
				$output_array[] = 'noindex';
			}

			if (get_post_meta($post->ID, '_pf_set_nofollow', TRUE) != '')
			{
				$output_array[] = 'nofollow';
			}

			if (count($output_array) > 0)
			{
				$output_list = '';
				$output_list = implode(',', $output_array);

				return '<meta name="robots" content="'.$output_list.'" />'."\n";
			}
		}
	}

	/**
	 * Create SEO page for admin
	 *
	 */
	function ltw_seo_page()
	{
		//	Menu page
		$this->ltw_page_options['seo'] = array(
			array(
				'type' => 'header',
				'title' => __('SEO', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'subheader',
				'title' => __('Title', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'text',
				'title' => __('Title Separator', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_seo_title_separator',
				'field_id' => 'pf_seo_title_separator',
				'field_value' => ' - ',
				'field_class' => 'small-text',
				'help' => '',
				'pro_only' => FALSE
			),
			array(
				'type' => 'subheader',
				'title' => __('Front Page', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'checkbox',
				'title' => __('Show Blog Description in the Title', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_seo_blog_desc_title',
				'field_id' => 'pf_seo_blog_desc_title',
				'field_value' => '1',
				'field_checked' => FALSE,
				'field_text' => __('If checked, blog description will be shown in the title', LTW_PLAIN_FIELDS_UN),
				'help' => __('Blog description is taken from the &quot;Tagline&quot; located at &quot;Settings&quot; -> &quot;General&quot; page.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'radio',
				'title' => __('Meta Description', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_seo_populate_meta_description',
				'field_id' => 'pf_seo_populate_meta_description',
				'field_options' => array(
					array('id' => 'pf_seo_populate_meta_description1', 'value' => '1', 'text' => __('Off', LTW_PLAIN_FIELDS_UN), 'checked' => TRUE),
					array('id' => 'pf_seo_populate_meta_description2', 'value' => '2', 'text' => __('From WP Tagline Description', LTW_PLAIN_FIELDS_UN), 'checked' => FALSE),
					array('id' => 'pf_seo_populate_meta_description3', 'value' => '3', 'text' => __('From Custom Meta Description', LTW_PLAIN_FIELDS_UN), 'checked' => FALSE)
				),
				'help' => __('Select from where to populate the front page meta description tag.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'text',
				'title' => __('Custom Meta Description', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_seo_custom_meta_description',
				'field_id' => 'pf_seo_custom_meta_description',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => '',
				'pro_only' => FALSE
			),
			array(
				'type' => 'radio',
				'title' => __('Meta Keywords', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_seo_populate_meta_keywords',
				'field_id' => 'pf_seo_populate_meta_keywords',
				'field_options' => array(
					array('id' => 'pf_seo_populate_meta_keywords1', 'value' => '1', 'text' => __('Off', LTW_PLAIN_FIELDS_UN), 'checked' => TRUE),
					array('id' => 'pf_seo_populate_meta_keywords2', 'value' => '2', 'text' => __('From Custom Meta Keywods', LTW_PLAIN_FIELDS_UN), 'checked' => FALSE)
				),
				'help' => __('Select from where to populate the front page meta keywords tag.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'text',
				'title' => __('Custom Meta Keywords', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_seo_custom_meta_keywords',
				'field_id' => 'pf_seo_custom_meta_keywords',
				'field_value' => '',
				'field_class' => 'regular-text',
				'help' => __('Separate keywords by comma.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'subheader',
				'title' => __('Default New Page/Post Setting', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'radio',
				'title' => __('NoIndex', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_seo_default_noindex',
				'field_id' => 'pf_seo_default_noindex',
				'field_options' => array(
					array('id' => 'pf_seo_default_noindex1', 'value' => '1', 'text' => __('Not checked', LTW_PLAIN_FIELDS_UN), 'checked' => TRUE),
					array('id' => 'pf_seo_default_noindex2', 'value' => '2', 'text' => __('Is checked', LTW_PLAIN_FIELDS_UN), 'checked' => FALSE)
				),
				'help' => __('If you select &quot;Is checked&quot;, then when you create new page, the NoIndex checkbox will always be checked.<br /><br />By default, the NoIndex checkbox is always unchecked.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'radio',
				'title' => __('NoFollow', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_seo_default_nofollow',
				'field_id' => 'pf_seo_default_nofollow',
				'field_options' => array(
					array('id' => 'pf_seo_default_nofollow1', 'value' => '1', 'text' => __('Not checked', LTW_PLAIN_FIELDS_UN), 'checked' => TRUE),
					array('id' => 'pf_seo_default_nofollow2', 'value' => '2', 'text' => __('Is checked', LTW_PLAIN_FIELDS_UN), 'checked' => FALSE)
				),
				'help' => __('If you select &quot;Is checked&quot;, then when you create new page, the NoFollow checkbox will always be checked.<br /><br />By default, the NoFollow checkbox is always unchecked.', LTW_PLAIN_FIELDS_UN),
				'pro_only' => FALSE
			),
			array(
				'type' => 'subheader',
				'title' => __('Archive NoIndex/NoFollow', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'note',
				'title' => __('Set archive noindex and nofollow option.<br/><br/>noindex will tell search engines to not index the page on your site.<br/><br/>nofollow will tell search engines to not follow any links on this page.<br/><br/>You can also set the noindex/nofollow for specific blog post/page.', LTW_PLAIN_FIELDS_UN)
			),
			array(
				'type' => 'select',
				'title' => __('Category Archives', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_seo_category_archives',
				'field_id' => 'pf_seo_category_archives',
				'field_options' => array(
					array('value' => '', 'text' => __('Index and Follow', LTW_PLAIN_FIELDS_UN), 'selected' => TRUE),
					array('value' => 'noindex', 'text' => __('NoIndex and Follow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE),
					array('value' => 'nofollow', 'text' => __('Index and NoFollow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE),
					array('value' => 'noindex,nofollow', 'text' => __('NoIndex and NoFollow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE)
				),
				'help' => '',
				'pro_only' => TRUE
			),
			array(
				'type' => 'select',
				'title' => __('Tag Archives', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_seo_tag_archives',
				'field_id' => 'pf_seo_tag_archives',
				'field_options' => array(
					array('value' => '', 'text' => __('Index and Follow', LTW_PLAIN_FIELDS_UN), 'selected' => TRUE),
					array('value' => 'noindex', 'text' => __('NoIndex and Follow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE),
					array('value' => 'nofollow', 'text' => __('Index and NoFollow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE),
					array('value' => 'noindex,nofollow', 'text' => __('NoIndex and NoFollow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE)
				),
				'help' => '',
				'pro_only' => TRUE
			),
			array(
				'type' => 'select',
				'title' => __('Author Pages', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_seo_author_pages',
				'field_id' => 'pf_seo_author_pages',
				'field_options' => array(
					array('value' => '', 'text' => __('Index and Follow', LTW_PLAIN_FIELDS_UN), 'selected' => TRUE),
					array('value' => 'noindex', 'text' => __('NoIndex and Follow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE),
					array('value' => 'nofollow', 'text' => __('Index and NoFollow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE),
					array('value' => 'noindex,nofollow', 'text' => __('NoIndex and NoFollow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE)
				),
				'help' => '',
				'pro_only' => TRUE
			),
			array(
				'type' => 'select',
				'title' => __('Search Results', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_seo_search_results',
				'field_id' => 'pf_seo_search_results',
				'field_options' => array(
					array('value' => '', 'text' => __('Index and Follow', LTW_PLAIN_FIELDS_UN), 'selected' => TRUE),
					array('value' => 'noindex', 'text' => __('NoIndex and Follow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE),
					array('value' => 'nofollow', 'text' => __('Index and NoFollow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE),
					array('value' => 'noindex,nofollow', 'text' => __('NoIndex and NoFollow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE)
				),
				'help' => '',
				'pro_only' => TRUE
			),
			array(
				'type' => 'select',
				'title' => __('Date Archives', LTW_PLAIN_FIELDS_UN),
				'field_name' => 'pf_seo_date_archives',
				'field_id' => 'pf_seo_date_archives',
				'field_options' => array(
					array('value' => '', 'text' => __('Index and Follow', LTW_PLAIN_FIELDS_UN), 'selected' => TRUE),
					array('value' => 'noindex', 'text' => __('NoIndex and Follow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE),
					array('value' => 'nofollow', 'text' => __('Index and NoFollow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE),
					array('value' => 'noindex,nofollow', 'text' => __('NoIndex and NoFollow', LTW_PLAIN_FIELDS_UN), 'selected' => FALSE)
				),
				'help' => '',
				'pro_only' => TRUE
			),
		);

		//	Form submitted? If so, process it
		$this->check_form('seo');

		//	Output the HTML based on the above array
		$this->build_html('seo');
	}

	/**
	 * Get title separator
	 *
	 */
	function get_title_separator()
	{
		$option = $this->load_option('seo', 'pf_seo_title_separator');

		if ($option == '')
		{
			$option = ' - ';
		}

		return stripslashes($option);
	}

	/**
	 * Get front page meta description
	 *
	 */
	function get_front_page_meta_description()
	{
		$option = $this->load_option('seo', 'pf_seo_populate_meta_description');

		if ($option == '2')
		{
			return esc_html(stripslashes(get_bloginfo('description')));
		}
		else if ($option == '3')
		{
			return esc_html(stripslashes($this->load_option('seo', 'pf_seo_custom_meta_description')));
		}
		else
		{
			return FALSE;
		}
	}

	/**
	 * Get front page meta keywords
	 *
	 */
	function get_front_page_meta_keywords()
	{
		$option = $this->load_option('seo', 'pf_seo_populate_meta_keywords');

		if ($option == '2')
		{
			return esc_html(stripslashes($this->load_option('seo', 'pf_seo_custom_meta_keywords')));
		}
		else
		{
			return FALSE;
		}
	}

	/**
	 * Show blog description in the title
	 *
	 */
	function show_blog_description_title()
	{
		$option = $this->load_option('seo', 'pf_seo_blog_desc_title');

		if ($option == FALSE || $option == '')
		{
			return FALSE;
		}
		else
		{
			return stripslashes(get_bloginfo('description')).$this->get_title_separator();
		}
	}
}

if (class_exists('ltw_admin'))
{
	$plain_fields = new ltw_admin();
}
?>