<?php

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Placid_Customize {

	/**
	 * Returns the instance.
	 *
	 * @return object
	 * @since  1.0.0
	 * @access public
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @return void
	 * @since  1.0.0
	 * @access private
	 */
	private function __construct() {
	}

	/**
	 * Sets up initial actions.
	 *
	 * @return void
	 * @since  1.0.0
	 * @access private
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @param object $manager
	 *
	 * @return void
	 * @since  1.0.0
	 * @access public
	 */
	public function sections( $manager ) {

		// Load custom sections.
		require_once get_template_directory() . '/inc/customizer-pro/section-pro.php';

		// Register custom section types.
		$manager->register_section_type( 'Placid_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Placid_Customize_Section_Pro(
				$manager,
				'quality-construction',
				array(
					'title'    => esc_html__( 'Premium Verison', 'placid' ),
					'pro_text' => esc_html__( 'Upgrade To Pro', 'placid' ),
					'pro_url'  => 'https://www.templatesell.com/item/placid-plus/',
					'priority' => 0
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @return void
	 * @since  1.0.0
	 * @access public
	 */
	public function enqueue_control_scripts() {
		require_once get_template_directory() . '/inc/customizer-pro/section-pro.php';


		wp_enqueue_script( 'placid-customize-controls', trailingslashit( get_template_directory_uri() ) . '/inc/customizer-pro/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'placid-customize-controls', trailingslashit( get_template_directory_uri() ) . '/inc/customizer-pro/customize-controls.css' );
	}
}

// Doing this customizer thang!
Placid_Customize::get_instance();
