<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package Pixilate
 */

get_header(); ?>

<main id="main" class="site-main" role="main">
	<?php if ( have_posts() ) : ?>
		<header class="page-header panel secondary">
			<h1 class="page-title"><?php printf( __( 'Search Results for: %s', 'pixilate' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
		</header><!-- .page-header -->

		<ul class="posts-grid <?php echo pixilate_arrange_items( $wp_query->post_count ); ?>">
			<?php
			// Start The Loop(tm)
			while ( have_posts() ) : the_post(); ?>
				<li>
					<?php get_template_part( 'content', 'grid' ); ?>
				</li>
			<?php endwhile; ?>
		</ul>

	<?php else : ?>

		<?php get_template_part( 'content', 'none' ); ?>

	<?php endif; ?>

	<?php get_sidebar(); ?>
</main><!-- #main -->

<?php get_footer(); ?>