<?php
/**
 * @package Pixilate
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'panel' ); ?>>
	<?php
	// Display a featured image to the left of the post/search result/etc.
	if ( has_post_thumbnail() ) : ?>
		<div class="featured-image">
			<a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_post_thumbnail(); ?></a>
		</div>
	
		<div class="twothirds">
	<?php else : ?>
		<div class="full-width">
	<?php endif; ?>
	
			<header class="entry-header">
				<h1 class="entry-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h1>

				<?php if ( 'post' == get_post_type() ) : ?>
					<div class="entry-meta">
						<?php pixilate_posted_on(); ?>
					</div><!-- .entry-meta -->
				<?php endif; ?>
			</header><!-- .entry-header -->

			<?php if ( is_search() ) : // Only display Excerpts for Search ?>
				<div class="entry-summary">
					<?php the_excerpt(); ?>
				</div><!-- .entry-summary -->
			<?php else : ?>
				<div class="entry-content">
					<?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'pixilate' ) ); ?>
						<?php
						wp_link_pages( array(
							'before' => '<div class="page-links">' . __( 'Pages:', 'pixilate' ),
							'after'  => '</div>',
						) );
					?>
				</div><!-- .entry-content -->
			<?php endif; ?>

			<hr />
			
			<footer class="entry-meta">
				<?php if ( 'post' == get_post_type() ) : // Hide category and tag text for pages on Search
					if ( is_sticky() ) : ?>
						<p><?php _e( 'Sticky', 'pixilate' ); ?></p>
					<?php endif;
					
					/* translators: used between list items, there is a space after the comma */
					$categories_list = get_the_category_list( __( ', ', 'pixilate' ) );
					if ( $categories_list && pixilate_categorized_blog() ) :
					?>
						<p class="cat-links">
							<?php printf( __( 'Posted in %1$s', 'pixilate' ), $categories_list ); ?>
						</p>
					<?php else : ?>
						<p><?php _e( 'Uncategorized', 'pixilate' ); ?></p>
					<?php endif; // End if categories ?>

					<?php
					/* translators: used between list items, there is a space after the comma */
					$tags_list = get_the_tag_list( '', __( ', ', 'pixilate' ) );
					if ( $tags_list ) :
					?>
						<p class="tags-links">
							<?php printf( __( 'Tagged %1$s', 'pixilate' ), $tags_list ); ?>
						</p>
					<?php else : ?>
						<p><?php _e( 'Untagged', 'pixilate' ); ?></p>
					<?php endif; // End if $tags_list ?>
				<?php endif; // End if 'post' == get_post_type() ?>

				<?php if ( ! post_password_required() && ( comments_open() || '0' != get_comments_number() ) ) : ?>
					<p class="comments-link"><?php comments_popup_link( __( 'Leave a comment', 'pixilate' ), __( '1 Comment', 'pixilate' ), __( '% Comments', 'pixilate' ) ); ?></p>
				<?php endif; ?>

				<?php edit_post_link( __( 'Edit', 'pixilate' ), '<p class="edit-link">', '</p>' ); ?>
			</footer><!-- .entry-meta -->
		</div>
</article><!-- #post-## -->
