<?php
/**
 * This file displays posts formatted into a grid for archive/search/etc.
 *
 * @package Pixilate
 */
?>
<article id="arrange-<?php the_ID(); ?>" <?php post_class( 'panel' ); ?>>
	<?php if ( has_post_thumbnail() ) : ?>
		<div class="featured-image-top">
			<a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_post_thumbnail(); ?></a>
		</div>
	<?php endif; ?>
	
	<header class="entry-header">
		<h1 class="entry-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h1>
		<div class="entry-meta">
			<?php pixilate_posted_on(); ?>
		</div>
	</header>
						
	<section class="entry-summary">
		<?php the_excerpt(); ?>
	</section>
</article>