<?php
/**
 * Handles the actual display of image attachments.
 *
 * @package Pixilate
 */
?>

<article id="image-<?php the_ID(); ?>" <?php post_class( 'panel' ); ?>>
	<header class="entry-header">
		<h1 class="entry-title"><?php the_title(); ?></h1>
		<div class="entry-meta">
			<?php
			global $post;
			
			$date = sprintf( '<a href="%1$s" title="%2$s" rel="bookmark"><time datetime="%3$s">%4$s</time></a>',
				esc_url( get_permalink() ),
				esc_attr( get_the_time() ),
				esc_attr( get_the_date( 'c' ) ),
				esc_html( get_the_date() )
			);
			
			printf( __( 'Posted on %1$s. ', 'pixilate' ), $date );
			
			printf( __( 'Attached to <a href="%1$s">%2$s</a>. ', 'pixilate' ),
				get_permalink( $post->post_parent ),
				get_the_title( $post->post_parent )
			);
			
			if ( wp_attachment_is_image() && 'attachment' == $post->post_type ) :
				$attachment_metadata = wp_get_attachment_metadata( $post->ID );
				printf ( __( 'See full-size image: <a href="%1$s">(%2$s by %3$s)</a>. ', 'pixilate' ),
					esc_html( wp_get_attachment_url( $post->ID ) ),
					$attachment_metadata[ 'height' ],
					$attachment_metadata[ 'width' ]
				);
			endif;
			
			edit_post_link( __( 'Edit this image', 'pixilate' ), null, '.' ); ?>
		</div>
	</header>
	
	<a href="<?php echo esc_html( wp_get_attachment_url( $post->ID ) ); ?>">
		<?php echo wp_get_attachment_image( $post->ID, 'full' ); ?>
	</a>
	
	<?php the_content(); ?>
</article>