<?php
/**
 * Template for displaying image attachments
 *
 * @package Pixilate
 */
 
get_header(); ?>

<main id="primary" class="site-main" role="main">
	<?php while ( have_posts() ) : the_post(); ?>

		<?php get_template_part( 'content', 'attachment' ); ?>

		<nav class="attachment-navigation" role="navigation">
			<h2 class="screen-reader-text"><?php _e( 'Gallery navigation', 'pixilate' ); ?></h2>
			<div class="nav-previous">
				<?php previous_image_link( 'fullsize', __( '&larr; Previous Image', 'pixilate' ) ); ?>
			</div>
			
			<div class="nav-next">
				<?php next_image_link( 'fullsize', __( 'Next Image &rarr;', 'pixilate' ) ); ?>
			</div>
		</nav>

		<?php
		// If comments are open or we have at least one comment, load up the comment template
		if ( comments_open() || '0' != get_comments_number() ) :
			comments_template();
		endif;
		?>

	<?php endwhile; // end of the loop. ?>

	<?php get_sidebar(); ?>
</main><!-- #main -->

<?php get_footer(); ?>