<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Pixilate
 */

get_header(); ?>

<main id="primary" class="site-main" role="main">
	<?php
	if ( have_posts() ) : ?>

		<header class="page-header panel secondary">
			<h1 class="page-title">
				<?php
				if ( is_category() ) :
					printf( __( 'Category: %1$s', 'pixilate' ), single_cat_title( '', false ) );
					
				elseif ( is_tag() ) :
					printf( __( 'Tag: %1$s', 'pixilate' ), single_tag_title( '', false ) );

				elseif ( is_author() ) :
					printf( __( 'Author: %s', 'pixilate' ), '<span class="vcard">' . get_the_author() . '</span>' );

				elseif ( is_day() ) :
					printf( __( 'Day: %s', 'pixilate' ), '<span>' . get_the_date() . '</span>' );

				elseif ( is_month() ) :
					printf( __( 'Month: %s', 'pixilate' ), '<span>' . get_the_date( _x( 'F Y', 'monthly archives date format', 'pixilate' ) ) . '</span>' );

				elseif ( is_year() ) :
					printf( __( 'Year: %s', 'pixilate' ), '<span>' . get_the_date( _x( 'Y', 'yearly archives date format', 'pixilate' ) ) . '</span>' );

				elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
					_e( 'Asides', 'pixilate' );

				elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) :
					_e( 'Galleries', 'pixilate');

				elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
					_e( 'Images', 'pixilate');

				elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
					_e( 'Videos', 'pixilate' );

				elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
					_e( 'Quotes', 'pixilate' );

				elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
					_e( 'Links', 'pixilate' );

				elseif ( is_tax( 'post_format', 'post-format-status' ) ) :
					_e( 'Statuses', 'pixilate' );

				elseif ( is_tax( 'post_format', 'post-format-audio' ) ) :
					_e( 'Audios', 'pixilate' );

				elseif ( is_tax( 'post_format', 'post-format-chat' ) ) :
					_e( 'Chats', 'pixilate' );

				else :
					_e( 'Archives', 'pixilate' );

				endif;
				?>
			</h1>
		</header><!-- .page-header -->

		<ul class="posts-grid <?php echo pixilate_arrange_items( $wp_query->post_count ); ?>">
			<?php
			// Start The Loop(tm)
			while ( have_posts() ) : the_post(); ?>
				<li>
					<?php get_template_part( 'content', 'grid' ); ?>
				</li>
			<?php endwhile; ?>
		</ul>
	<?php else : ?>

		<?php get_template_part( 'content', 'none' ); ?>

	<?php endif; ?>

	<?php get_sidebar(); ?>
</main><!-- #main -->

<?php get_footer(); ?>