<?php
/**
 *	Sidebar Recent Posts
 *  Featured Post Footer
 *  Scroll to Top
 */ 
function pixanews_general_settings_customize_register( $wp_customize ) {
	$wp_customize->add_panel(
		'pixanews-additional-settings', array(
			'title'		=>	__('PixaNews Options', 'pixanews'),
			'priority'	=>	20
		)
	);

	// Scroll to Top
	$wp_customize-> add_section('pixanews-scrl-to-top', array(
		'title'                    => __('Scroll to Top','pixanews'),
		'description'              => __('Check the box to disable scroll to top','pixanews'),
	
	 ));
	
	 $wp_customize-> add_setting('pixanews-scrl-to-top-set', array(
		'type'                     => 'theme_mod',
		'sanitize_callback'        => 'pixanews_sanitize_checkbox',
	 ));
	 
	 $wp_customize-> add_control( 'pixanews-scrl-to-top', array(
		'label'                   => __('Enable Scroll to Top','pixanews'),
		'description'             => __('Check the box to disable scroll to top','pixanews'),
		'section'                 => 'pixanews-scrl-to-top',
		'settings'                => 'pixanews-scrl-to-top-set',
		'type'                    => 'checkbox',
	 ));

	 //checkbox sanitization 
	function pixanews_sanitize_checkbox( $input ) {
	
		// Boolean check 
		return ( ( isset( $input ) && true == $input ) ? true : false );
	}
     

	 // Enable/disable Read More
	 $wp_customize-> add_section('pixanews-readmore', array(
		'title'                    => __('Read More','pixanews'),
		'type'                     => 'theme_mod',
		'sanitize_callback'        => 'pixanews_sanitize_checkbox'
	 ));

	 $wp_customize-> add_setting('pixanews-readmore-set', array(
		'type'                     => 'theme_mod',
		'sanitize_callback'        => 'pixanews_sanitize_checkbox'
	 ));

	 $wp_customize-> add_control( 'pixanews-readmore-set-ctrl', array(
		'label'                   => __('Enable Read More','pixanews'),
		'description'             => __('Check the box to Enable Read More','pixanews'),
		'section'                 => 'pixanews-readmore',
		'settings'                => 'pixanews-readmore-set',
		'type'                    => 'checkbox',
	 ));

	 
function pixanews_sanitize_font_size($value) {
    // Ensure the value is an integer.
    $value = absint($value);

    // Check the value is within our desired range.
    if ($value < 10 || $value > 100) {
        // Set to a default value if the provided value is outside the range.
        $value = 22; // Assuming 22 is a sensible default. Adjust as needed.
    }

    return $value;
}

// Hook into the 'customize_register' action to add your sections, settings, and controls.
add_action('customize_register', 'pixanews_customize_register');


    // Add Section for Font Sizes
    $wp_customize->add_section('pixanews-font-sizes', array(
        'title'    => __('Typography', 'pixanews'),
        'priority' => 30,
		'description' => 'You can control font-size of the main content area from here. Keep in mind that this is limited to the main content area and does not work with other layouts such as featured area and sidebar.'
    ));

    // Define the headings array.
    $headings = array('H1', 'H2', 'H3', 'H4', 'H5', 'H6');

    // Loop through each heading to add settings and controls.
    foreach ($headings as $heading) {
        // Generate a setting ID based on the heading.
        $setting_id = 'pixanews_' . strtolower($heading) . '_font_size';

        // Add Setting with sanitize callback
        $wp_customize->add_setting($setting_id, array(
            'default'           => '24', // Default font size. Adjust as needed.
            'transport'         => 'refresh',
            'sanitize_callback' => 'pixanews_sanitize_font_size',
        ));

        // Add Control
        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            $setting_id . '_control',
            array(
                'label'       => sprintf(__('%s Font Size', 'pixanews'), $heading),
                'section'     => 'pixanews-font-sizes',
                'settings'    => $setting_id,
                'type'        => 'number',
                'input_attrs' => array(
                    'min'  => 10,
                    'max'  => 100,
                    'step' => 1,
                ),
            )
        ));
    }

    // Font size for paragraph - Setting and Control.
    $wp_customize->add_setting('pixanews-font-sizes_paragraph_set', array(
        'default'           => '16', // Default paragraph font size. Adjust as needed.
        'transport'         => 'refresh',
        'sanitize_callback' => 'pixanews_sanitize_font_size',
    ));

    // Add Control for paragraph font size.
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        'pixanews-font-sizes_paragraph_control',
        array(
            'label'       => __('Paragraph Font Size', 'pixanews'),
            'section'     => 'pixanews-font-sizes',
            'settings'    => 'pixanews-font-sizes_paragraph_set',
            'type'        => 'number',
            'input_attrs' => array(
                'min'  => 10,
                'max'  => 100,
                'step' => 1,
            ),
        )
    ));

	   }
	
add_action('customize_register', 'pixanews_general_settings_customize_register');