<?php
/**
 * Functions.php
 *
 * Magic happens here,
 * If you're not comfortable with PHP / WordPress, please do not edit this file.
 * Otherwise, happy hacking! ;)
 *
 * @package WordPress
 * @subpackage Pisces
 * @since Pisces 1.0
 * @author wplovin <hello@wplovin.com>
 */

/**
 * Setup some basic constants.
 *
 * @since Pisces 1.0
 */
define( 'WPLOVIN_THEME_NAME', 'Pisces' );
define( 'WPLOVIN_THEME_SLUG', 'pisces' );
define( 'WPLOVIN_THEME_VERSION', '1.0.7' );
define( 'WPLOVIN_THEME_AUTHOR', 'wplovin' );
define( 'WPLOVIN_THEME_AUTHOR_URL', 'http://wplovin.com' );
define( 'WPLOVIN_THEME_PATH', get_template_directory_uri() );

/**
 * Oh, let's add some useful stuff we'll need later.
 *
 * @since Pisces 1.0
 */
function wplovin_setup() {

	if ( ! isset( $content_width ) ) 
		$content_width = 1050;

	load_theme_textdomain( 'pisces', get_template_directory() . '/languages' );
	
	$background_defaults = array(
		'default-color'          => '#f1f1f1',
		'default-image'          => WPLOVIN_THEME_PATH . '/images/bg.jpg',
		'wp-head-callback'       => 'wplovin_custom_background_cb',
		'admin-head-callback'    => 'wplovin_custom_background_admin_css'
	);
	add_theme_support( 'custom-background', $background_defaults );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );
	add_theme_support( 'post-formats', array( 'aside', 'audio', 'chat', 'gallery', 'image', 'link', 'quote', 'status', 'video' ) );
	add_theme_support( 'post-thumbnails' );

	register_nav_menu( 'primary', __( 'Navigation Menu', 'pisces' ) );
	register_nav_menu( 'social', __( 'Social Links', 'pisces' ) );

	add_filter( 'use_default_gallery_style', '__return_false' );
	
	set_post_thumbnail_size( 730, 320, true );
	add_image_size( 'archive-thumbnail', 700, 0, false );
	//add_editor_style( array( 'editor-style.css' ) );
	// Sorry, no editor styles in 1.0! ;(
	
}
add_action( 'after_setup_theme', 'wplovin_setup' );

/**
 * Register widgetized areas.
 *
 * @since Pisces 1.0
 */
function wplovin_sidebar_init() {

	register_sidebar( array(
		'name'          => __( 'Main Widget Area', 'pisces' ),
		'id'            => 'sidebar-1',
		'description'   => __( 'Main sidebar.', 'pisces' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );	
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget Area', 'pisces' ),
		'id'            => 'footer-1',
		'description'   => __( 'Main footer.', 'pisces' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s one-third">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	
}
add_action( 'widgets_init', 'wplovin_sidebar_init' );

/**
 * Conditionally include needed JavaScript plugins, stylesheets, etc.
 *
 * @since Pisces 1.0
 */
function wplovin_scripts_styles() {
	
	$options = array();
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) 
		wp_enqueue_script( 'comment-reply' );
		

	wp_enqueue_script( WPLOVIN_THEME_SLUG .'-fitvids-js', WPLOVIN_THEME_PATH . '/js/jquery.fitvids.js', array( 'jquery' ), 'v1.0.3', true );
	wp_enqueue_script( WPLOVIN_THEME_SLUG .'-backstretch-js', WPLOVIN_THEME_PATH . '/js/jquery.backstretch.min.js', array( 'jquery' ), 'v2.0.4', true );
	wp_enqueue_script( 'jquery-masonry' );	
	
	wp_enqueue_style( WPLOVIN_THEME_SLUG . '-style', get_stylesheet_uri(), array(), '1.0' );
	wp_enqueue_style( WPLOVIN_THEME_SLUG . '-fa-icons', WPLOVIN_THEME_PATH . '/assets/font-awesome/css/font-awesome.min.css', array(), 'v4.0.3' );
	wp_enqueue_style( WPLOVIN_THEME_SLUG . '-roboto', wplovin_fonts_url(), array(), null );	
	
	wp_enqueue_script( WPLOVIN_THEME_SLUG .'-scripts-js', WPLOVIN_THEME_PATH . '/js/scripts.js', array( 'jquery' ), 'v1.0', true );
	
	if ( is_active_sidebar( 'footer-1' ) ) {
		wp_localize_script( WPLOVIN_THEME_SLUG .'-scripts-js', 'wplovin_footer_masonry', 'enabled' );
	}

}
add_action( 'wp_enqueue_scripts', 'wplovin_scripts_styles' );

/**
 * Function which prints out the post meta.
 *
 * @since Pisces 1.0
 */
if ( ! function_exists( 'wplovin_post_meta' ) ) {

	function wplovin_post_meta() {
		$date = wplovin_get_date(); 
		
		if ( $date ) {
			echo $date;
		}
		if( 'chat' != get_post_format() || 'quote' != get_post_format() ) {
			$categories = get_the_category_list( __( ', ', 'pisces' ) );
			if ( $categories ) {
				echo '<span class="categories"><i class="fa fa-folder-open"></i>' . $categories . '</span>';
			}

			$tags = get_the_tag_list( '', __( ', ', 'pisces' ) );
			if ( $tags ) {
				echo '<span class="tags"><i class="fa fa-tags"></i>' . $tags . '</span>';
			}
		}
	}
	
}

/**
 * Function which returns the post date.
 *
 * @since Pisces 1.0
 */
if ( ! function_exists( 'wplovin_get_date' ) ) {

	function wplovin_get_date() {
	
		if ( has_post_format( array( 'chat', 'status' ) ) )
			$format_prefix = _x( '%1$s on %2$s', '1: post format name. 2: date', 'pisces' );
		else
			$format_prefix = '%2$s';

		$date = sprintf( '<span class="date"><i class="fa fa-calendar-o"></i><a href="%1$s" title="%2$s" rel="bookmark"><time class="entry-date" datetime="%3$s">%4$s</time></a></span>',
			esc_url( get_permalink() ),
			esc_attr( sprintf( __( 'Permalink to %s', 'pisces' ), the_title_attribute( 'echo=0' ) ) ),
			esc_attr( get_the_date( 'c' ) ),
			esc_html( sprintf( $format_prefix, get_post_format_string( get_post_format() ), get_the_date() ) )
		);

		return $date;

	}
	
}

/**
 * Function which prints out the paging on archive pages.
 *
 * @since Pisces 1.0
 */
if ( ! function_exists( 'wplovin_archive_pager' ) ) {

	function wplovin_archive_pager() {
	
		global $wp_query;
		
		if ( $wp_query->max_num_pages < 2 ) {
			return;
		} else {
		?>
		<nav class="paging-navigation" role="navigation">
			<div class="nav-links">

				<?php if ( get_next_posts_link() ) : ?>
				<div class="pager-link nav-previous"><?php next_posts_link( __( '<i class="fa fa-angle-right"></i>', 'pisces' ) ); ?></div>
				<?php endif; ?>

				<?php if ( get_previous_posts_link() ) : ?>
				<div class="pager-link nav-next"><?php previous_posts_link( __( '<i class="fa fa-angle-left"></i>', 'pisces' ) ); ?></div>
				<?php endif; ?>

			</div>
		</nav>
		<?php
		}
		
	}
}

/**
 * Function which prints out archive header.
 *
 * @since Pisces 1.0
 */
if ( ! function_exists( 'wplovin_archive_header' ) ) {

	function wplovin_archive_header() { 
	
		if( !is_home() ) { ?>
		<header class="archive-header">
			<h3 class="archive-title"><?php
				if ( is_day() ) :
					printf( __( 'Daily archives: %s', 'pisces' ), '<span>' . get_the_date() . '</span>' );
				elseif ( is_month() ) :
					printf( __( 'Monthly archives: %s', 'pisces' ), '<span>' . get_the_date( _x( 'F Y', 'monthly archives date format', 'pisces' ) ) . '</span>' );
				elseif ( is_year() ) :
					printf( __( 'Yearly archives: %s', 'pisces' ), '<span>' . get_the_date( _x( 'Y', 'yearly archives date format', 'pisces' ) ) . '</span>' );
				elseif ( is_category() )  :
					printf( __( 'Category archives: %s', 'pisces' ), '<span>' . single_cat_title( '', false ) . '</span>' );
				elseif ( is_tag() )  :
					printf( __( 'Tag archives: %s', 'pisces' ), '<span>' . single_tag_title( '', false ) . '</span>' );				
				elseif ( is_search() )  :
					printf( __( 'Search results: %s', 'pisces' ), '<span>' . esc_html( $_GET['s'] ) . '</span>' );
				else : 
					_e( 'Archives', 'pisces' ); 
				endif;
			?></h3>
		</header>
	<?php } 
	
	}
}


/**
 * Filter the page title.
 *
 * @since Pisces 1.0
 */
function wplovin_wp_title( $title, $sep ) {

	global $paged, $page;

	if ( is_feed() )
		return $title;

	$title .= get_bloginfo( 'name' );

	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title = "$title $sep $site_description";

	if ( $paged >= 2 || $page >= 2 )
		$title = "$title $sep " . sprintf( __( 'Page %s', 'pisces' ), max( $paged, $page ) );

	return $title;
	
}
add_filter( 'wp_title', 'wplovin_wp_title', 10, 2 ); 
 
/**
 * Default background image size, until jQuery backstretch is activated.
 *
 * @since Pisces 1.0
 */
function wplovin_default_background_image_size( $size ) {

	$size = 960;
	return $size;
	
}
add_filter( 'wplovin_background_image_size', 'wplovin_default_background_image_size', 10, 1 );

/**
 * Custom background image front-end callback.
 * If image size exceeds filtered width value - enable jQuery backstretch.
 *
 * @since Pisces 1.0
 */
function wplovin_custom_background_cb() {

	$background_image = get_background_image();
	$background_color = get_theme_mod( 'background_color' );
	$style = 'background-color: #' . $background_color;
	
	if( !$background_image ) {
		_custom_background_cb();
		return;
	}
	list( $width, $height ) = getimagesize( $background_image );
	
	/*
	 * wplovin_default_background_image_size();
	 * Priority - 10, returns - 960.
	*/
	$size_limit = apply_filters( 'wplovin_background_image_size', 0 );
	
	if( $width < $size_limit ) {
		_custom_background_cb();
	} else { ?>
		<style type="text/css" id="custom-background-css">
		body.custom-background { <?php echo trim( $style ); ?> }
		</style>
		<?php
		wp_localize_script( WPLOVIN_THEME_SLUG .'-scripts-js', 'wplovin_background_url', $background_image );
	}
	
}

/**
 * Custom background image back-end callback.
 * If image size exceeds filtered width value - set preview image background-size to 'cover'.
 *
 * @since Pisces 1.0
 */
function wplovin_custom_background_admin_css() {

	$background_image = get_background_image();
	if( !$background_image ) return;
	list( $width, $height ) = getimagesize( $background_image );
	
	/*
	 * wplovin_default_background_image_size();
	 * Priority - 10, returns - 960.
	*/
	$size_limit = apply_filters( 'wplovin_background_image_size', 0 );
	
	if( $width < $size_limit ) {
		return false;
	} else { ?>
		<style type="text/css">
			#custom-background-image {background-size: cover; max-width: 960px;}
		</style>
	<?php }
	
}

/**
 * Filters out empty post title, and sets it to 'Untitled'.
 *
 * @since Pisces 1.0
 */
function wplovin_filter_post_title( $title ){
	if( $title == '' || !$title ) {
		$title = 'Untitled';
	}
	return $title;
}
add_filter( 'the_title', 'wplovin_filter_post_title' );

/**
 * Return the Google font stylesheet URL, if available.
 *
 * The use of Roboto Slab by default is localized. For languages
 * that use characters not supported by the font, the font can be disabled.
 *
 * Credits: Twenty Thirteen.
 *
 * @return string Font stylesheet or empty string if disabled.
 */
function wplovin_fonts_url() {
	$fonts_url = '';

	/* Translators: If there are characters in your language that are not
	 * supported by Source Sans Pro, translate this to 'off'. Do not translate
	 * into your own language.
	 */
	$roboto_slab = _x( 'on', 'Roboto Slab font: on or off', 'pisces' );

	if ( 'off' !== $roboto_slab ) {
		$font_families = array();

		if ( 'off' !== $roboto_slab )
			$font_families[] = 'Roboto Slab:400,300,100,700';
	
		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);
		$fonts_url = add_query_arg( $query_args, "//fonts.googleapis.com/css" );
		
	}
	return $fonts_url;
}

/**
 * Go on! This theme is meant for hacking. 
 *
 * Add some codes below this line to tweak it further, and don't forget to report the bugs to hello@wplovin.com, thanks!
 *
 * CAUTION: all the changes you do to this file, will be lost upon theme update. 
 * I would highly recommend making changes only in a child theme.
 * http://codex.wordpress.org/Child_Themes
 *
 */