<?php
/**
 * Add body_class() classes
 */
function pinnacle_body_class($classes) {
  // Add post/page slug
  if (is_single() || is_page() && !is_front_page()) {
    $classes[] = basename(get_permalink());
  }

  return $classes;
}
add_filter('body_class', 'pinnacle_body_class');


/**
 * Add class="thumbnail" to attachment items
 */
function pinnacle_attachment_link_class($html) {
  $postid = get_the_ID();
  $html = str_replace('<a', '<a class="thumbnail"', $html);
  return $html;
}
add_filter('wp_get_attachment_link', 'pinnacle_attachment_link_class', 10, 1);



function pinnacle_caption($output, $attr, $content) {
  if (is_feed()) {
    return $output;
  }

  $defaults = array(
    'id'      => '',
    'align'   => 'alignnone',
    'width'   => '',
    'caption' => ''
  );

  $attr = shortcode_atts($defaults, $attr);

  // If the width is less than 1 or there is no caption, return the content wrapped between the [caption] tags
  if ($attr['width'] < 1 || empty($attr['caption'])) {
    return $content;
  }

  // Set up the attributes for the caption <figure>
  $attributes  = (!empty($attr['id']) ? ' id="' . esc_attr($attr['id']) . '"' : '' );
  $attributes .= ' class="thumbnail wp-caption ' . esc_attr($attr['align']) . '"';
  $attributes .= ' style="width: ' . esc_attr($attr['width']) . 'px"';

  $output  = '<figure' . $attributes .'>';
  $output .= do_shortcode($content);
  $output .= '<figcaption class="caption wp-caption-text">' . $attr['caption'] . '</figcaption>';
  $output .= '</figure>';

  return $output;
}
add_filter('img_caption_shortcode', 'pinnacle_caption', 10, 3);

/**
 * Wrap embedded media
 */
function virtue_embed_wrap( $cache, $url, $attr = '', $post_ID = '' ) {
  if ( ! has_blocks() ) {
    $cache = '<div class="entry-content-asset videofit">' . $cache . '</div>';
  }
  return $cache;
}
add_filter( 'embed_oembed_html', 'virtue_embed_wrap', 90, 4 );


/**
 * Clean up the_excerpt()
 */
function pinnacle_excerpt_length($length) {
  return POST_EXCERPT_LENGTH;
}
add_filter('excerpt_length', 'pinnacle_excerpt_length');
function pinnacle_excerpt_more($more) {
  $readmore =  __('Read More', 'pinnacle') ;
  return ' &hellip; <a href="' . get_permalink() . '">'. $readmore . '</a>';
}
add_filter('excerpt_more', 'pinnacle_excerpt_more');

/**
 * Add additional classes onto widgets
 *
 * @link http://wordpress.org/support/topic/how-to-first-and-last-css-classes-for-sidebar-widgets
 */
function pinnacle_widget_first_last_classes($params) {
  global $my_widget_num;

  $this_id = $params[0]['id'];
  $arr_registered_widgets = wp_get_sidebars_widgets();

  if (!$my_widget_num) {
    $my_widget_num = array();
  }

  if (!isset($arr_registered_widgets[$this_id]) || !is_array($arr_registered_widgets[$this_id])) {
    return $params;
  }

  if (isset($my_widget_num[$this_id])) {
    $my_widget_num[$this_id] ++;
  } else {
    $my_widget_num[$this_id] = 1;
  }

  $class = 'class="widget-' . $my_widget_num[$this_id] . ' ';

  if ($my_widget_num[$this_id] == 1) {
    $class .= 'widget-first ';
  } elseif ($my_widget_num[$this_id] == count($arr_registered_widgets[$this_id])) {
    $class .= 'widget-last ';
  }

  $params[0]['before_widget'] = preg_replace('/class=\"/', "$class", $params[0]['before_widget'], 1);

  return $params;
}
add_filter('dynamic_sidebar_params', 'pinnacle_widget_first_last_classes');

