<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Pikture
 * @since Pikture 1.0.0
 */

get_header(); ?>

	<div class="container page-section clear">
		<div id="primary" class="content-area">
			<main id="main" class="site-main" role="main">
				<div class="archive-blog-wrapper">

					<?php
					if ( have_posts() ) : ?>

						<header class="page-header">
							<?php
								the_archive_title( '<h1 class="page-title">', '</h1>' );
								the_archive_description( '<div class="archive-description">', '</div>' );
							?>
						</header><!-- .page-header -->

						<?php
						/* Start the Loop */
						while ( have_posts() ) : the_post();

							/*
							 * Include the Post-Format-specific template for the content.
							 * If you want to override this in a child theme, then include a file
							 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
							 */
							get_template_part( 'template-parts/content', get_post_format() );

						endwhile;

					else :

						get_template_part( 'template-parts/content', 'none' );

					endif; 
					
					/**
					* Hook - pikture_action_pagination.
					*
					* @hooked pikture_pagination 
					*/
					do_action( 'pikture_action_pagination' ); 
					?>

				</div>
			</main><!-- #main -->
		</div><!-- #primary -->
		<?php 
		if ( pikture_is_sidebar_enable() ) {
			get_sidebar();
		}
		?>
	</div><!-- .container -->

<?php
get_footer();
