<?php
/**
 * Piedmont functions and definitions
 *
 * @package Piedmont
 */

if ( ! isset( $content_width ) ) {
	$content_width = 845; /* pixels */
}

if ( ! function_exists( 'piedmont_setup' ) ) :

function piedmont_setup() {

	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'post-thumbnails' );
	add_image_size( 'piedmont-full-width', 1100, 400, true );
	add_image_size( 'piedmont-featured', 905, 400, true );

	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'piedmont' ),
	) );
	
	add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'quote', 'link' ) );
	
	add_theme_support( 'custom-background', apply_filters( 'piedmont_custom_background_args', array(
		'default-color' => 'edeff2',
		'default-image' => '',
	) ) );
}
endif;
add_action( 'after_setup_theme', 'piedmont_setup' );

/**
 * Register widgetized area and update sidebar with default widgets.
 */
function piedmont_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Sidebar', 'piedmont' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );
}
add_action( 'widgets_init', 'piedmont_widgets_init' );

function piedmont_font_url() {
	$font_url = add_query_arg( 'family', urlencode( 'Open Sans:300,400,600,300italic,400italic,600italic' ), "//fonts.googleapis.com/css" );
	return $font_url;
}

/**
 * Enqueue scripts and styles.
 */
function piedmont_scripts() {
	wp_enqueue_style( 'piedmont-open-sans', piedmont_font_url(), array(), null );
	
	wp_enqueue_style( 'piedmont-style', get_stylesheet_uri() );

	wp_enqueue_script( 'piedmont-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true );

	wp_enqueue_script( 'piedmont-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'piedmont_scripts' );

function piedmont_add_editor_styles() {
    add_editor_style( 'editor-style.css' );
}
add_action( 'init', 'piedmont_add_editor_styles' );

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
