<?php
/**
 * @package Piedmont
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php piedmont_post_thumbnail(); ?>
	
	<header class="entry-header">
		<h1 class="entry-title"><?php the_title(); ?></h1>

		<div class="entry-meta">
			
		</div><!-- .entry-meta -->
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php the_content(); ?>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'piedmont' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-meta">
		<?php piedmont_posted_on(); ?>
		<span class="sep"> | </span>
		<?php
			/* translators: used between list items, there is a space after the comma */
			$category_list = get_the_category_list( __( ', ', 'piedmont' ) );

			/* translators: used between list items, there is a space after the comma */
			$tag_list = get_the_tag_list( '', __( ', ', 'piedmont' ) );

			if ( ! piedmont_categorized_blog() ) {
				// This blog only has 1 category so we just need to worry about tags in the meta text
				if ( '' != $tag_list ) {
					$meta_text = __( 'Tags: %2$s <span class="sep"> | </span> Bookmark the <a href="%3$s" rel="bookmark">permalink</a>.', 'piedmont' );
				} else {
					$meta_text = __( 'Bookmark the <a href="%3$s" rel="bookmark">permalink</a>.', 'piedmont' );
				}

			} else {
				// But this blog has loads of categories so we should probably display them here
				if ( '' != $tag_list ) {
					$meta_text = __( 'Categories: %1$s <span class="sep"> | </span> Tags: %2$s <span class="sep"> | </span> Bookmark the <a href="%3$s" rel="bookmark">permalink</a>.', 'piedmont' );
				} else {
					$meta_text = __( 'Categories: %1$s <span class="sep"> | </span> Bookmark the <a href="%3$s" rel="bookmark">permalink</a>.', 'piedmont' );
				}

			} // end check for categories on this blog

			printf(
				$meta_text,
				$category_list,
				$tag_list,
				get_permalink()
			);
		?>

		<?php edit_post_link( __( 'Edit', 'piedmont' ), '<span class="sep"> | </span><span class="edit-link">', '</span>' ); ?>
	</footer><!-- .entry-meta -->
</article><!-- #post-## -->
