<?php
/**
 * @package Piedmont
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php piedmont_post_thumbnail(); ?>
	
	<header class="entry-header">
		<h1 class="entry-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h1>
	</header><!-- .entry-header -->

	<div class="entry-summary">
		<?php the_excerpt(); ?>
	</div><!-- .entry-summary -->

	<footer class="entry-meta">
		<?php piedmont_posted_on(); ?>
			
		<?php if ( 'post' == get_post_type() ) : // Hide category and tag text for pages on Search ?>
			<span class="sep"> | </span>
			<?php
				/* translators: used between list items, there is a space after the comma */
				$categories_list = get_the_category_list( __( ', ', 'piedmont' ) );
				if ( $categories_list && piedmont_categorized_blog() ) :
			?>
			<span class="cat-links">
				<?php printf( __( 'Categories: %1$s', 'piedmont' ), $categories_list ); ?>
			</span>
			<?php endif; // End if categories ?>

			<?php
				/* translators: used between list items, there is a space after the comma */
				$tags_list = get_the_tag_list( '', __( ', ', 'piedmont' ) );
				if ( $tags_list ) :
			?>
			<span class="sep"> | </span>
			<span class="tags-links">
				<?php printf( __( 'Tags: %1$s', 'piedmont' ), $tags_list ); ?>
			</span>
			<?php endif; // End if $tags_list ?>
		<?php endif; // End if 'post' == get_post_type() ?>

		<?php if ( ! post_password_required() && ( comments_open() || '0' != get_comments_number() ) ) : ?>
		<span class="sep"> | </span>
		<span class="comments-link"><?php comments_popup_link( __( 'Leave a comment', 'piedmont' ), __( '1 Comment', 'piedmont' ), __( '% Comments', 'piedmont' ) ); ?></span>
		<?php endif; ?>

		<?php edit_post_link( __( 'Edit', 'piedmont' ), '<span class="sep"> | </span><span class="edit-link">', '</span>' ); ?>
	</footer><!-- .entry-meta -->
</article><!-- #post-## -->
