<?php    
$picolog_page_builder = esc_html(__( 'Page Builder', 'picolog' ));
$picolog_page_builder_details = esc_html(__('Theme supports Page Builder. You can drag and drop our widgets with page builder visual editor.', 'picolog' ));
$picolog_page_layout = esc_html(__( 'Page Layout', 'picolog' ));
$picolog_page_layout_details = esc_html(__('Theme offers many different page layouts so you can quickly and easily create your pages with no hassle!', 'picolog' ));
$picolog_unlimited_sidebar = esc_html(__( 'Unlimited Sidebar', 'picolog' ));
$picolog_unlimited_sidebar_details = esc_html(__( 'Theme includes a different sidebar layouts. Unlimited sidebars allow you to create custom sidebars that match the style and layout of pages!', 'picolog' ));
$picolog_custom_widget = esc_html(__( 'Custom Widget', 'picolog' ));
$picolog_custom_widget_details = esc_html(__( 'We offer many custom widgets that are stylized and ready for use. Simply drag & drop into place to activate!', 'picolog' ));
$picolog_portfolio = esc_html(__( 'Multi Portfolio', 'picolog' ));
$picolog_portfolio_details = esc_html(__( 'Theme have a unlimited customization options in portfolio. You can use 2, 3, or 4 Columns with masonry layouts!', 'picolog' ));
$picolog_typography = esc_html(__( 'Typography', 'picolog' ));
$picolog_typography_details = esc_html(__('Theme loves typography, you can choose from over 500+ Google Fonts and Standard Fonts to customize your site!', 'picolog' ));
$picolog_slider = esc_html(__( 'Awesome Sliders', 'picolog' ));
$picolog_slider_details = esc_html(__('Theme includes Flex and Elastic sliders . You can use flexslider as a image,video and google map anywhere in your site.', 'picolog' ));
$picolog_woocommerce = esc_html(__( 'Woo Commerce', 'picolog' ));
$picolog_woocommerce_details = esc_html(__('Theme has full design/code integration for WooCommerce, your shop will look as good as the rest of your site!', 'picolog' ));
$picolog_retina_ready = esc_html(__( 'Retina Ready', 'picolog' ));
$picolog_retina_ready_details = esc_html(__( 'Theme is Retina Ready. So, Everything looks amazingly sharp and crisp on high resolution retina displays of all sizes!', 'picolog' ));
$picolog_icons = esc_html(__( 'Icons', 'picolog' ));
$picolog_icons_details = esc_html(__( ' Choose from over 2500 icons are fully integrated into the theme. Use them anywhere in your site with select your own size and color.', 'picolog' ));
$picolog_support = esc_html(__( 'Excellent Support', 'picolog' ));
$picolog_support_details = esc_html(__( 'We truly care about our customers and themes performance. We assure you that you will get the best after sale support like never before!', 'picolog' ));
$picolog_responsive_layout = esc_html(__( 'Responsive Layout', 'picolog' ));
$picolog_responsive_layout_details = esc_html( __('Theme is fully responsive and can adapt to any screen size. Resize your browser window to view it!', 'picolog' ));
$picolog_testimonials = esc_html( __( 'Testimonials', 'picolog' ));
$picolog_testimonials_details = esc_html( __( 'Display your clients\' glowing comments about your business on your homepage. Showing a specific number of testimonials with use of testimonial widget. ', 'picolog' ));
$picolog_social_media = esc_html( __( 'Social Media', 'picolog' ));
$picolog_social_media_details = esc_html( __( 'Want your users to stay in touch? No problem, Theme has Social Media icons all throughout the theme!', 'picolog' ));
$picolog_google_map = esc_html( __( 'Google Map', 'picolog' ));
$picolog_google_map_details = esc_html( __('Theme includes Goole Map widget. Find a place on the map and get directions. Or get info like business hours and menus, and see Street View imagery.', 'picolog' ));
$picolog_customization = esc_html( __( 'Customization', 'picolog' ));
$picolog_customization_details = esc_html( __('With advanced theme options, page options & extensive docs, its never been easier to customize a theme!', 'picolog' ));
$picolog_demo_content = esc_html( __( 'Demo content', 'picolog' ));
$picolog_demo_content_details = esc_html( __('Theme includes single click demo content. You can quickly setup the site like our demo and get started easily!', 'picolog' ));
$picolog_improvement = esc_html( __( 'Improvement', 'picolog' ));
$picolog_improvement_details = esc_html( __('We love our theme and customers. We are committed to improve and add new features to Theme!', 'picolog' ));

$picolog_view_demo = esc_html( __( 'View Demo', 'picolog'));
$picolog_upgrade_to_pro = esc_html( __( 'Upgrade To Pro', 'picolog' ));


$picolog_why_upgrade = <<< FEATURES

<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-cog"></i></div>
	<h3>$picolog_page_builder</h3>
	<p>$picolog_page_builder_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-th-large"></i></div>
	<h3>$picolog_page_layout</h3>
	<p>$picolog_page_layout_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-th"></i></div>
	<h3>$picolog_unlimited_sidebar</h3>
	<p>$picolog_unlimited_sidebar_details</p>
</div>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-code-fork"></i></div>
	<h3>$picolog_custom_widget</h3>
	<p>$picolog_custom_widget_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-list-alt"></i></div>
	<h3>$picolog_portfolio</h3>
	<p>$picolog_portfolio_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-font"></i></div>
	<h3>$picolog_typography</h3>
	<p>$picolog_typography_details</p>
</div>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-slideshare"></i></div>
	<h3>$picolog_slider</h3>
	<p>$picolog_slider_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-shopping-cart"></i></div>
	<h3>$picolog_woocommerce</h3>
	<p>$picolog_woocommerce_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-magic"></i></div>
	<h3>$picolog_retina_ready</h3>
	<p>$picolog_retina_ready_details</p>
</div>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-dashboard"></i></div>
	<h3>$picolog_icons</h3>
	<p>$picolog_icons_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-magic"></i></div>
	<h3>$picolog_support</h3>
	<p>$picolog_support_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-desktop"></i></div>
	<h3>$picolog_responsive_layout</h3>
	<p>$picolog_responsive_layout_details</p>
</div>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-rocket"></i></div>
	<h3>$picolog_testimonials</h3>
	<p>$picolog_testimonials_details</p>
</div>
<div class="one-third column"> 
	<div class="icon-wrap"><i class="fa  fa-5x fa-skype"></i></div>
	<h3>$picolog_social_media</h3>
	<p>$picolog_social_media_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-map-marker"></i></div>
	<h3>$picolog_google_map</h3>
	<p>$picolog_google_map_details</p>
</div>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-edit"></i></div>
	<h3>$picolog_customization</h3>
	<p>$picolog_customization_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-check"></i></div>
	<h3>$picolog_demo_content</h3>
	<p>$picolog_demo_content_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-signal"></i></div>
	<h3>$picolog_improvement</h3>
	<p>$picolog_improvement_details</p>
</div>
FEATURES;

function picolog_theme_page() { 
	$title = esc_html(__('Picolog','picolog'));  
	add_theme_page( 
		esc_html(__( 'Upgrade To picolog Pro','picolog')),
		$title.'<i class="fa fa-plane theme-icon"></i>', 
		'edit_theme_options',
		'picolog_upgrade',
		'picolog_display_upgrade'
	);
}

add_action('admin_menu','picolog_theme_page');


function picolog_display_upgrade() {
  $theme_data = wp_get_theme('picolog'); 
    
    // Check for current viewing tab
    $tab = null;
    if ( isset( $_GET['tab'] ) ) {
        $tab = $_GET['tab'];
    } else {
        $tab = null;
    } 
     
    $pro_theme_url = 'https://www.webulousthemes.com/theme/picolog-pro/';
    $doc_url  = 'https://www.webulousthemes.com/picolog-free';
    $support_url = 'https://www.webulousthemes.com/free-support-request/';   
    
    $current_action_link =  admin_url( 'themes.php?page=picolog_upgrade&tab=pro_features' ); ?>
    <div class="picolog-wrapper about-wrap">
        <h1><?php printf(esc_html__('Welcome to %1$s - Version %2$s', 'picolog'), $theme_data->Name ,$theme_data->Version ); ?></h1><?php
       	printf( __('<div class="about-text"> Picolog is a beautiful, Responsive and Flexible WordPress Free theme. Can be used for Professional Photographer, Photo Blogger and Creative peeps. If you are looking to make a your sites are very attractive with your Blogger images and innovative work then this theme is made for you. There is no theme options panel, instead uses Customizer, core feature of WordPress and comes with lots of options to customize. Has 4 Footer Widget Areas.</div>', 'picolog') ); ?>
        <a href="https://www.webulousthemes.com/" target="_blank" class="wp-badge welcome-logo"></a>   
        <p class="upgrade-btn"><a class="upgrade" href="<?php echo esc_url($pro_theme_url); ?>" target="_blank"><?php printf( __( 'Buy %1s Pro - $39', 'picolog'), $theme_data->Name ); ?></a></p>

	   <h2 class="nav-tab-wrapper">
	        <a href="?page=picolog_upgrade" class="nav-tab<?php echo is_null($tab) ? ' nav-tab-active' : null; ?>"><?php echo $theme_data->Name; ?></a>     
			<a href="?page=picolog_upgrade&tab=pro_features" class="nav-tab<?php echo $tab == 'pro_features' ? ' nav-tab-active' : null; ?>"><?php esc_html_e( 'PRO Features', 'picolog' );  ?></a>
            <a href="?page=picolog_upgrade&tab=free_vs_pro" class="nav-tab<?php echo $tab == 'free_vs_pro' ? ' nav-tab-active' : null; ?>"><?php esc_html_e( 'Free VS PRO', 'picolog' ); ?></a>
	        <?php do_action( 'picolog_admin_more_tabs' ); ?>
	    </h2>      

        <?php if ( is_null( $tab ) ) { ?>
            <div class="theme_info info-tab-content">
                <div class="theme_info_column clearfix">
                	<div id="webulous-create-web">
	                	<a href="https://www.webulousthemes.com/checkout?edd_action=add_to_cart&download_id=23052" target="_blank">
							<div id="webulous-mode-wrap">
								<?php echo sprintf ('<h3>%1$s</h3><p>%2$s</p>',__('New to Creating a Website?','picolog'),__('We will build you a complete website based on the theme you selected. We will populate content, change colors and do any look and feel customisation work you prefer.','picolog') ); ?>
							</div>
							<div class="image-wrap">
								<?php echo sprintf ( '<img src="'. esc_url( get_template_directory_uri() ) .'/images/api.png" alt="%1$s" />',__('Image','picolog') ); ?>
							</div>
						</a>
					</div>
                    <div class="theme_info_left">
                        <div class="theme_link">
                            <h3><?php esc_html_e( 'Theme Customizer', 'picolog' ); ?></h3>
                            <p class="about"><?php printf(esc_html__('%s supports the Theme Customizer for all theme settings. Click "Customize" to start customize your site.', 'picolog'), $theme_data->Name); ?></p>
                            <p>
                                <a href="<?php echo admin_url('customize.php'); ?>" class="button button-primary"><?php esc_html_e('Start Customize', 'picolog'); ?></a>
                            </p>
                        </div>
                        <div class="theme_link">
                            <h3><?php esc_html_e( 'Theme Documentation', 'picolog' ); ?></h3>
                            <p class="about"><?php printf(esc_html__('Need any help to setup and configure %s? Please have a look at our documentations instructions.', 'picolog'), $theme_data->Name); ?></p>
                            <p>
                                <a href="<?php echo esc_url($doc_url); ?>" target="_blank" class="button button-secondary"><?php esc_html_e(' Documentation', 'picolog'); ?></a>
                            </p>
                            <?php do_action( 'picolog_dashboard_theme_links' ); ?>
                        </div>  
                        <div class="theme_link">
                            <h3><?php esc_html_e( 'Having Trouble, Need Support?', 'picolog' ); ?></h3>
                            <p class="about"><?php printf(esc_html__('Support for %s WordPress theme is conducted through Webulous free support ticket system.', 'picolog'), $theme_data->Name); ?></p>
                            <p>  
                                <a href="<?php echo esc_url($support_url); ?>" target="_blank" class="button button-secondary"><?php echo sprintf( esc_html('Create a support ticket', 'picolog'), $theme_data->Name); ?></a>
                            </p>
                        </div> 
                       
                    </div>  

                    <div class="theme_info_right">
                        <?php echo sprintf ( '<img src="'. esc_url( get_template_directory_uri() ) .'/screenshot.png" alt="%1$s" />',__('Theme screenshot','picolog') ); ?>
                    </div>
                </div>
            </div>
        <?php } ?>

         <?php if ( $tab == 'one_click_demo' ) { ?>
            <div class="one-click-demo-tab info-tab-content">
				<div class="wrap clearfix">
					<?php
					if( ! function_exists('is_plugin_activate') ) {
						include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
					}
					if ( picolog_is_plugin_installed('One Click Demo Import') != 1 ) {
						echo sprintf('%1$s <a href="%2$s"> %3$s</a>', __('Install required plugin to import the demo content.','picolog'), admin_url('themes.php?page=tgmpa-install-plugins&plugin_status=install'), __('Begin Installing Plugin','picolog') );
					} elseif ( is_plugin_active( 'one-click-demo-import/one-click-demo-import.php' ) ) {	
						echo sprintf('<a href="%1$s"> %2$s</a>',  admin_url('themes.php?page=pt-one-click-demo-import'), __('Click here to install the demo','picolog') );
				    } else {
				    	echo sprintf('%1$s <a href="%2$s"> %3$s</a>', __('Kindly activate the Required plugin to Import the demo content.','picolog'), admin_url('themes.php?page=tgmpa-install-plugins&plugin_status=activate'), __('Begin Activating Plugin','picolog') );
				    } ?>
				</div>
			</div><?php   
		} ?> 

        <?php if ( $tab == 'pro_features' ) { ?>
            <div class="pro-features-tab info-tab-content"><?php
			    global $picolog_why_upgrade; ?>
				<div class="wrap clearfix">
				    <?php echo $picolog_why_upgrade; ?>
				</div>
			</div><?php   
		} ?>  

       <!-- Free VS PRO tab -->
        <?php if ( $tab == 'free_vs_pro' ) { ?>
            <div class="free-vs-pro-tab info-tab-content">
	            <div id="free_pro">
	                <table class="free-pro-table">
		                <thead>
			                <tr>
			                    <th></th>
			                    <th><?php echo esc_html($theme_data->Name); ?> Lite</th>
			                    <th><?php echo esc_html($theme_data->Name); ?> PRO</th>
			                </tr>
		                </thead>
		                <tbody>
		                    <tr>
		                        <td><h3><?php _e('Flex Slider', 'picolog'); ?></h3></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                        <td><h3><?php _e('Support', 'picolog'); ?></h3></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                        <td><h3><?php _e('Responsive Design', 'picolog'); ?></h3></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                        <td><h3><?php _e('Custom Logo Option', 'picolog'); ?></h3></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                         <td><h3><?php _e('Social Links', 'picolog'); ?></h3></td>
		                         <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                         <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                    	 <td><h3><?php _e('Unlimited color option', 'picolog'); ?></h3></td>
		                    	 <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	 <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                    	 <td><h3><?php _e('Elastic Slider', 'picolog'); ?></h3></td>
		                    	 <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	 <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                     <tr>
		                    	 <td><h3><?php _e('Page Builder Support', 'picolog');?></h3></td>
		                    	 <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	 <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                     <tr>
		                    	 <td><h3><?php _e('Page Templates', 'picolog');?></h3></td>
		                    	 <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	 <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                    	<td><h3><?php _e('Google Map', 'picolog');?></h3></td>
		                    	<td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	<td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                    	<td><h3><?php _e('Demo Content', 'picolog');?></h3></td>
		                    	<td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	<td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                     <tr>
		                    	<td><h3><?php _e('Polylang Compatible', 'picolog');?></h3></td>
		                    	<td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	<td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                     <tr>
		                    	<td><h3><?php _e('Multiple Portfolio Layouts', 'picolog');?></h3></td>
		                    	<td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	<td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                     <tr>
		                    	<td><h3><?php _e('Multiple Blog Layouts', 'picolog');?></h3></td>
		                    	<td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	<td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                     <tr>
		                    	<td><h3><?php _e('Page Animation', 'picolog');?></h3></td>
		                    	<td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	<td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                     <tr>
		                    	<td><h3><?php _e('Unlimited Sidebar', 'picolog');?></h3></td>
		                    	<td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	<td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    
		                    <tr class="ti-about-page-text-center">
		                        <td></td>
		                    	<td colspan="2"><a href="<?php echo esc_url($pro_theme_url); ?>" target="_blank" class="button button-primary button-hero"><?php printf( __( 'Buy %1s Pro - $39', 'picolog'), $theme_data->Name ); ?></a></td>
		                    </tr>
		                </tbody>
	                </table>			    
				</div>
			</div><?php 
		} ?>

    </div><?php
}
   

	$options = array(
		'capability' => 'edit_theme_options',
		'type' => 'theme_mod',
		'panels' => apply_filters( 'picolog_customizer_options', array(
			'picolog' => array(
				'priority'       => 9,
				'title'          => __('Theme Options', 'picolog'),
				'description'    => __('Theme Options', 'picolog'),
				'sections' => array(
					'general' => array(
						'title' => __('General', 'picolog'),
						'description' => __('General settings that affects overall site', 'picolog'),
						'fields' => array(
							'breadcrumb_navigation' => array(
								'type' => 'checkbox',
								'label' => __('Enable Breadcrumb Navigation', 'picolog'),
								'default' => 1,
								'sanitize_callback' => 'picolog_boolean',
							),
							'breadcrumb' => array(
								'type' => 'checkbox',
								'label' => __('Enable Breadcrumb', 'picolog'),
								'default' => 1,
								'sanitize_callback' => 'picolog_boolean',
							),
							'breadcrumb_char' => array(
								'type' => 'select',
								'label' => __('Select Breadcrumb Character', 'picolog'),
								'choices' => array(
									'1' => '&raquo;',
									'2' => '&#47;',
									'3' => '&gt;'
								),
								'sanitize_callback' => 'picolog_breadcrumb_char_choices',
								'default' => '1',
							),
							 'numeric_pagination' => array(
                                'type' => 'checkbox',
                                'label' => __('Enable Numeric Page Navigation', 'picolog'),
                                'description' => __('Check to display numeric page navigation, instead of Previous Posts / Next Posts links.', 'picolog'),
                                'default' => 1, 
                                'sanitize_callback' => 'picolog_boolean', 
                            ),
                            'sidebar_position' => array(
                                'type' => 'radio',
                                'label' => __('Website Layout Options', 'picolog'),
                                'description' => __('Select main content and sidebar alignment.', 'picolog'),
                                'choices' => array(
                                    'left' => __('Sidebar Left', 'picolog'),
                                    'right' => __('Sidebar Right', 'picolog'),
                                    'fullwidth' => __('Full Width', 'picolog'),
                                    'no-sidebar' => __('No Sidebar', 'picolog'),
                                ),
                                'default' => 'right',  
                                'sanitize_callback' => 'sanitize_text_field', 
                            ),
						),
					),
					'header' => array(
						'title' => __('Header', 'picolog'),
						'description' => __('Header options', 'picolog'),
						'fields' => array(
							'logo_title' => array(
								'type' => 'checkbox',
								'label' => __('Logo as Title', 'picolog'),
								'default' => 0,
								'sanitize_callback' => 'picolog_boolean',
							),
							'site_title' => array(
								'type' => 'checkbox',
								'label' => __('Show Site Title', 'picolog'),
								'default' => 1,
								'sanitize_callback' => 'picolog_boolean',
							), 
							'tagline' => array(
								'type' => 'checkbox',
								'label' => __('Show site Tagline', 'picolog'),
								'default' => 1,
								'sanitize_callback' => 'picolog_boolean',
							),
							'page_featured' => array(
								'type' => 'checkbox',
								'label' => __('Set the Page Featured image as Header Background Image', 'picolog'),
								'default' => 0,
								'sanitize_callback' => 'picolog_boolean',
							),
							'header_bg' => array(
								'type' => 'image',
								'label' => __('Header Background Image for other Pages(except Front page)', 'picolog'),
								'default' => get_template_directory_uri() .'/images/header-image.png',
								'sanitize_callback' => 'sanitize_text_field', 
							), 
							'header_bg_size' => array (
								'type' => 'select',
								'label'    => __( 'Header Background Size', 'picolog' ),
								'choices' => array(
							        'cover'   => __('Cover', 'picolog'), 
							        'contain' => __('Contain', 'picolog'), 
							        'auto'    => __('Auto', 'picolog'), 
							        'inherit' => __('Inherit', 'picolog'), 
							    ),
							    'default' => 'cover',
							    'sanitize_callback' => 'sanitize_text_field',
							),
							'header_bg_repeat' => array (
								'type' => 'select',
								'label'    => __( 'Header Background Repeat', 'picolog' ),
								'choices' => array(
							        'no-repeat' => __( 'No Repeat','picolog'),
							        'repeat' => __( 'Repeat','picolog'),
							        'repeat-x' => __( 'Repeat Horizontally','picolog'),
							        'repeat-y' => __( 'Repeat Vertically', 'picolog'),
							    ),
							    'default' => 'repeat',
							    'sanitize_callback' => 'sanitize_text_field',
							),
							'header_bg_position' => array (
								'type' => 'select',
								'label'    => __( 'Header Background position', 'picolog' ),
								'choices' => array(
							        'center top' => __('Center Top', 'picolog'),
       								'center center' => __('Center Center', 'picolog'),
							        'center bottom' => __('Center Bottom', 'picolog'),
							        'left top' => __('Left Top', 'picolog'),
							        'left center' => __('Left Center', 'picolog'),
							        'left bottom' => __('Left Bottom', 'picolog'),
							        'right top' => __('Right Top', 'picolog'),
							        'right center' => __('Right Center', 'picolog'),
							        'right bottom' => __('Right Bottom', 'picolog'),	
							    ),
							    'default' => 'center center',
							    'sanitize_callback' => 'sanitize_text_field',
							),
							'header_bg_attachment' => array (
								'type' => 'select',
								'label'    => __( 'Header Background attachment', 'picolog' ),
								'choices' => array(
							        'scroll' => __('Scroll','picolog'),
        							'fixed' => __('Fixed','picolog'),
							    ),
							    'default' => 'fixed',
							    'sanitize_callback' => 'sanitize_text_field',
							),
                		),
					),
					'footer' => array(
						'title' => __('Footer', 'picolog'),
						'description' => __('Footer related options', 'picolog'),
						'fields' => array(
							'footer_widgets' => array(
								'type' => 'checkbox',
								'label' => __('Footer Widget Area', 'picolog'),
								'default' => 1,
								'sanitize_callback' => 'picolog_boolean',
							),
							'scroll_to_top' => array(
								'type' => 'checkbox',
								'label' => __('Enable Scroll To Top', 'picolog'),
								'default' => 0,
								'sanitize_callback' => 'picolog_boolean',
							),
							'copyright' => array(
                                'type' => 'textarea',
                                'label' => __('Footer Copyright Text (Validated that it\'s HTML Allowed)', 'picolog'),
                                'description' => __('HTML Allowed. <b>This field is even HTML validated! </b>', 'picolog'),
                                'sanitize_callback' => 'picolog_footer_copyright',
                            ),
						),
					),
					'blog' => array(
						'title' => __('Blog', 'picolog'),
						'description' => __('Blog Related Posts options', 'picolog'),
						'fields' => array(
							'featured_image' => array(  
								'type' => 'checkbox',
								'label' => __('Enable Featured Image', 'picolog'),
								'default' => 1,
								'sanitize_callback' => 'picolog_boolean',
							),
                           'featured_image_size' => array(
                                'type' => 'radio',
                                'label' => __('Choose the featured image display type for Blog Page ', 'picolog'),
                                'choices' => array(
                                    '1' => __('Large Featured Image', 'picolog'),
                                    '2' => __('Small Featured Image', 'picolog'),        
                                ),
                                'default' => '1', 
                                'sanitize_callback' => 'absint',
                            ),
						),
					),
					'single_blog' => array(
						'title' => __('Single Blog', 'picolog'),
						'description' => __('Single Blog page Related Posts options', 'picolog'),
						'fields' => array(
							'single_featured_image' => array(
								'type' => 'checkbox',
								'label' => __('Enable Single Post Featured Image', 'picolog'),
								'default' => 1,
								'sanitize_callback' => 'picolog_boolean',
							),
							'single_featured_image_size' => array(
								'type' => 'radio',
								'label' => __('Choose the featured image display type for Single Page ', 'picolog'),
								'choices' => array(
									'1' => __('Large Featured Image', 'picolog'),
									'2' => __('Small Featured Image', 'picolog'),       
								),
								'default' => '1', 
								'sanitize_callback' => 'absint',  
							),
							'social_sharing_box' => array(
								'type' => 'checkbox',
								'label' => __(' Enable Social Sharing Box below single post', 'picolog'),
								'default' => 0,
								'sanitize_callback' => 'picolog_boolean',    
							),
							'facebook_sb' => array(
								'type' => 'checkbox',
								'label' => __(' Enable Facebook Sharing option below single post', 'picolog'),
								'default' => 0,
								'sanitize_callback' => 'picolog_boolean',    
							),
							'twitter_sb' => array(
								'type' => 'checkbox',
								'label' => __(' Enable Twitter Sharing option below single post', 'picolog'),
								'default' => 0,
								'sanitize_callback' => 'picolog_boolean',    
							),
							'linkedin_sb' => array(
								'type' => 'checkbox',
								'label' => __(' Enable Linkedin Sharing option below single post', 'picolog'),
								'default' => 0,
								'sanitize_callback' => 'picolog_boolean',    
							),
							'google-plus_sb' => array(
								'type' => 'checkbox',
								'label' => __(' Enable Google Plus Sharing option below single post', 'picolog'),
								'default' => 0,
								'sanitize_callback' => 'picolog_boolean',    
							),
							'email_sb' => array(
								'type' => 'checkbox',
								'label' => __(' Enable Email Sharing option below single post', 'picolog'),
								'default' => 0,
								'sanitize_callback' => 'picolog_boolean',    
							),
							'author_bio_box' => array(
								'type' => 'checkbox',
								'label' => __(' Enable Author Bio Box below single post', 'picolog'),
								'default' => 0,
								'sanitize_callback' => 'picolog_boolean',    
							),
							'related_posts' => array(
								'type' => 'checkbox',
								'label' => __('Show Related posts', 'picolog'),
								'default' => 0, 
								'sanitize_callback' => 'picolog_boolean', 
							),
							'related_posts_hierarchy' => array(
								'type' => 'radio',
								'label' => __('Related Posts Must Be Shown As:', 'picolog'),
								'choices' => array(
									'1' => __('Related Posts By Tags', 'picolog'),
									'2' => __('Related Posts By Categories', 'picolog'),      
								),
								'default' => '1', 
								'sanitize_callback' => 'absint',    
							),
						),
					),

				)
			),
			'home-picolog' => array(
				'priority'       => 9,
				'title'          => __(' Home Options', 'picolog'),
				'description'    => __(' Select Front page display as a static front page in order to visible the following sections', 'picolog'),
				'sections' => array(
					'slider-section' => array(
						'title' => __('Section: Slider', 'picolog'),
						'fields' => array(
							'slider_field' => array(   
								'type' => 'checkbox',
								'label' => __('Enable Home Page Slider Section', 'picolog'),
								'default' => 1,
								'sanitize_callback' => 'picolog_boolean',
							),
							'slider_cat' => array(
								'type' => 'category',
								'label' => __('Slider Posts Category', 'picolog'),
								'sanitize_callback' => 'absint',
							),
							'slider_count' => array(
								'type' => 'text',
								'label' => __('No. of Sliders', 'picolog'),
								'sanitize_callback' => 'absint',
								'default' => 3, 
							),
						),
					),
				    'gallery-section' => array(
						'title' => __('Image Gallery Section', 'picolog'),
						'description' => __('Enable this option for Displaying Galleries', 'picolog'),
						'fields' => array(
							'gallery_field' => array(   
								'type' => 'checkbox',
								'label' => __('Enable Home Page Gallery Section', 'picolog'),
								'default' => 1,
								'sanitize_callback' => 'picolog_boolean',
							),
							'gallery_cat' => array(
								'type' => 'category',
								'label' => __('Gallery Posts Category', 'picolog'),
								'sanitize_callback' => 'absint',
							),
							'masonry_columns' => array(
                                'type' => 'select',
                                'label' => __('Select Masnory Layout columns', 'picolog'),
                                'choices' => array(
                                    'two' => __('2 Columns', 'picolog'),
                                    'three' => __('3 Columns', 'picolog'),
                                    'four' => __('4 Columns', 'picolog'),
                                ),
                                'default' => 'three',  
                                'sanitize_callback' => 'sanitize_text_field', 
                            ),
                            'gallery_count' => array(
								'type' => 'text',
								'label' => __('No. of Galleries to be display', 'picolog'),
								'sanitize_callback' => 'absint',
								'default' => 9,  
							), 
						),
				    ), 
				    'page-content-section' => array(
						'title' => __('Page Content', 'picolog'),
						'description' => __('Default Page content related option', 'picolog'),
						'fields' => array(
							'enable_home_default_content' => array(
                                'type' => 'checkbox',
                                'label' => __('Enable Home Page Default Content', 'picolog'),
                                'description' => __('Enable home page default content', 'picolog'),
                                'default' => 0,  
                                'sanitize_callback' => 'picolog_boolean',
                            ),
						),
				    ),
			    )
	        )
		) 
	)
	);

function picolog_boolean($value) {
	if(is_bool($value)) {
		return $value;
	} else {
		return false;
	}
}

function picolog_breadcrumb_char_choices($value='') {
	$choices = array('1','2','3');

	if( in_array($value, $choices)) {
		return $value;
	} else {
		return '1';
	}
}

if ( ! function_exists( 'picolog_footer_copyright' ) ) {

    function picolog_footer_copyright($string) {
        $allowed_tags = array(    
			'a' => array(
				'href' => array(),
				'title' => array(),
				'target' => array(),
			),
			'img' => array(
				'src' => array(),  
				'alt' => array(),
			),
			'p' => array(),
			'br' => array(),
			'em' => array(),
			'strong' => array(),
        );
        return wp_kses( $string,$allowed_tags);

    }
}

