<?php

/**
 * Title: Services
 * Slug: photofocus-blocks/services
 * Categories: photofocus-blocks, page
 */
?>

<!-- wp:group {"align":"full","className":"wp-block-section wp-block-services","layout":{"inherit":true,"type":"constrained"}} -->
<div class="wp-block-group alignfull wp-block-section wp-block-services">
	<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"14px"}},"className":"alignwide wp-block-group-heading"} -->
	<div class="wp-block-group alignwide wp-block-group-heading">
		<!-- wp:heading {"textAlign":"center","level":6,"className":"wp-block-sub-heading"} -->
		<h6 class="wp-block-heading has-text-align-center wp-block-sub-heading"><?php esc_html_e('What we do', 'photofocus-blocks'); ?></h6>
		<!-- /wp:heading -->
		<!-- wp:heading {"textAlign":"center","className":"wp-block-heading"} -->
		<h2 class="wp-block-heading has-text-align-center"><?php esc_html_e('We design & build brands', 'photofocus-blocks'); ?></h2>
		<!-- /wp:heading -->
	</div>
	<!-- /wp:group -->
	<!-- wp:group {"align":"wide","className":"wp-block-group-content"} -->
	<div class="wp-block-group alignwide wp-block-group-content">
		<!-- wp:columns {"align":"wide"} -->
		<div class="wp-block-columns alignwide">
			<!-- wp:column -->
			<div class="wp-block-column">
				<!-- wp:group {"className":"wp-block-post-group"} -->
				<div class="wp-block-group wp-block-post-group">
					<!-- wp:image {"align":"center","sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image aligncenter size-full">
						<img src="<?php echo esc_url(get_parent_theme_file_uri('/assets/images/services-1.png')); ?>" alt=""/>
					</figure>
					<!-- /wp:image -->
					<!-- wp:group {"className":"wp-block-entry-content"} -->
					<div class="wp-block-group wp-block-entry-content">
						<!-- wp:heading {"textAlign":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"700"}},"fontSize":"content-heading"} -->
						<h2 class="wp-block-heading has-text-align-center has-content-heading-font-size" style="font-style:normal;font-weight:700"><?php esc_html_e('Modern Design', 'photofocus-blocks'); ?></h2>
						<!-- /wp:heading -->
						<!-- wp:paragraph {"align":"center"} -->
						<p class="has-text-align-center"><?php esc_html_e('Picture, too, the sudden shifting of the attention, the swiftly spreading coils.', 'photofocus-blocks'); ?></p>
						<!-- /wp:paragraph -->
						<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
						<div class="wp-block-buttons">
							<!-- wp:button {"textAlign":"center","className":"is-style-only-line is-style-button"} -->
							<div class="wp-block-button is-style-only-line is-style-button">
								<a class="wp-block-button__link has-text-align-center wp-element-button"><?php esc_html_e('Continue Reading', 'photofocus-blocks'); ?></a>
							</div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->
			<!-- wp:column -->
			<div class="wp-block-column">
				<!-- wp:group {"className":"wp-block-post-group"} -->
				<div class="wp-block-group wp-block-post-group">
					<!-- wp:image {"align":"center","sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image aligncenter size-full">
						<img src="<?php echo esc_url(get_parent_theme_file_uri('/assets/images/services-2.png')); ?>" alt=""/>
					</figure>
					<!-- /wp:image -->
					<!-- wp:group {"className":"wp-block-entry-content"} -->
					<div class="wp-block-group wp-block-entry-content">
						<!-- wp:heading {"textAlign":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"700"}},"fontSize":"content-heading"} -->
						<h2 class="wp-block-heading has-text-align-center has-content-heading-font-size" style="font-style:normal;font-weight:700"><?php esc_html_e('Multi-purpose Use', 'photofocus-blocks'); ?></h2>
						<!-- /wp:heading -->
						<!-- wp:paragraph {"align":"center"} -->
						<p class="has-text-align-center"><?php esc_html_e('This is the theme for businesses &amp; companies operating in a wide range of areas.', 'photofocus-blocks'); ?></p>
						<!-- /wp:paragraph -->
						<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
						<div class="wp-block-buttons">
							<!-- wp:button {"textAlign":"center","className":"is-style-only-line is-style-button"} -->
							<div class="wp-block-button is-style-only-line is-style-button">
								<a class="wp-block-button__link has-text-align-center wp-element-button"><?php esc_html_e('Continue Reading', 'photofocus-blocks'); ?></a>
							</div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->
			<!-- wp:column -->
			<div class="wp-block-column">
				<!-- wp:group {"className":"wp-block-post-group"} -->
				<div class="wp-block-group wp-block-post-group">
					<!-- wp:image {"align":"center","sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image aligncenter size-full">
						<img src="<?php echo esc_url(get_parent_theme_file_uri('/assets/images/services-3.png')); ?>" alt=""/>
					</figure>
					<!-- /wp:image -->
					<!-- wp:group {"className":"wp-block-entry-content"} -->
					<div class="wp-block-group wp-block-entry-content">
						<!-- wp:heading {"textAlign":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"700"}},"fontSize":"content-heading"} -->
						<h2 class="wp-block-heading has-text-align-center has-content-heading-font-size" style="font-style:normal;font-weight:700"><?php esc_html_e('Responsive Design', 'photofocus-blocks'); ?></h2>
						<!-- /wp:heading -->
						<!-- wp:paragraph {"align":"center"} -->
						<p class="has-text-align-center"><?php esc_html_e('Noble is highly responsive thanks to built-in Theme Module Page Builder.', 'photofocus-blocks'); ?></p>
						<!-- /wp:paragraph -->
						<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
						<div class="wp-block-buttons">
							<!-- wp:button {"textAlign":"center","className":"is-style-only-line is-style-button"} -->
							<div class="wp-block-button is-style-only-line is-style-button">
								<a class="wp-block-button__link has-text-align-center wp-element-button"><?php esc_html_e('Continue Reading', 'photofocus-blocks'); ?></a>
							</div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->