<?php

/**
 * Title: Portfolio
 * Slug:  photofocus-blocks/portfolio
 * Categories:  photofocus-blocks, page
 */
?>

<!-- wp:group {"align":"full","className":"wp-block-section wp-block-portfolio","layout":{"inherit":true,"type":"constrained"}} -->
<div class="wp-block-group alignfull wp-block-section wp-block-portfolio">
	<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"14px"}},"className":"alignwide wp-block-group-heading"} -->
	<div class="wp-block-group alignwide wp-block-group-heading">
		<!-- wp:heading {"textAlign":"center","level":6,"className":"wp-block-sub-heading"} -->
		<h6 class="wp-block-heading has-text-align-center wp-block-sub-heading"><?php esc_html_e ( 'Portfolio', 'photofocus-blocks' ); ?></h6>
		<!-- /wp:heading -->
		<!-- wp:heading {"textAlign":"center","className":"wp-block-heading"} -->
		<h2 class="wp-block-heading has-text-align-center"><?php esc_html_e ( 'Create and make your dream', 'photofocus-blocks' ); ?></h2>
		<!-- /wp:heading -->
	</div>
	<!-- /wp:group -->
	<!-- wp:columns {"align":"wide","className":"is-style-have-gap-0"} -->
	<div class="wp-block-columns alignwide is-style-have-gap-0">
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:columns -->
			<div class="wp-block-columns">
				<!-- wp:column -->
				<div class="wp-block-column">
					<!-- wp:cover {"url":"<?php echo esc_url(get_parent_theme_file_uri( '/assets/images/portfolio-1.jpg' )); ?>","id":16130,"dimRatio":30,"overlayColor":"color-dark","isUserOverlayColor":true,"layout":{"type":"constrained"}} -->
					<div class="wp-block-cover">
						<span aria-hidden="true" class="wp-block-cover__background has-color-dark-background-color has-background-dim-30 has-background-dim"></span>
						<img class="wp-block-cover__image-background wp-image-16130" alt="" src="<?php echo esc_url(get_parent_theme_file_uri( '/assets/images/portfolio-1.jpg' )); ?>" data-object-fit="cover"/>
						<div class="wp-block-cover__inner-container">
							<!-- wp:group {"className":"wp-block-portfolio-title","layout":{"type":"constrained"}} -->
							<div class="wp-block-group wp-block-portfolio-title">
								<!-- wp:paragraph {"align":"left","placeholder":"Write title…","style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground"} -->
								<p class="has-text-align-left has-foreground-color has-text-color has-link-color">
									<a href="#"><?php esc_html_e ( 'Under My Umbrella', 'photofocus-blocks' ); ?></a>
								</p>
								<!-- /wp:paragraph -->
							</div>
							<!-- /wp:group -->
						</div>
					</div>
					<!-- /wp:cover -->
				</div>
				<!-- /wp:column -->
			</div>
			<!-- /wp:columns -->
			<!-- wp:columns -->
			<div class="wp-block-columns">
				<!-- wp:column -->
				<div class="wp-block-column">
					<!-- wp:cover {"url":"<?php echo esc_url(get_parent_theme_file_uri( '/assets/images/portfolio-2.jpg' )); ?>","id":16130,"dimRatio":30,"overlayColor":"color-dark","isUserOverlayColor":true,"layout":{"type":"constrained"}} -->
					<div class="wp-block-cover">
						<span aria-hidden="true" class="wp-block-cover__background has-color-dark-background-color has-background-dim-30 has-background-dim"></span>
						<img class="wp-block-cover__image-background wp-image-16130" alt="" src="<?php echo esc_url(get_parent_theme_file_uri( '/assets/images/portfolio-2.jpg' )); ?>" data-object-fit="cover"/>
						<div class="wp-block-cover__inner-container">
							<!-- wp:group {"className":"wp-block-portfolio-title","layout":{"type":"constrained"}} -->
							<div class="wp-block-group wp-block-portfolio-title">
								<!-- wp:paragraph {"align":"left","placeholder":"Write title…","style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground"} -->
								<p class="has-text-align-left has-foreground-color has-text-color has-link-color">
									<a href="#"><?php esc_html_e ( 'By the sea shore', 'photofocus-blocks' ); ?></a>
								</p>
								<!-- /wp:paragraph -->
							</div>
							<!-- /wp:group -->
						</div>
					</div>
					<!-- /wp:cover -->
				</div>
				<!-- /wp:column -->
			</div>
			<!-- /wp:columns -->
		</div>
		<!-- /wp:column -->
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:cover {"url":"<?php echo esc_url(get_parent_theme_file_uri( '/assets/images/portfolio-3.jpg' )); ?>","id":16129,"dimRatio":30,"overlayColor":"color-dark","isUserOverlayColor":true,"layout":{"type":"constrained"}} -->
			<div class="wp-block-cover">
				<span aria-hidden="true" class="wp-block-cover__background has-color-dark-background-color has-background-dim-30 has-background-dim"></span>
				<img class="wp-block-cover__image-background wp-image-16129" alt="" src="<?php echo esc_url(get_parent_theme_file_uri( '/assets/images/portfolio-3.jpg' )); ?>" data-object-fit="cover"/>
				<div class="wp-block-cover__inner-container">
					<!-- wp:group {"className":"wp-block-portfolio-title","layout":{"type":"constrained"}} -->
					<div class="wp-block-group wp-block-portfolio-title">
						<!-- wp:paragraph {"align":"left","placeholder":"Write title…","style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground"} -->
						<p class="has-text-align-left has-foreground-color has-text-color has-link-color">
							<a href="#"><?php esc_html_e ( 'Find the light', 'photofocus-blocks' ); ?></a>
						</p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->
				</div>
			</div>
			<!-- /wp:cover -->
		</div>
		<!-- /wp:column -->
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:columns -->
			<div class="wp-block-columns">
				<!-- wp:column -->
				<div class="wp-block-column">
					<!-- wp:cover {"url":"<?php echo esc_url(get_parent_theme_file_uri( '/assets/images/portfolio-4.jpg' )); ?>","id":16130,"dimRatio":30,"overlayColor":"color-dark","isUserOverlayColor":true,"layout":{"type":"constrained"}} -->
					<div class="wp-block-cover">
						<span aria-hidden="true" class="wp-block-cover__background has-color-dark-background-color has-background-dim-30 has-background-dim"></span>
						<img class="wp-block-cover__image-background wp-image-16130" alt="" src="<?php echo esc_url(get_parent_theme_file_uri( '/assets/images/portfolio-4.jpg' )); ?>" data-object-fit="cover"/>
						<div class="wp-block-cover__inner-container">
							<!-- wp:group {"className":"wp-block-portfolio-title","layout":{"type":"constrained"}} -->
							<div class="wp-block-group wp-block-portfolio-title">
								<!-- wp:paragraph {"align":"left","placeholder":"Write title…","style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground"} -->
								<p class="has-text-align-left has-foreground-color has-text-color has-link-color">
									<a href="#"><?php esc_html_e ( 'The rising sun', 'photofocus-blocks' ); ?></a>
								</p>
								<!-- /wp:paragraph -->
							</div>
							<!-- /wp:group -->
						</div>
					</div>
					<!-- /wp:cover -->
				</div>
				<!-- /wp:column -->
			</div>
			<!-- /wp:columns -->
			<!-- wp:columns -->
			<div class="wp-block-columns">
				<!-- wp:column -->
				<div class="wp-block-column">
					<!-- wp:cover {"url":"<?php echo esc_url(get_parent_theme_file_uri( '/assets/images/portfolio-5.jpg' )); ?>","id":16130,"dimRatio":30,"overlayColor":"color-dark","isUserOverlayColor":true,"layout":{"type":"constrained"}} -->
					<div class="wp-block-cover">
						<span aria-hidden="true" class="wp-block-cover__background has-color-dark-background-color has-background-dim-30 has-background-dim"></span>
						<img class="wp-block-cover__image-background wp-image-16130" alt="" src="<?php echo esc_url(get_parent_theme_file_uri( '/assets/images/portfolio-5.jpg' )); ?>" data-object-fit="cover"/>
						<div class="wp-block-cover__inner-container">
							<!-- wp:group {"className":"wp-block-portfolio-title","layout":{"type":"constrained"}} -->
							<div class="wp-block-group wp-block-portfolio-title">
								<!-- wp:paragraph {"align":"left","placeholder":"Write title…","style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground"} -->
								<p class="has-text-align-left has-foreground-color has-text-color has-link-color">
									<a href="#"><?php esc_html_e ( 'Our Strengths', 'photofocus-blocks' ); ?></a>
								</p>
								<!-- /wp:paragraph -->
							</div>
							<!-- /wp:group -->
						</div>
					</div>
					<!-- /wp:cover -->
				</div>
				<!-- /wp:column -->
			</div>
			<!-- /wp:columns -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->