<?php
/**
 * Photofocus Blocks  Theme Updater
 *
 * @package photofocus_blocks
 */

// Includes the files needed for the theme updater
if ( ! class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include dirname( __FILE__ ) . '/theme-updater-admin.php';
}

$theme = wp_get_theme( get_template() );

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(
	// Config settings
	array(
		'remote_api_url' => 'https://catchthemes.com', // Site where EDD is hosted
		'item_name'      => $theme->get( 'Name' ), // Name of theme
		'theme_slug'     => $theme->get( 'TextDomain' ), // Theme slug
		'version'        => $theme->get( 'Version' ), // The current version of this theme
		'author'         => $theme->get( 'Author' ), // The author of this theme
		'download_id'    => '', // Optional, used for generating a license renewal link
		'renew_url'      => 'https://catchthemes.com/my-account', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
		'item_id'        => '',
	),
	// Strings
	array(
		'theme-license'             => __( 'Photofocus Blocks  License', 'photofocus-blocks' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'photofocus-blocks' ),
		'license-key'               => __( 'License Key', 'photofocus-blocks' ),
		'license-action'            => __( 'License Action', 'photofocus-blocks' ),
		'deactivate-license'        => __( 'Deactivate License', 'photofocus-blocks' ),
		'activate-license'          => __( 'Activate License', 'photofocus-blocks' ),
		'status-unknown'            => __( 'License status is unknown.', 'photofocus-blocks' ),
		'renew'                     => __( 'Renew?', 'photofocus-blocks' ),
		'unlimited'                 => __( 'unlimited', 'photofocus-blocks' ),
		'license-key-is-active'     => __( 'License key is active.', 'photofocus-blocks' ),
		/* translators: the license expiration date */
		'expires%s'                 => __( 'Expires %s.', 'photofocus-blocks' ),
		'expires-never'             => __( 'Lifetime License.', 'photofocus-blocks' ),
		/* translators: 1. the number of sites activated 2. the total number of activations allowed. */
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'photofocus-blocks' ),
		'activation-limit'          => __( 'Your license key has reached its activation limit.', 'photofocus-blocks' ),
		/* translators: the license expiration date */
		'license-key-expired-%s'    => __( 'License key expired %s.', 'photofocus-blocks' ),
		'license-key-expired'       => __( 'License key has expired.', 'photofocus-blocks' ),
		/* translators: the license expiration date */
		'license-expired-on'        => __( 'Your license key expired on %s.', 'photofocus-blocks' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'photofocus-blocks' ),
		'license-is-inactive'       => __( 'License is inactive.', 'photofocus-blocks' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'photofocus-blocks' ),
		'license-key-invalid'       => __( 'Invalid license.', 'photofocus-blocks' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'photofocus-blocks' ),
		/* translators: the theme name */
		'item-mismatch'             => __( 'This appears to be an invalid license key for %s.', 'photofocus-blocks' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'photofocus-blocks' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'photofocus-blocks' ),
		'error-generic'             => __( 'An error occurred, please try again.', 'photofocus-blocks' ),
	)
);
