<?php
/**
 * Theme About Page
 *
 * @package Photofocus Blocks
 * @since 1.0
 */

function photofocus_blocks_admin_plugin_notice()
{

	$screen = get_current_screen();

	if (! empty($screen->base) && 'appearance_page_photofocus-blocks-theme' === $screen->base) {
		return false;
	}
?>
	<div class="notice notice-info is-dismissible photofocus-admin-notice">
		<div class="photofocus-blocks-admin-notice-wrapper">
			<h2><?php esc_html_e('Photofocus Blocks Pro', 'photofocus-blocks'); ?></h2>
			<p><?php esc_html_e('Get your hands on the WordPress Full Site Editing features. Start building your website with advanced block patterns and custom blocks! Get 35+ block patterns, 28 Templates, and 12 Template Parts that are highly customizable and fully responsive.', 'photofocus-blocks'); ?></p>

			<a target="_blank" class="button-primary button green" href="<?php echo esc_url('https://catchthemes.com/themes/photofocus-blocks-pro/'); ?>"><?php esc_html_e('Get Photofocus Blocks Pro', 'photofocus-blocks'); ?></a>

			<a class="button" href="<?php echo esc_url(admin_url('themes.php?page=photofocus-blocks-theme')); ?>"><?php esc_html_e('Theme Info', 'photofocus-blocks'); ?></a>
		</div>
	</div>
<?php
}
add_action('admin_notices', 'photofocus_blocks_admin_plugin_notice');

function photofocus_blocks_theme_page_admin_style( $hook ) {
	// Register theme stylesheet.
	$theme_version = wp_get_theme()->get( 'Version' );

	$version_string = is_string( $theme_version ) ? $theme_version : false;
	wp_enqueue_style(
		'photofocus-blocks-theme-admin-style',
		get_theme_file_uri( 'assets/css/about-admin.css' ),
		array(),
		$version_string
	);
}
add_action( 'admin_enqueue_scripts', 'photofocus_blocks_theme_page_admin_style' );

/**
 * Add theme page
 */
function photofocus_blocks_menu() {
	add_theme_page( esc_html__( 'Photofocus Blocks ', 'photofocus-blocks' ), esc_html__( 'Photofocus Blocks ', 'photofocus-blocks' ), 'edit_theme_options', 'photofocus-blocks-theme', 'photofocus_blocks_theme_page_display' );
}
add_action( 'admin_menu', 'photofocus_blocks_menu' );

/**
 * Display About page
 */
function photofocus_blocks_theme_page_display() {
	$theme = wp_get_theme();

	if ( is_child_theme() ) {
		$theme = wp_get_theme()->parent();
	}
	?>

	<div id="welcome-panel" class="welcome-panel">
		<div class="welcome-panel-content">
			<div class="welcome-panel-header">
				<h2><?php echo esc_html( $theme->Name ); ?></h2>
				<p><?php esc_html_e( 'Full Site Editing WordPress Theme', 'photofocus-blocks' ); ?></p>
			</div>
			
			<div class="welcome-panel-column-container">
				<div class="container-wrap">
					<div class="welcome-panel-column two-columns">
						<!-- <div class="welcome-panel-icon-pages"></div> -->
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e( 'Getting Started with Photofocus Blocks !', 'photofocus-blocks' ); ?></h3>
							<p><?php esc_html_e( 'Awesome! Photofocus Blocks  has been installed and activated successfully. Now, you can start building your dream website with a wide range of highly-customizable block patterns, templates, and template parts available in this astounding theme.', 'photofocus-blocks' ); ?></p>
							<a target="_blank" href="https://catchthemes.com/themes/photofocus-blocks/#theme-instructions"><?php esc_html_e( 'Theme documentation', 'photofocus-blocks' ); ?></a>
						</div>
					</div>

					<div class="welcome-panel-column two-columns">
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e( 'More Features with Photofocus Blocks Pro Theme', 'photofocus-blocks' ); ?></h3>
							<p><?php esc_html_e( 'There are 35+ block patterns, 30 Templates, and 13 Template Parts. Some of the block patterns are 404 Header, Archive Header, Featured Category, Featured Collections, Featured Content, Footer Four Columns, Header Media, Hero Content, How It Works, Latest Posts, Latest Products, On Sale Products, Our Identity, Our Strength, Post Header, Product Category, Product Reviews, Search Header, Shop Header, Sidebar Products, Stats, Testimonials, Trending Products, and many more.', 'photofocus-blocks' ); ?></p>
							<a target="_blank" class="button green button-primary button-hero green" href="https://catchthemes.com/themes/photofocus-blocks-pro/"><?php esc_html_e( 'Buy Photofocus Blocks Pro', 'photofocus-blocks' ); ?></a>
						</div>
					</div>
				</div>
				<div class="sidebar">
					<div class="welcome-panel-column important-links">
					<!-- <div class="welcome-panel-icon-pages"></div> -->
					<div class="welcome-panel-column-content">
						<h3><?php esc_html_e( 'Important Links', 'photofocus-blocks' ); ?></h3>
						<a target="_blank" href="<?php echo esc_url( $theme->get( 'ThemeURI' ) ); ?>"><?php esc_html_e( 'Theme Info', 'photofocus-blocks' ); ?></a>
						<a target="_blank" href="https://fse.catchthemes.com/photofocus-blocks"><?php esc_html_e( 'View Demo', 'photofocus-blocks' ); ?></a>
						<a  target="_blank" href="<?php echo esc_url( $theme->get( 'ThemeURI' ) . '/#theme-instructions' ); ?>"><?php esc_html_e( 'Theme Instructions', 'photofocus-blocks' ); ?></a>
						<a  target="_blank" href="<?php echo esc_url( $theme->get( 'ThemeURI' ) . '/#changelog' ); ?>"><?php esc_html_e( 'Change log', 'photofocus-blocks' ); ?></a>
						<a target="_blank" href="<?php echo esc_url( 'https://catchthemes.com/support-forum/forum/full-site-editing/' ); ?>"><?php esc_html_e( 'Support', 'photofocus-blocks' ); ?></a>
					</div>
				</div>

				<div class="welcome-panel-column review">
					<!-- <div class="welcome-panel-icon-pages"></div> -->
					<div class="welcome-panel-column-content">
						<h3><?php esc_html_e( 'Leave us a review', 'photofocus-blocks' ); ?></h3>
						<p><?php esc_html_e( 'Loved Photofocus Blocks? Feel free to leave your feedback. Your opinion helps us reach more audiences!', 'photofocus-blocks' ); ?></p>
						<a href="https://wordpress.org/support/theme/photofocus-blocks/reviews/" class="button button-primary button-hero" style="text-decoration: none;" target="_blank"><?php esc_html_e( 'Review', 'photofocus-blocks' ); ?></a>
					</div>
				</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
