//JS for header media scroll down button

let scrollDownBtn = document.querySelector('.scroll-down')

if (scrollDownBtn !== null) {
    scrollDownBtn.addEventListener('click', function () {
        let sections = document.querySelectorAll('.wp-block-section')
        let firstSection = sections[1].offsetTop;
        window.scrollTo({
            top: firstSection,
            behavior: 'smooth'
        });
    })
}


// ADD CUSTOM CSS FOR SHOWING CURRENT_MENU_ITEM CLASS

document.body.querySelectorAll('.wp-block-navigation').forEach(function (navBlock) {
    if (navBlock !== null) {
        navBlock.querySelectorAll('[href="' + window.location.href + '"]').forEach(function (navActiveLink) {
            navActiveLink.parentNode.classList.add('current-nav-item');
        });
    }
});

// Header Search Show/Hide js //

let searchContainer = document.querySelectorAll('.wp-primary-search');
searchContainer.forEach((searchForm) => {
    let body = document.body;
    if (searchForm !== null) {
        let toggleIcon = searchForm.querySelector('.wp-search-toggle-container')
        let searchInput = searchForm.querySelector('.wp-block-search__input')
        toggleIcon.addEventListener('click', function () {
            searchForm.classList.toggle('toggled-on')
            body.classList.toggle('show-search')
            searchInput.focus()
        })

        document.addEventListener('click', function (e) {
            if (!searchInput.contains(e.target) && !toggleIcon.contains(e.target) && searchForm.classList.contains('toggled-on')) {
                searchForm.classList.remove('toggled-on')
                body.classList.remove('show-search')
            }
        })
    }
})