<?php
/**
 * Personal Coach Lite functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Personal Coach Lite
 */

function personal_coach_lite_files_setup() {

    if ( ! defined( 'LMS_EDUCATION_STUDY_CONTACT_SUPPORT' ) ) {
        define('LMS_EDUCATION_STUDY_CONTACT_SUPPORT',__('https://wordpress.org/support/theme/personal-coach-lite/','personal-coach-lite'));
    }
    if ( ! defined( 'LMS_EDUCATION_STUDY_REVIEW' ) ) {
        define('LMS_EDUCATION_STUDY_REVIEW',__('https://wordpress.org/support/theme/personal-coach-lite/reviews/','personal-coach-lite'));
    }
    if ( ! defined( 'LMS_EDUCATION_STUDY_LIVE_DEMO' ) ) {
        define('LMS_EDUCATION_STUDY_LIVE_DEMO',__('https://demo.themagnifico.net/personal-coach-lite/','personal-coach-lite'));
    }
    if ( ! defined( 'LMS_EDUCATION_STUDY_GET_PREMIUM_PRO' ) ) {
        define('LMS_EDUCATION_STUDY_GET_PREMIUM_PRO',__('https://www.themagnifico.net/products/education-wordpress-theme-bundle','personal-coach-lite'));
    }
    if ( ! defined( 'LMS_EDUCATION_STUDY_PRO_DOC' ) ) {
        define('LMS_EDUCATION_STUDY_PRO_DOC',__('https://demo.themagnifico.net/eard/wathiqa/personal-coach-lite-pro-doc/','personal-coach-lite'));
    }
    if ( ! defined( 'LMS_EDUCATION_STUDY_FREE_DOC' ) ) {
        define('LMS_EDUCATION_STUDY_FREE_DOC',__('https://demo.themagnifico.net/eard/wathiqa/personal-coach-lite-free-doc/','personal-coach-lite'));
    }
    if ( ! defined( 'LMS_EDUCATION_STUDY_URL' ) ) {
        define( 'LMS_EDUCATION_STUDY_URL', esc_url( 'https://www.themagnifico.net/products/education-wordpress-theme-bundle', 'personal-coach-lite') );
    }
    if ( ! defined( 'LMS_EDUCATION_STUDY_TEXT' ) ) {
        define( 'LMS_EDUCATION_STUDY_TEXT', __( 'Personal Coach Pro','personal-coach-lite' ));
    }
    if ( ! defined( 'LMS_EDUCATION_STUDY_BUNDLE_LINK' ) ) {
        define('LMS_EDUCATION_STUDY_BUNDLE_LINK',__('https://www.themagnifico.net/products/wordpress-theme-bundle','personal-coach-lite'));
    }
}

add_action( 'after_setup_theme', 'personal_coach_lite_files_setup' );

function personal_coach_lite_enqueue_styles() {
    wp_enqueue_style( 'bootstrap-css', get_template_directory_uri() . '/assets/css/bootstrap.css');
    $personal_coach_lite_parentcss = 'lms-education-study-style';
    $personal_coach_lite_theme = wp_get_theme(); wp_enqueue_style( $personal_coach_lite_parentcss, get_template_directory_uri() . '/style.css', array(), $personal_coach_lite_theme->parent()->get('Version'));
    wp_enqueue_style( 'personal-coach-lite-style', get_stylesheet_uri(), array( $personal_coach_lite_parentcss ), $personal_coach_lite_theme->get('Version'));

    require get_theme_file_path( '/custom-option.php' );
    wp_add_inline_style( 'personal-coach-lite-style',$lms_education_study_theme_css );
    require get_parent_theme_file_path( '/custom-option.php' );
    wp_add_inline_style( 'lms-education-study-style',$lms_education_study_theme_css );

    wp_enqueue_script( 'comment-reply', '/wp-includes/js/comment-reply.min.js', array(), false, true ); 

    wp_enqueue_script('personal-coach-lite-theme-custom-js', get_stylesheet_directory_uri() . '/assets/js/theme-custom-script.js', array('jquery'), '', true ); 
}

add_action( 'wp_enqueue_scripts', 'personal_coach_lite_enqueue_styles' );

function personal_coach_lite_customize_register($wp_customize){

    //Latest Recipes
    $wp_customize->add_section('personal_coach_lite_popular_articles',array(
        'title' => esc_html__('Courses Option','personal-coach-lite'),
        'priority'   => 30,
    ));

    $wp_customize->add_setting('personal_coach_lite_services_content',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('personal_coach_lite_services_content',array(
        'label' => esc_html__('Section Short Title','personal-coach-lite'),
        'section' => 'personal_coach_lite_popular_articles',
        'setting' => 'personal_coach_lite_services_content',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('personal_coach_lite_services_heading',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('personal_coach_lite_services_heading',array(
        'label' => esc_html__('Section Heading','personal-coach-lite'),
        'section' => 'personal_coach_lite_popular_articles',
        'setting' => 'personal_coach_lite_services_heading',
        'type'  => 'text'
    ));

    $categories = get_categories();
    $cats = array();
    $i = 0;
    $cat_post[]= 'select';
    foreach($categories as $category){
        if($i==0){
            $default = $category->slug;
            $i++;
        }
        $cat_post[$category->slug] = $category->name;
    }

    $wp_customize->add_setting('personal_coach_lite_services_sec_category',array(
        'default' => 'select',
        'sanitize_callback' => 'lms_education_study_sanitize_choices',
    ));
    $wp_customize->add_control('personal_coach_lite_services_sec_category',array(
        'type'    => 'select',
        'choices' => $cat_post,
        'label' => __('Select Category to display Latest Recipes','personal-coach-lite'),
        'section' => 'personal_coach_lite_popular_articles',
    ));

    for ($i=1; $i <=6 ; $i++) {
        $wp_customize->add_setting('personal_coach_lite_courses_rating_number'.$i,array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control('personal_coach_lite_courses_rating_number'.$i,array(
            'label' => esc_html__('Courses Rating Number ','personal-coach-lite').$i,
            'section' => 'personal_coach_lite_popular_articles',
            'setting' => 'personal_coach_lite_courses_rating_number'.$i,
            'type'  => 'text'
        ));

        $wp_customize->add_setting('personal_coach_lite_course_price'.$i,array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control('personal_coach_lite_course_price'.$i,array(
            'label' => esc_html__('Courses Price ','personal-coach-lite').$i,
            'section' => 'personal_coach_lite_popular_articles',
            'setting' => 'personal_coach_lite_course_price'.$i,
            'type'  => 'text'
        ));

        $wp_customize->add_setting('personal_coach_lite_course_time'.$i,array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control('personal_coach_lite_course_time'.$i,array(
            'label' => esc_html__('Courses Time','personal-coach-lite').$i,
            'section' => 'personal_coach_lite_popular_articles',
            'setting' => 'personal_coach_lite_course_time'.$i,
            'type'  => 'text'
        ));

        $wp_customize->add_setting('personal_coach_lite_course_no_of_student'.$i,array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control('personal_coach_lite_course_no_of_student'.$i,array(
            'label' => esc_html__('Courses Date ','personal-coach-lite').$i,
            'section' => 'personal_coach_lite_popular_articles',
            'setting' => 'personal_coach_lite_course_no_of_student'.$i,
            'type'  => 'text'
        ));
        
    }

    // Pro Version
    // $wp_customize->add_setting( 'pro_version_popular_course_setting', array(
    //     'sanitize_callback' => 'lms_education_study_sanitize_custom_control'
    // ));
    // $wp_customize->add_control( new LMS_Education_Study_Customize_Pro_Version ( $wp_customize,'pro_version_popular_course_setting', array(
    //     'section'     => 'personal_coach_lite_popular_articles',
    //     'type'        => 'pro_options',
    //     'label'       => esc_html__( 'Customizer Options', 'lms-education-study' ),
    //     'description' => esc_url( LMS_EDUCATION_STUDY_URL ),
    //     'priority'    => 100
    // )));

}
add_action('customize_register', 'personal_coach_lite_customize_register');

if ( ! function_exists( 'personal_coach_lite_setup' ) ) :
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    function personal_coach_lite_setup() {

        add_theme_support( 'responsive-embeds' );

        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support( 'title-tag' );

        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support( 'post-thumbnails' );

        add_image_size('personal-coach-lite-featured-header-image', 2000, 660, true);

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         * to output valid HTML5.
         */
        add_theme_support( 'html5', array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
        ) );

        // Set up the WordPress core custom background feature.
        add_theme_support( 'custom-background', apply_filters( 'lms_education_study_custom_background_args', array(
            'default-color' => '',
            'default-image' => '',
        ) ) );

        /**
         * Add support for core custom logo.
         *
         * @link https://codex.wordpress.org/Theme_Logo
         */
        add_theme_support( 'custom-logo', array(
            'height'      => 50,
            'width'       => 50,
            'flex-width'  => true,
        ) );

        add_editor_style( array( '/editor-style.css' ) );

        add_theme_support( 'align-wide' );

        add_theme_support( 'wp-block-styles' );
        add_action('wp_ajax_personal_coach_lite_dismissable_notice', 'personal_coach_lite_dismissable_notice');
    }
endif;
add_action( 'after_setup_theme', 'personal_coach_lite_setup' );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function personal_coach_lite_widgets_init() {
        register_sidebar( array(
        'name'          => esc_html__( 'Sidebar', 'personal-coach-lite' ),
        'id'            => 'sidebar',
        'description'   => esc_html__( 'Add widgets here.', 'personal-coach-lite' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h5 class="widget-title">',
        'after_title'   => '</h5>',
    ) );
}
add_action( 'widgets_init', 'personal_coach_lite_widgets_init' );

function personal_coach_lite_remove_customize_register() {
    global $wp_customize;

    $wp_customize->remove_section( 'lms_education_study_color_option' );

    $wp_customize->remove_setting('lms_education_study_slider_short_heading');
    $wp_customize->remove_control('lms_education_study_slider_short_heading');
    
}

add_action( 'customize_register', 'personal_coach_lite_remove_customize_register', 11 );

// add_action( 'lms_education_study_navigation_action','lms_education_study_single_post_navigation',30 );
if( !function_exists('personal_coach_lite_content_offcanvas') ):

    // Offcanvas Contents
    function personal_coach_lite_content_offcanvas(){ ?>

        <div id="offcanvas-menu">
            <div class="offcanvas-wraper">
                <div class="close-offcanvas-menu">
                    <div class="offcanvas-close">
                        <a href="javascript:void(0)" class="skip-link-menu-start"></a>
                        <button type="button" class="button-offcanvas-close">
                            <span class="offcanvas-close-label">
                                <i class="fas fa-times"></i>
                            </span>
                        </button>
                    </div>
                </div>
                <div id="primary-nav-offcanvas" class="offcanvas-item offcanvas-main-navigation">
                    <nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e('Horizontal', 'personal-coach-lite'); ?>" role="navigation">
                        <ul class="primary-menu theme-menu">
                            <?php
                            if (has_nav_menu('primary')) {
                                wp_nav_menu(
                                    array(
                                        'container' => '',
                                        'items_wrap' => '%3$s',
                                        'theme_location' => 'primary',
                                        'show_toggles' => true,
                                    )
                                );
                            }else{

                                wp_list_pages(
                                    array(
                                        'match_menu_classes' => true,
                                        'show_sub_menu_icons' => true,
                                        'title_li' => false,
                                        'show_toggles' => true,
                                        'walker' => new LMS_Education_Study_Menu_Page(),
                                    )
                                );
                            }
                            ?>
                        </ul>
                    </nav><!-- .primary-menu-wrapper -->
                </div>
                <a href="javascript:void(0)" class="skip-link-menu-end"></a>
            </div>
        </div>

    <?php
    }

endif;

add_action( 'personal_coach_lite_before_footer_content_action','personal_coach_lite_content_offcanvas',30 );


function personal_coach_lite_remove_my_action() {
    remove_action( 'remove_menu_page','lms-education-study-info' );
    remove_action( 'admin_menu','lms_education_study_demo_importer_admin_page' );
    remove_action( 'admin_notices','lms_education_study_deprecated_hook_admin_notice' );
}
add_action( 'init', 'personal_coach_lite_remove_my_action');

add_action('admin_menu', 'remove_my_theme_page', 999);
function remove_my_theme_page() {
    remove_submenu_page('themes.php','lms-education-study-info');
}

/**
 * Get CSS
 */

function personal_coach_lite_getpage_css($hook) {
    wp_register_script( 'admin-notice-script', get_stylesheet_directory_uri() . '/inc/admin/js/admin-notice-script.js', array( 'jquery' ) );
    wp_localize_script('admin-notice-script','personal_coach_lite',
        array('admin_ajax'  =>  admin_url('admin-ajax.php'),'wpnonce'  =>   wp_create_nonce('personal_coach_lite_dismissed_notice_nonce')
        )
    );
    wp_enqueue_script('admin-notice-script');

    wp_localize_script( 'admin-notice-script', 'personal_coach_lite_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
    if ( 'appearance_page_personal-coach-lite-info' != $hook ) {
        return;
    }
}
add_action( 'admin_enqueue_scripts', 'personal_coach_lite_getpage_css' );

//Admin Notice For Getstart
function personal_coach_lite_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function personal_coach_lite_deprecated_hook_admin_notice() {

     // Check if the notice has been dismissed by the user
    $dismissed = get_user_meta(get_current_user_id(), 'personal_coach_lite_dismissable_notice', true);

    // Exclude the notice from being shown on the "Theme Importer" page
    $current_screen = get_current_screen();
    if ($current_screen && $current_screen->id === 'appearance_page_theme-importer') {
        return; // Don't show the notice on this page
    }

    if (!$dismissed) {  
        ?>
        <div class="updated notice notice-success is-dismissible notice-get-started-class" data-notice="get_started" style="background: #f7f9f9; padding: 20px 10px; display: flex;">
            <div class="tm-admin-image">
                <img style="width: 100%;max-width: 320px;line-height: 40px;display: inline-block;vertical-align: top;border: 2px solid #ddd;border-radius: 4px;" src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" />
            </div>
            <div class="tm-admin-content" style="padding-left: 30px; align-self: center">
                <h2 style="font-weight: 600;line-height: 1.3; margin: 0px;"><?php esc_html_e('Thank You For Choosing ', 'personal-coach-lite'); ?><?php echo wp_get_theme(); ?><h2>
                <p style="color: #3c434a; font-weight: 400; margin-bottom: 30px;"><?php _e('Get Started With Theme By Clicking On Getting Started.', 'personal-coach-lite'); ?><p>
                <a class="admin-notice-btn button button-primary button-hero" href="<?php echo esc_url( admin_url( 'themes.php?page=personal-coach-lite-info.php' )); ?>"><?php esc_html_e( 'Get started', 'personal-coach-lite' ) ?></a>
                <a class="admin-notice-btn button button-primary button-hero notice-pro-btn" target="_blank" href="<?php echo esc_url( LMS_EDUCATION_STUDY_GET_PREMIUM_PRO ); ?>"><?php esc_html_e( 'Get Premium ', 'personal-coach-lite' ) ?></a>
                <a class="admin-notice-btn button button-primary button-hero notice-bundle-btn" target="_blank" href="<?php echo esc_url( LMS_EDUCATION_STUDY_BUNDLE_LINK ); ?>"><?php esc_html_e( 'Buy All Themes - 120+ Templates', 'personal-coach-lite' ) ?></a>
                <span style="padding-top: 15px; display: inline-block; padding-left: 8px;">
                <span class="dashicons dashicons-admin-links"></span>
                <a class="admin-notice-btn"  target="_blank" href="<?php echo esc_url( LMS_EDUCATION_STUDY_LIVE_DEMO ); ?>"><?php esc_html_e( 'View Demo', 'personal-coach-lite' ) ?></a>
                </span>
            </div>
        </div>
    <?php }
}

add_action( 'admin_notices', 'personal_coach_lite_deprecated_hook_admin_notice' );

function personal_coach_lite_switch_theme() {
    delete_user_meta(get_current_user_id(), 'personal_coach_lite_dismissable_notice');
}
add_action('after_switch_theme', 'personal_coach_lite_switch_theme');
function personal_coach_lite_dismissable_notice() {
    update_user_meta(get_current_user_id(), 'personal_coach_lite_dismissable_notice', true);
    die();
}

// Demo Content Code

// Ensure WordPress is loaded
if (!defined('ABSPATH')) {
    exit;
}

// Add the AJAX action to trigger theme mods import
add_action('wp_ajax_import_theme_mods', 'personal_coach_lite_demo_importer_ajax_handler');

// Handle the AJAX request
function personal_coach_lite_demo_importer_ajax_handler() {
    // Sample data to import
    $theme_mods_data = array(
        'header_textcolor' => '000000',  // Example: change header text color
        'background_color' => 'ffffff',  // Example: change background color
        'custom_logo'      => 123,       // Example: set a custom logo by attachment ID
        'footer_text'      => 'Custom Footer Text', // Example: custom footer text
    );

    // Call the function to import theme mods
    if (personal_coach_lite_demo_theme_importer($theme_mods_data)) {
        // After importing theme mods, create the menu
        personal_coach_lite_create_demo_menu();
        wp_send_json_success(array(
            'msg' => 'Theme mods imported successfully.',
            'redirect' => home_url()
        ));
    } else {
        wp_send_json_error('Failed to import theme mods.');
    }

    wp_die();
}

// Function to set theme mods
function personal_coach_lite_demo_theme_importer($import_data) {
    if (is_array($import_data)) {
        foreach ($import_data as $mod_name => $mod_value) {
            set_theme_mod($mod_name, $mod_value);
        }
        return true;
    } else {
        return false;
    }
}

// Function to create demo menu
function personal_coach_lite_create_demo_menu() {

    $menu_structure = [

        [
            'title' => 'Home',
            'slug'  => 'home',
            'template' => 'page-template/home-template.php',
        ],
        [
            'title' => 'About Us',
            'slug'  => 'about',
            'content' => "<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using 'Content here, content here', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for 'lorem ipsum' will uncover many web sites still in their infancy. There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don't look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn't anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.</p>
            "
        ],
        [
            'title' => 'Classes',
            'slug'  => 'classes',
            'content' => "
                <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using 'Content here, content here', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for 'lorem ipsum' will uncover many web sites still in their infancy. There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don't look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn't anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.</p>
            "
        ],
        [
            'title' => 'Page',
            'slug'  => 'page',
            'content' => "<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using 'Content here, content here', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for 'lorem ipsum' will uncover many web sites still in their infancy. There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don't look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn't anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.</p>
            "
        ],
        [
            'title' => 'Blog',
            'slug'  => 'blog',
        ],
        [
            'title' => 'Contact Us',
            'slug'  => 'contact',
            'content' => "<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using 'Content here, content here', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for 'lorem ipsum' will uncover many web sites still in their infancy. There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don't look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn't anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.</p>
            "
        ],
    ];

    // ----------------------------------------------------
    // Do not modify below this line unless needed
    // ----------------------------------------------------

    $created_pages = [];

    $menu_name = 'Primary Menu';
    $location  = 'primary';
    $menu = wp_get_nav_menu_object($menu_name);

    $menu_id = (!$menu) ? wp_create_nav_menu($menu_name) : $menu->term_id;

    $create_page_and_menu = function($item, $parent_menu_id = 0, $parent_page_id = 0) 
        use (&$create_page_and_menu, &$created_pages, $menu_id) {

        $page = get_page_by_title($item['title']);

        if (!$page) {
            $page_id = wp_insert_post([
                'post_title'   => $item['title'],
                'post_type'    => 'page',
                'post_status'  => 'publish',
                'post_name'    => $item['slug'],
                'post_parent'  => $parent_page_id,
                'post_content' => !empty($item['content']) ? $item['content'] : '',
            ]);

            if (!empty($item['template'])) {
                update_post_meta($page_id, '_wp_page_template', $item['template']);
            }

        } else {
            $page_id = $page->ID;
        }

        $created_pages[$item['title']] = $page_id;

        $menu_item_id = wp_update_nav_menu_item($menu_id, 0, [
            'menu-item-title'     => $item['title'],
            'menu-item-object'    => 'page',
            'menu-item-object-id' => $page_id,
            'menu-item-type'      => 'post_type',
            'menu-item-parent-id' => $parent_menu_id,
            'menu-item-status'    => 'publish'
        ]);

        if (!empty($item['children'])) {
            foreach ($item['children'] as $child) {
                $create_page_and_menu($child, $menu_item_id, $page_id);
            }
        }
    };

    foreach ($menu_structure as $item) {
        $create_page_and_menu($item);
    }

    if (!empty($created_pages['Home'])) {
        update_option('page_on_front', $created_pages['Home']);
        update_option('show_on_front', 'page');
    }

    if (!empty($created_pages['Blog'])) {
        update_option('page_for_posts', $created_pages['Blog']);
    }

    $locations = get_theme_mod('nav_menu_locations');
    $locations[$location] = $menu_id;
    set_theme_mod('nav_menu_locations', $locations);
    //Header
    set_theme_mod( 'lms_education_study_email', 'info@example.com' );
    set_theme_mod( 'lms_education_study_topbar_timming', 'Mon - Sat: 8:00 am - 7:00 pm' );
    set_theme_mod( 'lms_education_study_header_button', 'Free Quote' );
    set_theme_mod( 'lms_education_study_header_button_url', '#' );

    set_theme_mod( 'lms_education_study_facebook_url', '#' );
    set_theme_mod( 'lms_education_study_facebook_icon', 'fab fa-facebook-f' );
    
    set_theme_mod( 'lms_education_study_twitter_url', '#' );
    set_theme_mod( 'lms_education_study_twitter_icon', 'fab fa-twitter' );

    set_theme_mod( 'lms_education_study_intagram_url', '#' );
    set_theme_mod( 'lms_education_study_intagram_icon', 'fab fa-instagram' );

    set_theme_mod( 'lms_education_study_linkedin_url', '#' );
    set_theme_mod( 'lms_education_study_linkedin_icon', 'fab fa-linkedin-in' );

    set_theme_mod( 'lms_education_study_pintrest_url', '#' );
    set_theme_mod( 'lms_education_study_pintrest_icon', 'fab fa-pinterest-p' );

    set_theme_mod( 'lms_education_study_top_header_text', 'We will start new batch from next month' );

    //Slider
    set_theme_mod( 'lms_education_study_slider_short_heading', '100% Satisfaction Guaranteed' );

    set_theme_mod( 'lms_education_study_acitve_student_number', '5500+' );
    set_theme_mod( 'lms_education_study_active_student_text', 'Online Classes' );

    set_theme_mod( 'lms_education_study_online_courses_number', '3500+' );
    set_theme_mod( 'lms_education_study_online_courses_text', 'Active Student' );

    set_theme_mod( 'lms_education_study_slider_team_image_1', get_stylesheet_directory_uri().'/assets/img/team-1.png' );
    set_theme_mod( 'lms_education_study_slider_team_image_2', get_stylesheet_directory_uri().'/assets/img/team-2.png' );
    set_theme_mod( 'lms_education_study_slider_team_image_3', get_stylesheet_directory_uri().'/assets/img/team-3.png' );
    set_theme_mod( 'lms_education_study_slider_team_image_4', get_stylesheet_directory_uri().'/assets/img/team-4.png' );
    set_theme_mod( 'lms_education_study_right_image_box_3_text', '21M+ Happy Clients' );

    for($i=1;$i<=3;$i++){
         $title = 'The Worlds Best Online Education Institute';
         $content = 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.';
            // Create post object
         $my_post = array(
         'post_title'    => wp_strip_all_tags( $title ),
         'post_content'  => $content,
         'post_status'   => 'publish',
         'post_type'     => 'page',
         );

         // Insert the post into the database
         $post_id = wp_insert_post( $my_post );

         if ($post_id) {
            // Set the theme mod for the slider page
            set_theme_mod('lms_education_study_top_slider_page' . $i, $post_id);

            $image_url = get_stylesheet_directory_uri().'/assets/img/slider.png';

            $image_id = media_sideload_image($image_url, $post_id, null, 'id');

                if (!is_wp_error($image_id)) {
                    // Set the downloaded image as the post's featured image
                    set_post_thumbnail($post_id, $image_id);
                }
        }
    }

    //About Us
    set_theme_mod( 'lms_education_study_about_us_image', get_stylesheet_directory_uri().'/assets/img/about-1.png' );
    set_theme_mod( 'lms_education_study_about_us_small_image', get_stylesheet_directory_uri().'/assets/img/about-2.png' );
    set_theme_mod( 'lms_education_study_about_us_title', 'About Our Company' );
    set_theme_mod( 'lms_education_study_about_us_heading', 'Take advantage of the world\'s best e-learning system' );
    set_theme_mod( 'lms_education_study_about_us_content_1', 'Choose from over 210,000 online video courses with new additions Published' );
    set_theme_mod( 'lms_education_study_about_us_content_2', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.' );

    set_theme_mod( 'lms_education_study_about_us__service_image_1', get_stylesheet_directory_uri().'/assets/img/aboutsmall-1.png' );
    set_theme_mod( 'lms_education_study_about_us_service_heading_1', 'Track your daily activity.' );
    set_theme_mod( 'lms_education_study_about_us_service_content_1', 'with unlimited courses' );

    set_theme_mod( 'lms_education_study_about_us__service_image_2', get_stylesheet_directory_uri().'/assets/img/aboutsmall-2.png' );
    set_theme_mod( 'lms_education_study_about_us_service_heading_2', 'Virtual support team' );
    set_theme_mod( 'lms_education_study_about_us_service_content_2', 'value all over the world' );

    set_theme_mod( 'lms_education_study_about_us_box_number', '+240' );
    set_theme_mod( 'lms_education_study_about_us_box_title', 'Awesome Awards' );


    set_theme_mod( 'lms_education_study_about_us_button_text', 'Find Out More' );
    set_theme_mod( 'lms_education_study_about_us_button_url', '#' );


    //Event
    set_theme_mod( 'personal_coach_lite_services_content', '100% Free' );
    set_theme_mod( 'personal_coach_lite_services_heading', 'Our Best Events' );



    set_theme_mod( 'personal_coach_lite_services_sec_category', 'event' );
    
    $post_heading = array('Cycling Marathon for Your Healthy Lifestyle.','USBF Baltimore Natural Pro-Am Health Coaching Contest','Vancouver Healthy Culinary Show Pro-Am Health Coaching');
    for($i=1;$i<=3;$i++){


         $title = $post_heading[$i-1];
         $content = 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.';
            // Create post object
         $my_post = array(
         'post_title'    => wp_strip_all_tags( $title ),
         'post_content'  => $content,
         'post_status'   => 'publish',
         'post_type'     => 'post',
         );

         // Insert the post into the database
         $post_id = wp_insert_post( $my_post );

         wp_set_object_terms( $post_id, 'Event', 'category' );

         if ($post_id) {

            $image_url_course = get_stylesheet_directory_uri().'/assets/img/course'.$i.'.png';

            $image_id = media_sideload_image($image_url_course, $post_id, null, 'id');

                if (!is_wp_error($image_id)) {
                    // Set the downloaded image as the post's featured image
                    set_post_thumbnail($post_id, $image_id);
                }
        }
    }
    for ($i=1; $i <=6 ; $i++) { 
        set_theme_mod( 'personal_coach_lite_courses_rating_number'.$i, '4.5' );
        set_theme_mod( 'personal_coach_lite_course_price'.$i, '$36' );
        set_theme_mod( 'personal_coach_lite_course_time'.$i, '04 PM' );
        set_theme_mod( 'personal_coach_lite_course_no_of_student'.$i, '30/11/24' );
    }

}
// Enqueue necessary scripts
add_action('admin_enqueue_scripts', 'personal_coach_lite_demo_importer_enqueue_scripts');

function personal_coach_lite_demo_importer_enqueue_scripts() {
    wp_enqueue_script(
        'demo-theme-importer',
        get_template_directory_uri() . '/assets/js/theme-importer.js', // Path to your JS file
        array('jquery'),
        null,
        true
    );

    wp_enqueue_style('demo-importer-style', get_template_directory_uri() . '/assets/css/importer.css', array(), '');

    // Localize script to pass AJAX URL to JS
    wp_localize_script(
        'demo-theme-importer',
        'demoImporter',
        array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce'    => wp_create_nonce('theme_importer_nonce')
        )
    );
}

add_action( 'customize_register', 'personal_coach_lite_override_child_theme_global_color_defaults', 20 );
function personal_coach_lite_override_child_theme_global_color_defaults( $wp_customize ) {

    if ( $wp_customize->get_setting( 'lms_education_study_first_color' ) ) {
        $wp_customize->get_setting( 'lms_education_study_first_color' )->default = '#F3C395';
    }

    if ( $wp_customize->get_setting( 'lms_education_study_second_color' ) ) {
        $wp_customize->get_setting( 'lms_education_study_second_color' )->default = '#055346';
    }
}