<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-Strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
<head profile="http://gmpg.org/xfn/11">
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<title>
<?php
	if (function_exists('is_tag') && is_tag()) {
		single_tag_title("Tag Archive for &quot;"); echo '&quot; - '; }
	elseif (is_archive()) {
		wp_title(''); echo ' Archives - '; }
	elseif (is_search()) {
		echo ''.ucwords(esc_html($s)).' | '; }
	elseif (!(is_404()) && (is_single()) || (is_page())) {
		wp_title(''); echo ' - '; }
	elseif (is_404()) {
		echo 'Not Found - '; }
	if (is_home()) {
		bloginfo('name'); echo ' - '; bloginfo('description'); }
	else {
		bloginfo('name'); }
	if ( $paged >= 2 )
		echo ' &raquo; ' . sprintf( __( 'Page %s' ), max( $paged ) );
?>

</title>
<link rel="stylesheet" href="<?php bloginfo( 'stylesheet_url' ); ?>" type="text/css" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<?php
if ( is_singular() && get_option( 'thread_comments' ) )
wp_enqueue_script( 'comment-reply' );
wp_head();
?>
</head>
<body <?php body_class(); ?>>
<div id="page-wrap">
  <div class="inner-wrap">
  <div id="header">
    <?php if(is_single()) { ?>
    <h2><a href="<?php echo home_url(); ?>/">
      <?php bloginfo('name'); ?>
      </a></h2>
    <?php } else { ?>
    <h1><a href="<?php echo home_url(); ?>/">
      <?php bloginfo('name'); ?>
      </a></h1>
    <?php } ?>
    <div class="description">
      <?php bloginfo('description'); ?>
    </div>
  </div>
  <div class="pages">
   <?php wp_nav_menu('theme_location=primary'); ?>
  </div>

  <div class="clear"></div>
  <div id="breadcrumbs">
    <?php the_breadcrumb(); ?>
  </div>
