<?php if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" id="custom-header" rel="home">
		<img src="<?php echo esc_url(get_header_image()); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="<?php echo esc_attr(get_bloginfo( 'title' )); ?>">
	</a>	
<?php endif;  ?>
<header class="main-header header-two">
	<div id="above-header" class="above-header d-none d-lg-block">
		<div class="header-widget d-flex align-items-center">
			<div class="container">
				<div class="row align-items-center">
					<div class="col-4">
						<div class="widget-left text-lg-left">
							<?php do_action('abv_hdr_widget'); ?>
						</div>
					</div>
					<div class="col-4">
						<div class="widget-center text-lg-center text-center justify-content-lg-center">
							<?php do_action('pet_bazaar_hdr_text'); ?>
						</div>
					</div>
					<div class="col-4">
						<div class="widget-right justify-content-lg-end text-lg-right">
							<?php do_action('pet_bazaar_hdr_social'); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<div class="navgation-wrapper">
		<div class="navigation-middle">
			<div class="main-navigation">
				<div class="container">
					<div class="row navigation-middle-row d-flex justify-content-between">
						<div class="col-lg-3">
							<div class="logo">
								<?php do_action('pet_bazaar_logo'); ?>
							</div>
						</div>
						<div class="col-lg-6 offset-lg-3 col-12 d-flex align-items-lg-center justify-content-end">
							<?php 
								$hs_product_search	= get_theme_mod( 'hs_product_search','1');
								if($hs_product_search=='1'){
								do_action('pet_bazaar_hdr_product_search');
							} ?>
						</div>						
					</div>
				</div>
			</div>
		</div>
	</div>
	
	<!-- main-navigation-area -->
	<div class="main-navigation-area <?php echo esc_attr(pet_bazaar_sticky_menu()); ?> d-none d-lg-block">
		<div class="container">
			<div class="navigation-mega">
				<div class="row">
					<div class="col-lg-3 col-12 my-auto">
						<?php 
							$browse_cat_ttl		= get_theme_mod( 'browse_cat_ttl','Browse Categories');
							$hs_browse_cat		= get_theme_mod( 'hs_browse_cat','1');
					
							if(class_exists( 'woocommerce' ) && $hs_browse_cat == '1'): 
							?>
								<div class="product-category-browse d-none d-lg-block active">
									<button type="button" class="product-category-btn">
										<span><?php echo wp_kses_post($browse_cat_ttl); ?></span>
									</button>
								</div>
						<?php endif; ?>
					</div>
					<div class="col-lg-6 col-xl-7 col-12 my-auto">
						<nav class="navbar-area">
							<div class="main-navbar">
								<?php do_action('pet_bazaar_main_nav'); ?>
							</div>
						</nav>
					</div>
					<div class="col-lg-3 col-xl-2 col-12 my-auto d-flex justify-content-end">
						<div class="main-menu-right d-flex justify-content-end">
							<ul class="menu-right-list">
								<?php 
								do_action('pet_bazaar_hdr_cart'); 
								do_action('pet_bazaar_hdr_account'); 
								?> 									
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="container is-sticky-on is-sticky-menu">
		<?php do_action( 'pet_bazaar_hdr_browse_cat' ); ?>
	</div>
	
	<!-- Mobile Docker -->
   <div class="main-mobile-nav">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="main-mobile-menu <?php echo esc_attr(pet_bazaar_sticky_menu()); ?>">
					<div class="main-menu-right main-mobile-left">
						<div class="logo">
							<?php do_action('pet_bazaar_logo'); ?>
						</div>
					</div>
					<div class="menu-collapse-wrap">
						<div class="hamburger-menu">
							<button type="button" class="menu-collapsed" aria-label="<?php echo esc_attr__('Menu Collaped','pet-bazaar'); ?>">
								<div class="top-bun"></div>
								<div class="meat"></div>
								<div class="bottom-bun"></div>
							</button>
						</div>
					</div>

					<div class="header-above-wrapper">
						<div class="header-above-index">
							<div class="header-above-btn">
								<button type="button" class="header-above-collapse"
								aria-label="<?php echo esc_attr__('Header Above Collapse','pet-bazaar'); ?>"><span></span></button>
							</div>
							<div id="header-above-bar" class="header-above-bar">
								<div class="header-widget">
								<?php do_action('pet_bazaar_hdr_text'); ?>
								<?php do_action('pet_bazaar_hdr_social');	?>
								<?php do_action('abv_hdr_widget'); ?>
								</div>
							</div>
						</div>
					</div>

					<div class="main-mobile-wrapper">
						<div id="mobile-menu-build" class="main-mobile-build">
							<button type="button" class="header-close-menu close-style"
								aria-label="<?php echo esc_attr__('Header Close Menu','pet-bazaar'); ?>"></button>
							<div class="switcher-tab">
								<button class="active-bg"><?php echo esc_html__('Menu','pet-bazaar'); ?></button>
								<button class="cat-menu-bt"><?php echo esc_html__('Categories','pet-bazaar'); ?></button>
							</div>                                           
							<?php do_action('pet_bazaar_main_nav'); ?>
							<?php do_action('pet_bazaar_hdr_mobile_browse_cat')?>
						</div> 
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
</header>