<?php
function paw_bazaar_upsale_setting( $wp_customize ) {
	
	$wp_customize->add_section(
        'pet_bazaar_upsale',
        array(
            'title' 		=> __('More Features in Paw Bazaar Pro','paw-bazaar'),
			'priority'      => 1,
		)
    );
	
	/*=========================================
	 Buttons
	=========================================*/
	
	class Paw_Bazaar_Button_Customize_Control extends WP_Customize_Control {
	public $type = 'pet_bazaar_upsale';

	   function render_content() {
		?>
			<div class="upsale_info">
				<ul>
					<li><a href="https://preview.sellerthemes.com/pro/pawbazaar/" class="btn-secondary" target="_blank"><i class="dashicons dashicons-desktop"></i><?php _e( 'Pro Demo','paw-bazaar' ); ?> </a></li>
					
					<li><a href="https://sellerthemes.com/paw-bazaar-premium/" class="btn-primary" target="_blank"><i class="dashicons dashicons-cart"></i><?php _e( 'Purchase Now','paw-bazaar' ); ?> </a></li>
					
					<li><a href="https://sellerthemes.ticksy.com/" class="btn-secondary" target="_blank"><i class="dashicons dashicons-sos"></i><?php _e( 'Ask for Support','paw-bazaar' ); ?> </a></li>
					
					<li><a href="https://wordpress.org/support/theme/paw-bazaar/reviews/#new-post" class="btn-green" target="_blank"><i class="dashicons dashicons-heart"></i><?php _e( 'Give us Rating','paw-bazaar' ); ?> </a></li>
				</ul>
			</div>
		<?php
	   }
	}
	
	$wp_customize->add_setting(
		'pet_bazaar_upsale_btns',
		array(
		   'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'pet_bazaar_sanitize_text',
		)	
	);
	
	$wp_customize->add_control( new Paw_Bazaar_Button_Customize_Control( $wp_customize, 'pet_bazaar_upsale_btns', array(
		'section' => 'pet_bazaar_upsale',
    ))
);
}
add_action( 'customize_register', 'paw_bazaar_upsale_setting',99 );