<?php
/**
 * Define Theme Version
 */
define( 'PAW_BAZAAR_THEME_VERSION', '8.3' );

function paw_bazaar_css() {
	$parent_style = 'pet-bazaar-parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'paw-bazaar-style', get_stylesheet_uri(), array( $parent_style ));
	wp_enqueue_style( 'paw-bazaar-default', get_stylesheet_directory_uri().'/assets/css/default.css');
	
	wp_enqueue_script('paw-bazaar-custom',get_stylesheet_directory_uri().'/assets/js/custom.js',array('jquery'),false,true);	
}
add_action( 'wp_enqueue_scripts', 'paw_bazaar_css',999);

require get_stylesheet_directory() . '/inc/customizer/customizer-options/paw-bazaar-pro.php';

/**
 * Import Settings From Parent Theme
 *
 */
function paw_bazaar_parent_theme_options() {
	$pet_bazaar_mods = get_option( 'theme_mods_pet-bazaar' );
	if ( ! empty( $pet_bazaar_mods ) ) {
		foreach ( $pet_bazaar_mods as $pet_bazaar_mod_k => $pet_bazaar_mod_v ) {
			set_theme_mod( $pet_bazaar_mod_k, $pet_bazaar_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'paw_bazaar_parent_theme_options' );

/****
 * Let WordPress Manage 
*/
add_theme_support( 'post-thumbnails' );
add_theme_support( 'title-tag' );
add_theme_support( 'automatic-feed-links' );
add_theme_support( 'custom-background' );
add_theme_support( 'custom-logo' );
add_theme_support( 'align-wide' );
add_theme_support( 'add_editor_style()' );
add_theme_support( 'html5', array('search-form','comment-form','comment-list','gallery','caption'));

/* Custom Header */
function paw_bazaar_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'pet_bazaar_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => '000000',
		'width'                  => 2000,
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'pet_bazaar_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'paw_bazaar_custom_header_setup' );

/* Remove Settings */
function paw_bazaar_customize_remove( $wp_customize ) {
	$wp_customize->remove_control('hdr_cnt');
	$wp_customize->remove_control('hide_show_hdr_contact');
	$wp_customize->remove_control('hdr_contact_ttl');
	$wp_customize->remove_control('hdr_contact_subttl');
	$wp_customize->remove_control('hdr_button');
	$wp_customize->remove_control('hide_show_hdr_btn');
	$wp_customize->remove_control('header_button_label');
	$wp_customize->remove_control('header_button_link');
}
add_action( 'customize_register', 'paw_bazaar_customize_remove',11 );