<?php
/**
 * Title: Featured Section 10
 * Slug: patterns-business/featured-section-10
 * Categories: featured
 * Description: A collection of various WordPress inbuilt blocks, such as headings, paragraphs, image, groups, and buttons, arranged in different positions to form a complete page layout.
 *
 * @package    Patterns_Business
 * @subpackage Patterns_Business/patterns
 * @since      1.0.0
 */

?>
<!-- wp:columns {"align":"full","style":{"spacing":{"blockGap":"0px"}}} -->
<div class="wp-block-columns alignfull"><!-- wp:column {"style":{"spacing":{"blockGap":"0px"}}} -->
<div class="wp-block-column"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/img/img-6.jpg","dimRatio":90,"overlayColor":"primary","isDark":false,"layout":{"type":"constrained"}} -->
<div class="wp-block-cover is-light"><span aria-hidden="true" class="wp-block-cover__background has-primary-background-color has-background-dim-90 has-background-dim"></span><img class="wp-block-cover__image-background"  src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/img/img-6.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"spacing":{"padding":{"right":"var:preset|spacing|60","left":"var:preset|spacing|60"},"blockGap":"0px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)"><!-- wp:heading {"level":4,"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"textColor":"default"} -->
<h4 class="wp-block-heading has-default-color has-text-color" style="font-style:normal;font-weight:600"><?php esc_html_e( 'London', 'patterns-business' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:group {"layout":{"type":"flex","orientation":"vertical","verticalAlignment":"center","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:separator {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}},"layout":{"selfStretch":"fixed","flexSize":"2px"}},"backgroundColor":"default","className":"is-style-default"} -->
<hr class="wp-block-separator has-text-color has-default-color has-alpha-channel-opacity has-default-background-color has-background is-style-default" style="margin-bottom:var(--wp--preset--spacing--40)"/>
<!-- /wp:separator --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}},"textColor":"default"} -->
<p class="has-default-color has-text-color" style="margin-bottom:var(--wp--preset--spacing--40)"><?php esc_html_e( '4 apt. Flawing Street. The Grand Avenue. Liverpool, UK 33342', 'patterns-business' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"5px"}}},"textColor":"default"} -->
<p class="has-default-color has-text-color" style="margin-bottom:5px"><?php esc_html_e( 'Tel : +44-20-2355-3456', 'patterns-business' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"textColor":"default"} -->
<p class="has-default-color has-text-color"><?php esc_html_e( 'Email : demo@example.com', 'patterns-business' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"blockGap":"0px"}}} -->
<div class="wp-block-column"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/img/img-3.jpg","dimRatio":90,"customOverlayColor":"#626edd","layout":{"type":"constrained"}} -->
<div class="wp-block-cover"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-90 has-background-dim" style="background-color:#626edd"></span><img class="wp-block-cover__image-background"  src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/img/img-3.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"spacing":{"padding":{"right":"var:preset|spacing|60","left":"var:preset|spacing|60"},"blockGap":"0px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)"><!-- wp:heading {"level":4,"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"textColor":"default"} -->
<h4 class="wp-block-heading has-default-color has-text-color" style="font-style:normal;font-weight:600"><?php esc_html_e( 'San Fransisco', 'patterns-business' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:group {"layout":{"type":"flex","orientation":"vertical","verticalAlignment":"center","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:separator {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}},"layout":{"selfStretch":"fixed","flexSize":"2px"}},"backgroundColor":"default","className":"is-style-default"} -->
<hr class="wp-block-separator has-text-color has-default-color has-alpha-channel-opacity has-default-background-color has-background is-style-default" style="margin-bottom:var(--wp--preset--spacing--40)"/>
<!-- /wp:separator --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}},"textColor":"default"} -->
<p class="has-default-color has-text-color" style="margin-bottom:var(--wp--preset--spacing--40)"><?php esc_html_e( '4 apt. Flawing Street. The Grand Avenue. Liverpool, UK 33342', 'patterns-business' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"5px"}}},"textColor":"default"} -->
<p class="has-default-color has-text-color" style="margin-bottom:5px"><?php esc_html_e( 'Tel : +44-20-2355-3456', 'patterns-business' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"textColor":"default"} -->
<p class="has-default-color has-text-color"><?php esc_html_e( 'Email : demo@example.com', 'patterns-business' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"blockGap":"0px"}}} -->
<div class="wp-block-column"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/img/img-7.jpg","dimRatio":90,"customOverlayColor":"#4853b3","layout":{"type":"constrained"}} -->
<div class="wp-block-cover"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-90 has-background-dim" style="background-color:#4853b3"></span><img class="wp-block-cover__image-background"  src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/img/img-7.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"spacing":{"padding":{"right":"var:preset|spacing|60","left":"var:preset|spacing|60"},"blockGap":"0px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)"><!-- wp:heading {"level":4,"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"textColor":"default"} -->
<h4 class="wp-block-heading has-default-color has-text-color" style="font-style:normal;font-weight:600"><?php esc_html_e( 'Australia', 'patterns-business' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:group {"layout":{"type":"flex","orientation":"vertical","verticalAlignment":"center","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:separator {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}},"layout":{"selfStretch":"fixed","flexSize":"2px"}},"backgroundColor":"default","className":"is-style-default"} -->
<hr class="wp-block-separator has-text-color has-default-color has-alpha-channel-opacity has-default-background-color has-background is-style-default" style="margin-bottom:var(--wp--preset--spacing--40)"/>
<!-- /wp:separator --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}},"textColor":"default"} -->
<p class="has-default-color has-text-color" style="margin-bottom:var(--wp--preset--spacing--40)"><?php esc_html_e( '4 apt. Flawing Street. The Grand Avenue. Liverpool, UK 33342', 'patterns-business' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"5px"}}},"textColor":"default"} -->
<p class="has-default-color has-text-color" style="margin-bottom:5px"><?php esc_html_e( 'Tel : +44-20-2355-3456', 'patterns-business' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"textColor":"default"} -->
<p class="has-default-color has-text-color"><?php esc_html_e( 'Email : demo@example.com', 'patterns-business' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->
