<?php
/**
 * Search
 *
 * @package passport
 * @subpackage passport
 * @since Passport v.1.0.
 * 
**/
    get_header();

    $passport_blog_content_column       = get_theme_mod( 'passport_blog_main_content', 'main_content' );
	$passport_blog_sidebar_position     = get_theme_mod( 'passport_blog_sidebar_position', 'left' );
	$passport_blog_sidebar_width	    = get_theme_mod( 'passport_blog_sidebar_width', 'sidebar_25' );

	$image_404 = get_theme_mod( 'passport_404_image', esc_html__( '', 'passport' ) );
 ?>

<div id="primary" class="container">
	<div id="wrapper" class="content-column clearfix">
	<?php if( have_posts() ) : ?>
		<h3 class="page-title">
		<?php
			if ( is_search() ) {
				the_search_query();
			} 
		?>
		</h3>
		<?php 
		/* Left Sidebar */
		if ( 'main_content' == $passport_blog_content_column ) : ?>
			<!-- Left sidebar shows nothing -->
		<?php elseif ( 'left' == $passport_blog_sidebar_position ) : 
			if( 'sidebar_25' == $passport_blog_sidebar_width ) : ?>
				<div id="sidebar" class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
			<?php elseif( 'sidebar_33' == $passport_blog_sidebar_width ) : ?>
				<div id="sidebar" class="col-xs-12 col-sm-6 col-md-4 col-lg-4">
			<?php endif; ?><!--End of sidebar width loop -->
					<div class="row">
						<div class="left-sidebar">
							<?php get_sidebar(); ?>
						</div>
					</div>
			<?php if( 'sidebar_25' == $passport_blog_sidebar_width ) : ?>
				</div><!-- #sidebar -->
			<?php elseif( 'sidebar_33' == $passport_blog_sidebar_width ) : ?>
				</div><!-- #sidebar -->
			<?php endif; ?><!--End of sidebar width loop -->
		<?php endif; ?><!-- End of loop -->

		<?php 
		/* Search */
		if( 'main_content' == $passport_blog_content_column ) : ?>
			<?php get_template_part( 'partials/partials', 'page-template' ); ?>
		<?php elseif( 'sidebar' == $passport_blog_content_column ) : ?>
			<?php if( 'sidebar_25' == $passport_blog_sidebar_width ) : ?>
				<div id="content" class="col-xs-12 col-sm-12 col-md-9 col-lg-9">
			<?php elseif( 'sidebar_33' == $passport_blog_sidebar_width ) : ?>
				<div id="content" class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
			<?php endif; ?><!--End of sidebar width loop -->
					<div class="row">
						<?php get_template_part( 'partials/partials', 'page-template' ); ?>
					</div>
			<?php if( 'sidebar_25' == $passport_blog_sidebar_width ) : ?>
				</div><!-- #content -->
			<?php elseif( 'sidebar_33' == $passport_blog_sidebar_width ) : ?>
				</div><!-- #content -->
			<?php endif; ?><!--End of sidebar width loop -->
		<?php endif; ?><!-- End of Loop -->

		<?php 
		/*Right Sidebar*/
		if ( 'main_content' == $passport_blog_content_column ) : ?>
			<!-- Right sidebar shows nothing -->
		<?php elseif( 'sidebar' == $passport_blog_content_column ) : ?>	
			<?php if( 'sidebar_25' == $passport_blog_sidebar_width ) : ?>
				<div id="sidebar" class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
			<?php elseif( 'sidebar_33' == $passport_blog_sidebar_width ) : ?>
				<div id="sidebar" class="col-xs-12 col-sm-6 col-md-4 col-lg-4">
			<?php endif; ?><!--End of sidebar width loop -->
					<div class="row">
						<div class="right-sidebar">
						<?php get_sidebar(); ?>
						</div>
					</div>
			<?php if( 'sidebar_25' == $passport_blog_sidebar_width ) : ?>
				</div><!-- #sidebar -->
			<?php elseif( 'sidebar_33' == $passport_blog_sidebar_width ) : ?>
				</div><!-- #sidebar -->
			<?php endif; ?><!--End of sidebar width loop -->
		<?php endif; ?>

	<?php else: ?><!-- No posts show in Seach -->
	<div id="not-found">
		<div class="page-item">
            <?php if( ! empty( $image_404 ) ) : ?>
			    <img src="<?php echo $image_404; ?>" class="size-large wp-post-image" alt="404_image" >
            <?php endif; ?>
			<div class="page-content">
				<header class="error-header">
					<h1 class="error-title">
						<?php _e( 'Not Found', 'passport' ); ?>
					</h1>
				</header>
				<div class="error-content">
					<h2 class="error-description"><?php esc_html_e( 'Sorry, but nothing matched your search criteria.', 'passport' ); ?><br />
					<small><?php esc_html_e( 'Please try again with some different keywords.', 'passport' ); ?></small></h2>
					<br />
					<?php get_search_form(); ?>
				 </div>
			</div>
		</div>
	</div><!-- #not-found -->
	<?php endif; ?>
	</div><!-- #wrapper -->
</div><!-- #primary -->
<?php get_footer();