<div class="navbar-header clearfix">
	<header>
	<?php 
		$header_text		= display_header_text();
		$blogname			= get_bloginfo( 'name' );
		$blogdescription	= get_bloginfo( 'description' );
		$custom_logo_id	    = get_theme_mod( 'custom_logo' );
        $logo               = wp_get_attachment_image_src( $custom_logo_id, 'full' );

        if ( has_custom_logo() ) : ?>
            <figure>
			    <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
				    <img src="<?php echo esc_url( $logo[0] ); ?>" class="navbar-brand img-responsive" alt="logo">
			    </a>
            </figure>
		<?php elseif( ! has_custom_logo() && ! empty( $header_text ) && ! empty( $blogname ) ) : ?>
			<h3 class="site-title">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo $blogname; ?></a>
            </h3>
            <?php if( ! empty ( $blogdescription )  || is_customize_preview() ) : ?>
			    <span class="small site-description"><?php echo $blogdescription; ?></span>
            <?php endif; ?>
		<?php endif; ?>
	</header>
</div><!-- .navbar-header -->