<?php 
    global $post;

    //Activate Post Format
    $post_format    = get_post_format( get_the_ID() );
    $aside_active   = get_post_meta( get_the_ID(), 'as_active', true );
    $audio_active	= get_post_meta( get_the_ID(), 'a_active', true );
    $gallery_active	= get_post_meta( get_the_ID(), 'g_active', true );
    $image_active	= get_post_meta( get_the_ID(), 'i_active', true );
    $link_active	= get_post_meta( get_the_ID(), 'l_active', true );
    $quote_active	= get_post_meta( get_the_ID(), 'q_active', true );
    $video_active	= get_post_meta( get_the_ID(), 'v_active', true);

    //Check if do not want to show the content
    $aside_no_content	= get_post_meta( get_the_ID(), 'as_no_content', true);
    $audio_no_content	= get_post_meta( get_the_ID(), 'a_no_content', true );
    $gallery_no_content = get_post_meta( get_the_ID(), 'g_no_content', true );
    $image_no_content	= get_post_meta( get_the_ID(), 'i_no_content', true ); 
    $link_no_content	= get_post_meta( get_the_ID(), 'l_no_content', true );
    $quote_no_content	= get_post_meta( get_the_ID(), 'q_no_content', true );
    $video_no_content	= get_post_meta( get_the_ID(), 'v_no_content', true);

	$archive_year   = get_the_time( 'Y' ); 
	$archive_month  = get_the_time( 'm' ); 
	$archive_day    = get_the_time( 'd' );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> aria-label="post-<?php the_ID(); ?>">
    <div class="post-media">
        <?php   
           if( false == $post_format ) {
               get_template_part( 'partials/partials', 'image' );
            } elseif( 'aside' == $post_format && ! empty( $aside_active ) ) {
                echo passport_display_aside_post_format();
            } elseif( 'link' == $post_format && ! empty( $link_active ) ) {
                echo passport_display_link_post_format();
            } elseif( 'quote' == $post_format && ! empty( $quote_active ) ) {
	            echo passport_display_quote_post_format();
            } elseif( 'image' == $post_format && ! empty( $image_active ) ) {
	            echo passport_display_image_post_format();
            } elseif( 'gallery' == $post_format && ! empty( $gallery_active ) ) {
                echo passport_display_gallery_post_format();
            } elseif( 'audio' == $post_format && ! empty( $audio_active ) ) {
		        echo passport_display_audio_post_format();
            } elseif( 'video' == $post_format && !empty( $video_active ) ) {
	            echo passport_display_video_post_format();
            } else {
               get_template_part( 'partials/partials', 'image' );        
            }
        ?>
    </div>
    <?php if( ( false == get_post_format() && 'publish' === get_post_status() )
            || ( 'aside' == $post_format && 'on' !== $aside_no_content && 'publish' === get_post_status() )  
            || ( 'link' == $post_format && 'on' !== $aside_no_content && 'publish' === get_post_status() )
            || ( 'quote' == $post_format && 'on' !== $quote_no_content && 'publish' === get_post_status() )
            || ( 'image' == $post_format && 'on' !== $image_no_content && 'publish' === get_post_status() )
            || ( 'gallery' == $post_format && 'on' !== $gallery_no_content && 'publish' === get_post_status() )
            || ( 'audio' == $post_format && 'on' !== $audio_no_content && 'publish' === get_post_status() )
            || ( 'video' == $post_format && 'on' !== $video_no_content && 'publish' === get_post_status() ) ) : 
    ?>
    <div class="post-content">
        <header class="entry-header">
            <h4 class="entry-title"><a href="<?php echo esc_url( get_the_permalink() ); ?>"><?php the_title(); ?></a></h4>
	        <p class="post-info">
		        <?php echo passport_get_simple_likes_button( get_the_ID() ); ?>
	            |	<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="fa fa-user"></i> <?php echo get_the_author(); ?></a>
	            |	<a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><i class="fa fa-clock-o"></i> <?php echo get_the_date(); ?></a>
	            </p>
        </header>
        <div class="entry-content"><?php echo passport_excerpt( '25' ); ?></div>
    </div>
    <?php // endif; ?>
    <?php endif; ?>
    <div class="clear"></div>   
</article>