<?php

global $wp_query;
global $passport_template_name;

if( is_page_template( 'template-medium-image.php' ) || is_page_template( 'template-large-image.php' ) || is_home() ) { 

	//Set variable
	$id					= $wp_query->get_queried_object_id(); //Get ID of this template
	$passport_template_name	= get_page_template_slug( $id ); // Get the template slug
	$post_type			= array( 'post' );
	$stickies			= get_option( 'sticky_posts' );
	$ppp				= get_option( 'posts_per_page' );
    $excludeArray       = NULL;

    if( is_home() ) { /*Set Default value for Blog Roll page (index page)*/
	    $term_active		= '';
	    $order				= 'desc';
	    $order_by			= 'date';
	    $term_name			= '';
        $excludeArray       = '';
    } elseif( is_page_template( 'template-medium-image.php' ) ) {
	    $term_active		= get_post_meta( $id, 'me_term_active', true );
	    $order				= get_post_meta( $id, 'me_order', true );
	    $order_by			= get_post_meta( $id, 'me_order_by', true );
	    $term_name			= get_post_meta( $id, 'me_page_post_format', true );
	    $term_name			= ( 'on' == $term_active ) ? $term_name : '';
	    $exclude			= get_post_meta( $id, 'me_exclude', true );
	    $excludeArray		= explode( ',', $exclude );
        $excludeArray       = array_merge( $stickies, $excludeArray );
    } elseif( is_page_template( 'template-large-image.php' ) || is_home() ) {
	    $term_active		= get_post_meta( $id, 'la_term_active', true );
	    $order				= get_post_meta( $id, 'la_order', true );
	    $order_by			= get_post_meta( $id, 'la_order_by', true );
	    $term_name			= get_post_meta( $id, 'la_page_post_format', true );
	    $term_name			= ( 'on' == $term_active ) ? $term_name : '';
	    $exclude			= get_post_meta( $id, 'la_exclude', true );
	    $excludeArray		= explode( ',', $exclude );
        $excludeArray       = array_merge( $stickies, $excludeArray );
    } 

	    $sticky_args = array( 
		    'ignore_sticky_posts'	=>  false,
		    'post__in'				=> $stickies
	    );
	
    //  if a sticky exists and it's the front page...
    if ( $stickies && ( is_page_template( 'template-medium-image.php' ) || is_page_template( 'template-large-image.php' ) || is_home() ) && ! is_paged() ) {

	    // Instantiate custom query
	    $sticky_posts		= new WP_Query( $sticky_args );

	    // Pagination fix because pagination works with $wp_query, not custom query. 
	    $temp				= $wp_query; 
	    $wp_query			= null;
	    $wp_query			= $sticky_posts;

	    ?>			
	    <?php // code to display the sticky posts
	    if( $sticky_posts -> have_posts() ) : ?>
		    <?php while ( $sticky_posts->have_posts() ) : $sticky_posts->the_post(); ?>
			    <div class="post-item">
				    <?php
					    $format = get_post_format();
					    get_template_part( 'partials/format', $format );
				    ?>
			    </div>
		    <?php endwhile; // end of the loop. ?>
	    <?php endif; // if has_post() ?>
	    <?php wp_reset_postdata();

	    // Reset
	    $wp_query			= null;
	    $wp_query 			= $temp;
    }	
	    $main_args = array (
		    'post_type'				=> $post_type,
		    'post_format'			=> $term_name,
		    'post_status'			=> 'publish',
		    'pagination'			=> true,
		    'posts_per_page'		=> $ppp,
		    'paged'					=> $paged,
		    'order'					=> $order,
		    'orderby'				=> $order_by,
		    'ignore_sticky_posts'	=> true,
		    'post__not_in'			=> $excludeArray
	    );	

	    // Instantiate custom query
	    $main_query			= new WP_Query( $main_args );

	    // Pagination fix because pagination works with $wp_query, not custom query. 
	    $temp				= $wp_query; 
	    $wp_query			= null;
	    $wp_query			= $main_query
    ?>			
	    <?php // code to display the posts
	    if( $main_query	 -> have_posts() ) : ?>
		    <?php while ( $main_query -> have_posts() ) : $main_query -> the_post(); ?>
			    <div class="post-item">
				    <?php
					    $format		= get_post_format();
					    get_template_part( 'partials/format', $format );
				    ?>
			    </div>
		    <?php endwhile; // end of the loop. ?>
		    <?php endif; // if has_post() ?>
	    <?php wp_reset_postdata(); // Reset postdata ?>
    <?php
	    passport_theme_paging_nav(); // Custom query loop pagination
	
	    // Reset main query object 
	    $wp_query			= null;
	    $wp_query 			= $temp; 

} elseif( is_page_template( 'template-masonry.php' ) ) { ?> 

    <div class="blog-masonry grid">
        <div class="grid-sizer"></div>
	    <div class="gutter-sizer"></div>
<?php
	//Set variable
	$id					= $wp_query->get_queried_object_id(); //Get ID of this template
	$passport_template_name	= get_page_template_slug( $id ); // Get the template slug
	$post_type			= array( 'post' );
	$term_active		= get_post_meta( $id, 'ma_term_active', true );
	$order				= get_post_meta( $id, 'ma_order', true );
	$order_by			= get_post_meta( $id, 'ma_order_by', true );
	$term_name			= get_post_meta( $id, 'ma_page_post_format', true );
	$term_name			= ( 'on' == $term_active ) ? $term_name : '';
	$stickies			= get_option( 'sticky_posts' );
	$ppp				= get_option( 'posts_per_page' );
  	$exclude			= get_post_meta( $id, 'ma_exclude', true );
	$excludeArray		= explode( ',', $exclude );
    $excludeArray       = array_merge( $stickies, $excludeArray );

	$sticky_args = array( 
		'ignore_sticky_posts'	=>  false,
		'post__in'				=> $stickies
	);
	
//  if a sticky exists and it's the front page...
if ( $stickies && 'template-masonry.php' == $passport_template_name && ! is_paged() ) {

	// Instantiate custom query
	$sticky_posts = new WP_Query( $sticky_args );

	// Pagination fix because pagination works with $wp_query, not custom query. 
	$temp				= $wp_query; 
	$wp_query			= null;
	$wp_query			= $sticky_posts
	?>			
	<?php // code to display the sticky posts
	if( $sticky_posts -> have_posts() ) : ?>
		<?php while ( $sticky_posts->have_posts() ) : $sticky_posts->the_post(); ?>
			<div class="grid-item animateblock btm">
				<?php
					$format = get_post_format();
					get_template_part( 'partials/format', $format );
				?>
			</div>
		<?php endwhile; // end of the loop. ?>
	<?php endif; // if has_post() ?>
	<?php wp_reset_postdata();

	// Reset
	$wp_query			= null;
	$wp_query 			= $temp; 
}
	$main_args = array (
		'post_type'				=> $post_type,
		'post_format'			=> $term_name,
		'post_status'			=> 'publish',
		'pagination'			=> true,
		'posts_per_page'		=> $ppp,
		'paged'					=> $paged,
		'order'					=> $order,
		'orderby'				=> $order_by,
		'ignore_sticky_posts'	=> true,
		'post__not_in'			=> $excludeArray
	);	

	// Instantiate custom query
	$main_query			= new WP_Query( $main_args );

	// Pagination fix because pagination works with $wp_query, not custom query. 
	$temp				= $wp_query; 
	$wp_query			= null;
	$wp_query			= $main_query
?>			
	<?php // code to display the posts
	if( $main_query	 -> have_posts() ) : ?>
		<?php while ( $main_query -> have_posts() ) : $main_query -> the_post(); ?>
			<div class="grid-item animateblock btm">
				<?php
					$format		= get_post_format();
					get_template_part( 'partials/format', $format );
				?>
			</div>
		<?php endwhile; // end of the loop. ?>
	<?php endif; // if has_post() ?>
	<?php wp_reset_postdata(); // Reset postdata ?>
		</div>
<?php
	passport_theme_paging_nav(); // Custom query loop pagination
	
	// Reset main query object 
	$wp_query			= null;
	$wp_query 			= $temp; 

} else {

	// run the default query if is_home() returns false
	// (i.e. search and archive pages)
	while ( have_posts() ) : the_post(); ?>
		<div class="post-item">
			<?php
				$format = get_post_format();								
				get_template_part( 'partials/format', $format );
			?>
		</div>
<?php endwhile;  
	passport_theme_paging_nav();
}	