<?php 

$category_list		= get_the_category_list();
$tags				= get_the_tags();
$video_film_by		= get_post_meta( get_the_ID(), 'v_film', true );	
$audio_reference	= get_post_meta( get_the_ID(), 'a_reference', true );
$image_picture_by	= get_post_meta( get_the_ID(), 'i_picture', true );
$archive_year		= get_the_time( 'Y' ); 
$archive_month		= get_the_time( 'm' ); 
$archive_day		= get_the_time( 'd' ); 

if( is_front_page() ) : ?>
	<p class="post-info clearfix">
		<?php echo passport_get_simple_likes_button( get_the_ID() ); ?>
		|	<span><i class="fa fa-user"></i>
			<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><?php the_author(); ?></a></span>
		|	<span><i class="fa fa-clock-o"></i>
			<a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><?php the_time( 'F j, Y' ) ?></a></span>
		<?php if( ! empty( $category_list ) ) : ?>
		|	<span><i class="fa fa-list-ul"></i>
			<?php echo get_the_category_list( __( ', ', 'passport' ) ); ?></span> 
		<?php endif; ?>
		</p>
<?php elseif( is_single() ) : ?>
	<p class="post-info clearfix">
		<?php echo passport_get_simple_likes_button( get_the_ID() ); ?>
		|	<span><i class="fa fa-user"></i>
			<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><?php the_author(); ?></a></span> 
		|	<span><i class="fa fa-clock-o"></i>
			<a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><?php the_time( 'F j, Y' ); ?></a></span>
		<?php if( ! empty( $category_list ) ) : ?>
		|	<span><i class="fa fa-list-ul"></i>
			<?php echo get_the_category_list( __( ', ', 'passport' ) ); ?></span>  
		<?php endif; ?>
		<?php if( ! empty( $video_film_by ) ) : ?>
		|	<span><i class="fa fa-film"></i>
			<?php echo $video_film_by; ?></span> 
		<?php endif; ?>
		<?php if( ! empty( $audio_reference ) ) : ?>
		|	<span><i class="fa fa-music"></i>
			<?php echo $audio_reference; ?></span> 
		<?php endif; ?>
		<?php if( ! empty( $image_picture_by ) ) : ?>
		|	<span><i class="fa fa-picture-o"></i>
			<?php echo $image_picture_by; ?></span> 
		<?php endif; ?>
        <?php if( ! empty( $tags ) ) : ?><!-- Tags -->
		    <span class="alignright">
		    	<i class="fa fa-tags"></i>
					<?php the_tags( '', ', ', '' ); ?>
				</span> 
		<?php endif; ?> 
	</p>
<?php elseif( is_page() || is_404() ) : ?>
<?php else : ?>
	<p class="post-info clearfix">
		<?php echo passport_get_simple_likes_button( get_the_ID() ); ?>
		|	<span><i class="fa fa-user"></i>
			<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><?php the_author(); ?></a></span>
		|	<span><i class="fa fa-clock-o"></i>
			<a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><?php the_time( 'M j, Y' ) ?></a></span>
		<?php if( ! empty( $category_list ) ) : ?>
		|	<span><i class="fa fa-list-ul"></i>
			<?php echo get_the_category_list( __( ', ', 'passport' ) ); ?></span>
		<?php endif; ?>
		<?php if( ! empty( $tags ) ) : ?>
		|	<span><i class="fa fa-tags"></i>
			<?php the_tags( 'Tags: ', ', ', '' ); ?></span> 
		<?php endif; ?>
		</p>
<?php endif;