<?php
	
    global $passport_template_name;

	$image_404		= get_theme_mod( 'passport_404_image', '' );

if( is_single() || is_page() && ! is_front_page() ) : ?><!-- Single or Page -->
<figure>
    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
	    <?php echo passport_display_image(); ?>
    </a>
</figure>

<?php elseif( "template-large-image.php" == $passport_template_name ) : ?><!-- Large -->
<figure>
    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
        <?php echo passport_display_image(); ?>
    </a>
</figure>

<?php elseif( "template-masonry.php" == $passport_template_name ) : ?><!-- Masonry -->
<figure class="bglayer">
    <a href="#<?php echo $post->post_name; ?>" title="<?php the_title_attribute(); ?>" class="lightbox hvr-grow" >
		<?php echo passport_display_image(); ?>
	    <span class="icon-hero"><?php echo passport_icon_shows(); ?></span>
    </a>
</figure>
<figure class="lightbox-target" id="<?php echo $post->post_name; ?>">
   <?php echo the_post_thumbnail( 'large-image' ); ?>
   <a class="lightbox-close" href="#"></a>
</figure>

<?php elseif( "template-medium-image.php" == $passport_template_name || is_archive() || is_search() ) : ?><!-- Medium / Archive / Search -->
<figure class="bglayer">
    <a href="#<?php echo $post->post_name; ?>" title="<?php the_title_attribute(); ?>" class="lightbox hvr-grow" >
		<?php echo passport_display_image(); ?>
		<span class="icon-hero"><?php echo passport_icon_shows(); ?></span>
    </a>
</figure>
<figure class="lightbox-target" id="<?php echo $post->post_name; ?>">
   <?php echo the_post_thumbnail( 'large-image' ); ?>
   <a class="lightbox-close" href="#"></a>
</figure>

<?php  elseif ( is_home() ) : ?><!-- blog page -->
<figure class="bglayer">
    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="hvr-grow">
		<?php echo passport_display_image(); ?>
    </a>
</figure>

<?php  elseif ( is_404() ) : ?><!-- 404 page -->
	<?php if ( ! empty( $image_404 ) ) : ?>
        <figure>
    		<img src="<?php echo esc_url( $image_404 ); ?>" alt="404_image" class="size-large wp-post-image">
	    </figure>
    <?php endif; ?>

<?php elseif( is_front_page() && ! is_page_template() ) : ?><!-- Magazine -->
<figure>
    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
		<?php echo passport_display_image(); ?>
    </a>
</figure>

<?php elseif ( is_front_page() && is_home() ) : ?><!-- Default Homepage-->
<figure class="bglayer">
    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="hvr-grow">
		<?php echo passport_display_image(); ?>
	</a>
</figure>

<?php elseif( is_front_page() ) : ?><!-- static homepage -->
<figure class="bglayer">
    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="hvr-grow">
		<?php echo passport_display_image(); ?>
    	<span class="icon-hero"><?php echo passport_icon_shows(); ?></span>
    </a>
</figure>



<?php endif; 