<?php
	
    global $passport_template_name;

	$title_404		= get_theme_mod( 'passport_title_404', '' );

if( is_front_page() && is_home() || is_front_page() ) : ?><!-- Default homepage, Static homepage -->
	<header class="entry-header">
		<h4 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
        <?php get_template_part( 'partials/partials', 'meta' ); ?>
	</header>

<?php elseif( is_single() || is_page() || is_attachment() ) : ?><!-- Single and Page -->
	<header class="page-header">
		<h1 class="page-title"><?php the_title(); ?></h1>
        <?php get_template_part( 'partials/partials', 'meta' ); ?>
	</header>

<?php elseif ( 'template-large-image.php' == $passport_template_name ) : ?><!-- Large image template -->
	<header class="entry-header">
		<h1 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>
        <?php get_template_part( 'partials/partials', 'meta' ); ?>
	</header>

<?php elseif( 'template-masonry.php' == $passport_template_name ) : ?><!-- Masonry template -->
	<header class="entry-header">
		<h4 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
        <?php get_template_part( 'partials/partials', 'meta' ); ?>
	</header>

<?php elseif( 'template-medium-image.php' == $passport_template_name || is_archive() || is_search() ) : ?><!-- Medium image template, Archives, Searches, Categories, Tags -->
	<header class="entry-header"> 
		<h4 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
        <?php get_template_part( 'partials/partials', 'meta' ); ?>
	</header>

 <?php elseif( is_home() ) : ?><!-- blog page -->
	<header class="entry-header">
		<h1 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>
        <?php get_template_part( 'partials/partials', 'meta' ); ?>
	</header>

<?php elseif( is_404() ) : ?><!-- 404 Page -->
	<?php if ( ! empty( $title_404 ) ) : ?>
 	    <header class="error-header">
			<h1 class="error-title"><?php echo $title_404; ?></h1>
            <?php get_template_part( 'partials/partials', 'meta' ); ?>
        </header>
	<?php endif; ?>

<?php else : ?><!-- Othes -->
 	<header class="entry-header">
		<h4 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
        <?php get_template_part( 'partials/partials', 'meta' ); ?>
	</header>
<?php endif;