<?php
    global $passport_template_name;

	$tags			 = get_the_tags();
   	$passport_button = get_theme_mod( 'passport_button_text', esc_html__( 'Read More', 'passport' ) );

	$text_default    = '';
	$text_404		 = get_theme_mod( 'passport_text_404', '' );
    $event_place     = get_post_meta( get_the_ID(), 'event_place', true );
	$event_start     = get_post_meta( get_the_ID(), 'event_start', true );
	$event_finish    = get_post_meta( get_the_ID(), 'event_finish', true );
	$progressbar     = get_post_meta( get_the_ID(), 'progressbar', true );	

	if ( is_front_page() && is_home() ) : ?><!-- Default Homepage-->
		<div class="entry-content"> 
			<p><?php echo get_the_excerpt(); ?></p>
			<p><a class="btn btn-color" href="<?php the_permalink(); ?>" role="button"><span class="screen-reader"><?php the_title(); ?> </span><?php echo $passport_button; ?></a></p>
		</div>
        <div class="clear"></div>

	<?php elseif ( is_front_page() ) : ?><!-- static homepage -->
		<div class="entry-content"> 
			<p><?php echo get_the_excerpt(); ?></p>
			<p><a class="btn btn-color" href="<?php the_permalink(); ?>" role="button"><span class="screen-reader"><?php the_title(); ?> </span><?php echo $passport_button; ?></a></p>
		</div>
        <div class="clear"></div>

	<?php elseif ( is_single() || is_page() ) : ?><!-- Post and Page-->
		<div class="entry-content">
             <?php  if( ! empty ( $event_start ) || ! empty( $event_finish ) || ! empty( $event_place ) || ! empty( $progressbar ) ) : ?>
                <div class="row">
                    <div class="col-md-3">
                        <?php echo passport_program_and_progress(); ?>
                    </div>
                    <div class="col-md-9">
                        <?php the_content(); ?>
                    </div>
                </div>
            <?php else : ?>
			    <?php the_content(); ?>
            <?php endif; ?>      
        </div>
        <div class="clear"></div>

	<?php elseif ( "template-large-image.php" == $passport_template_name ) : ?><!--Large image template-->
		<div class="entry-content">
			<p><?php echo get_the_excerpt(); ?></p>
			<p><a class="btn btn-color" href="<?php the_permalink(); ?>" role="button"><span class="screen-reader"><?php the_title(); ?> </span> <?php echo $passport_button; ?></a></p>
		</div>
        <div class="clear"></div>

	<?php elseif ( "template-masonry.php" == $passport_template_name ) : ?><!--Masonry template-->
		<div class="entry-content">
			<p><?php echo get_the_excerpt(); ?></p>
			<p><a class="btn btn-color" href="<?php the_permalink(); ?>" role="button"><span class="screen-reader"><?php the_title(); ?> </span> <?php echo $passport_button; ?></a></p>
		</div>
        <div class="clear"></div>

	<?php elseif ( "template-medium-image.php" == $passport_template_name || is_search() || is_archive() ) : ?><!--Medium template, Searches, Archives and Tags-->
		<div class="entry-content">
			<p><?php echo get_the_excerpt(); ?></p>
			<p><a class="btn btn-color" href="<?php the_permalink(); ?>" role="button"><span class="screen-reader"><?php the_title(); ?> </span> <?php echo $passport_button; ?></a></p>
		</div>
        <div class="clear"></div>

	<?php elseif ( is_home() ) : ?><!-- blog page -->
		<div class="entry-content"> 
			<p><?php echo get_the_excerpt();?></p>
			<p><a class="btn btn-color" href="<?php the_permalink(); ?>" role="button"><span class="screen-reader"><?php the_title(); ?> </span> <?php echo $passport_button; ?></a></p>
		</div>
        <div class="clear"></div>

	<?php elseif ( is_404() ) : ?><!-- 404 Page -->
		<div class="error-content">
		    <h2 class="error-description"><?php esc_html_e( 'Unfortunately, this page does not exist. Please check your URL or return to Home Page.', 'passport' ); ?></h2>
        </div>
        <br />
		<?php get_search_form(); ?>
        <div class="clear"></div>
		
	<?php elseif ( $post->post_excerpt ) : ?><!--Post excerpt-->
	    <div class="entry-content">
		    <p><?php echo get_the_excerpt(); ?></p>
			<p><a class="btn btn-color" href="<?php the_permalink(); ?>" role="button"><span class="screen-reader"><?php the_title(); ?> </span> <?php echo $passport_button; ?></a></p>
		</div>
        <div class="clear"></div>
		
	<?php else : ?><!-- Others -->
		<div class="entry-content">
			<?php the_content(); ?>
		</div>
        <div class="clear"></div>
	<?php endif;