<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> aria-label="post-<?php the_ID(); ?>">
	<?php
		global $wp_query;
		global $passport_template_name;
		$audio_active		= get_post_meta( get_the_ID(), 'a_active', true );
		$audio_no_content	= get_post_meta( get_the_ID(), 'a_no_content', true );
		$audio_select		= get_post_meta( get_the_ID(), 'a_select', true );	
		$audio_embed		= get_post_meta( get_the_ID(), 'a_embed', true );
		$audio_image		= get_post_meta( get_the_ID(), 'a_image', true );
		$audio_url			= get_post_meta( get_the_ID(), 'a_url', true );
		$attr = array(
			'src'			=> esc_url( $audio_url ),
			'loop'			=> '',
			'autoplay'		=> '',
			'preload'		=> 'none'
		);

		/*Define the attachment id of Home page*/
		$frontpage_id		= get_option( 'page_on_front' );
		$attachment_id		= get_post_thumbnail_id( $frontpage_id );	
	?>

	<!-- Show sticky post -->
	<?php get_template_part( 'partials/partials', 'sticky-posts' ); ?>

	<!-- Audio active, show audio post format -->
	<?php if ( 'on' == $audio_active && 'publish' === get_post_status() ) : ?>
		<?php if ( "template-medium-image.php" == $passport_template_name || is_search() || is_category() || is_date() || is_tag() || is_author() ) : ?>
			<div class="col-xs-12 col-sm-12 col-md-6  col-lg-6 post-media enlarge">
		<?php else : ?>
			<div class="post-media"> 
		<?php endif; ?>
			<?php echo passport_display_audio_post_format(); ?>
		<?php if ( "template-medium-image.php" == $passport_template_name || is_search() || is_category() || is_date() || is_tag() || is_author() ) : ?>
			</div>
		<?php else : ?>
			</div>
		<?php endif; ?>
	<?php endif; ?>

	<!-- Audio inactive, show the post thumbnail -->
	<?php if ( 'on' != $audio_active && ( has_post_thumbnail() || 0 != $attachment_id ) && 'publish' === get_post_status() ) : ?>
		<?php if ( "template-medium-image.php" == $passport_template_name || is_search() || is_category() || is_date() || is_tag() || is_author() ) : ?>
			<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 post-media enlarge">
		<?php else : ?>
			<div class="post-media"> 
		<?php endif; ?>
            <?php if ( is_single() ) : ?>
                <?php echo passport_display_audio_post_format(); ?>
            <?php else: ?>
			    <?php get_template_part( 'partials/partials', 'image' ); ?>
            <?php endif; ?>
		<?php if ( "template-medium-image.php" == $passport_template_name || is_search() || is_category() || is_date() || is_tag() || is_author() ) : ?>
			</div>
		<?php else : ?>
			</div>
		<?php endif; ?>
	<?php endif; ?>	

	<!-- Show header, meta and the content -->
	<?php if ( 'on' !== $audio_no_content && 'publish' === get_post_status() ) : ?>
		<?php if ( "template-medium-image.php" == $passport_template_name || is_search() || is_category() || is_date() || is_tag() || is_author() ) : ?>
			<div class="<?php if( has_post_thumbnail() || 0 != $attachment_id || 'on' == $audio_active ) { echo 'col-xs-12 col-sm-12 col-md-6 col-lg-6'; } else { echo 'col-xs-12 col-sm-12 col-md-12 col-lg-12'; } ?>">
		<?php else : ?>
			<div class="post-content"> 
		<?php endif;?>
		<?php
			get_template_part( 'partials/partials', 'header' ); 
			get_template_part( 'partials/partials', 'content' );
		?>
		<?php if ( "template-medium-image.php" == $passport_template_name || is_search() || is_category() || is_date() || is_tag() || is_author() ) : ?>
			</div>
		<?php else : ?>
			</div>
		<?php endif; ?>
	<?php endif; ?>
</article>
