<?php
/**
 * Contains all the functions related to sidebar and widget.
 * -------------------------------------------------------------------------
 * @package WordPress
 * @subpackage passport
 * @since passport 1.0
 *
 **/

add_action( 'widgets_init', 'passport_widgets_init' );

/**
 * Function to register the widget areas(sidebar).
 *
 * @since passport 1.0
**/
function passport_widgets_init() {
    
	//Registering main headline sidebar
	register_sidebar(array(
		'name'			=> esc_html__( 'Headline', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-headline',
		'description'	=> esc_html__( 'Headline widget area', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h3 class = "widget-title"><span>',
		'after_title'	=> '</span></h3>',
		) );

	//Regsitering slider headline sidebar
	register_sidebar(array(
		'name'			=> esc_html__( 'Sidebar for Headline', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-sidebar-headline',
		'description'	=> esc_html__( 'Sidebar for slider headline widget area', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );

	//Registering first section
	register_sidebar(array(
		'name'			=> esc_html__( 'First Section', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-section-1',
		'description'	=> esc_html__( 'First Section', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s bottom-to-top animateblock btm">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );

	//Registering first sidebar
	register_sidebar(array(
		'name'			=> esc_html__( 'First Sidebar', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-sidebar-1',
		'description'	=> esc_html__( 'First Sidebar', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s bottom-to-top animateblock btm">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );
        	
	//Registering second section
	register_sidebar(array(
		'name'			=> esc_html__( 'Second Section', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-section-2',
		'description'	=> esc_html__( 'Second Section', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s bottom-to-top animateblock btm">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );

	//Registering second sidebar
	register_sidebar(array(
		'name'			=> esc_html__( 'Second Sidebar', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-sidebar-2',
		'description'	=> esc_html__( 'Second Sidebar', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s bottom-to-top animateblock btm">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );

	//Registering third section
	register_sidebar(array(
		'name'			=> esc_html__( 'Third Section', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-section-3',
		'description'	=> esc_html__( 'Third Section', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s bottom-to-top animateblock btm">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );

	//Registering third sidebar
	register_sidebar(array(
		'name'			=> esc_html__( 'Third Sidebar', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-sidebar-3',
		'description'	=> esc_html__( 'Third Sidebar', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s bottom-to-top animateblock btm">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );

	//Registering fourth section
	register_sidebar(array(
		'name'			=> esc_html__( 'Fourth Section', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-section-4',
		'description'	=> esc_html__( 'Fourth Section', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s bottom-to-top animateblock btm">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );

	//Registering fourth sidebar
	register_sidebar(array(
		'name'			=> esc_html__( 'Fourth Sidebar', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-sidebar-4',
		'description'	=> esc_html__( 'Fourth Sidebar', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s bottom-to-top animateblock btm">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );

	//Registering fifth section - first column
	register_sidebar(array(
		'name'			=> esc_html__( 'First Column', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-front-page-1',
		'description'	=> esc_html__( 'First column in the front page', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s bottom-to-top animateblock btm">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );

	//Registering fifth section - second column
	register_sidebar(array(
		'name'			=> esc_html__( 'Second Column', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-front-page-2',
		'description'	=> esc_html__( 'Second column in the front page', 'passport' ),
		'before_widget'	=> '<aside id = "%1$s" class = "widget %2$s bottom-to-top animateblock btm">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class= "widget-title" ><span>',
		'after_title'	=> '</span></h4>',
		) );

	//Registering fifth section - third column
	register_sidebar(array(
		'name'			=> esc_html__( 'Third Column', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-front-page-3',
		'description'	=> esc_html__( 'Third column in the front page', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s bottom-to-top animateblock btm">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );

	//Registering fifth section - fourth column
	register_sidebar(array(
		'name'			=> esc_html__( 'Fourth Column', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-front-page-4',
		'description'	=> esc_html__( 'Fourth column in the front page', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s bottom-to-top animateblock btm">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );
      
	//Registering footer sidebar - first column
	register_sidebar( array(
		'name'			=> esc_html__( 'First Column for Footer', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-footer-1',
		'description'	=> esc_html__( 'First column for footer widget area', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "footer-widget-title"><span>',
		'after_title'	=> '</span></h4>',
	) );

	//Registering footer sidebar -second column
	register_sidebar( array(
		'name'			=> esc_html__( 'Second Column for Footer', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-footer-2',
		'description'	=> esc_html__( 'Second column for footer widget area', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "footer-widget-title">',
		'after_title'	=> '</h4>',
	) );

	//Registering footer sidebar - third colunmn
	register_sidebar( array(
		'name'			=> esc_html__( 'Third Column for Footer', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-footer-3',
		'description'	=> esc_html__( 'Third column for footer widget area', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "footer-widget-title"><span>',
		'after_title'	=> '</span></h4>',
	) );

	//Registering footer sidebar - fourth column
	register_sidebar( array(
		'name'			=> esc_html__( 'Fourth Column for Footer', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-footer-4',
		'description'	=> esc_html__( 'Fourth column for footer widget area', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "footer-widget-title"><span>',
		'after_title'	=> '</span></h4>',
	) );

	//Registering sidebar for pages
	register_sidebar(array(
		'name'			=> esc_html__( 'Sidebar for Pages', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-sidebar-page',
		'description'	=> esc_html__( 'Sidebar for pages widget area', 'passport' ),
		'before_widget'	=> '<aside id = "%1$s" class = "widget %2$s">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class= "widget-title" ><span>',
		'after_title'	=> '</span></h4>',
		) );

	//Registering sidebar for single post
	register_sidebar(array(
		'name'			=> esc_html__( 'Sidebar for Single Post', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-sidebar-single',
		'description'	=> esc_html__( 'Sidebar for single post widget area', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );

    //Registering sidebar for template page
	register_sidebar(array(
		'name'			=> esc_html__( 'Sidebar for Blog/Archive Page', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-sidebar',
		'description'	=> esc_html__( 'Sidebar for blog/archive/template page widget area', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );

	//Registering sidebar for blog page
	register_sidebar(array(
		'name'			=> esc_html__( 'Full Container', 'passport' ),
		'id'			=> PASSPORT_THEME_SLUG . '-full-container',
		'description'	=> esc_html__( 'Full Container Widget', 'passport' ),
		'before_widget' => '<aside id = "%1$s" class = "widget %2$s">',
		'after_widget'	=> '</aside>',
		'before_title'	=> '<h4 class = "widget-title"><span>',
		'after_title'	=> '</span></h4>',
		) );
}