<?php
/*
 * Passport Tabs Widget
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 */
class Passport_Tabs_Widget extends WP_Widget {

function __construct() {
	$widget_ops = array( 'classname' => 'widget_tabs clearfix', 'description' => esc_html__( 'Tabs', 'passport' ) );
	parent::__construct( 'passport_tabs_widget', esc_html__( 'Passport Tabs', 'passport' ), $widget_ops );

    $this->alt_option_name = 'widget_tabs';

}
// Creating widget front-end
// This is where the action happens
public function widget( $args, $instance ) {
	
	global $post;

	$first_tab		= ! empty( $instance['first_tab'] ) ? $instance['first_tab'] : 'false';
	$second_tab		= ! empty( $instance['second_tab'] ) ? $instance['second_tab'] : 'false';
	$third_tab		= ! empty( $instance['third_tab'] ) ? $instance['third_tab'] : 'false';

?> 	
	<?php echo $args['before_widget']; ?>
        <div class="container">
            <!-- Nav tabs -->
            <ul class="nav nav-tabs" role="tablist">
                <?php if ( '1' == $first_tab ) : ?>
                    <li role="presentation" class=""><a href="#gallery" class="tab-title" aria-controls="gallery" role="tab" data-toggle="tab">Gallery</a></li>
                <?php endif; ?>
                <?php if ( '1' == $second_tab ) : ?>
                    <li role="presentation"><a href="#recent-posts" class="tab-title" aria-controls="recent-posts" role="tab" data-toggle="tab">New Entry</a></li>
                <?php endif; ?>
                <?php if( '1' == $third_tab ) : ?>
                    <li role="presentation"><a href="#popular-posts" class="tab-title" aria-controls="popular-posts" role="tab" data-toggle="tab">Popular</a></li>
                <?php endif; ?>
            </ul>
            <!-- Tab panes -->
            <div class="tab-content">
                <?php if ( '1' == $first_tab ) : ?>
                    <div role="tabpanel" class="tab-pane" id="gallery"><?php echo passport_category_grid(); ?></div>
                <?php endif; ?>
                <?php if ( '1' == $second_tab ) : ?>
                    <div role="tabpanel" class="tab-pane" id="recent-posts"><?php echo passport_recent_posts(); ?></div>
                <?php endif; ?>
                <?php if( '1' == $third_tab ) : ?>
                    <div role="tabpanel" class="tab-pane" id="popular-posts"><?php echo passport_popular_posts(); ?></div>
                <?php endif; ?>
             </div>
        </div>
	<?php wp_reset_postdata(); // Reset Post Data ?>
	<?php echo $args['after_widget']; ?>
<?php }
		
// Widget Backend 
public function form( $instance ) {
	
//Set up some default widget settings.
	$instance			= wp_parse_args( (array) $instance, array( 
		'first_tab'		=> '0',
		'second_tab'	=> '0',
		'third_tab'		=> '0', 
	) );
	$first_tab		= $instance['first_tab'];
	$second_tab		= $instance['second_tab'];
	$third_tab		= $instance['third_tab'];

// Widget admin form
?>
    <p>
		<input class="checkbox" type="checkbox" <?php checked( $first_tab ); ?> id="<?php echo $this->get_field_id( 'first_tab' ); ?>" name="<?php echo $this->get_field_name( 'first_tab' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'first_tab' ); ?>"><?php esc_html_e( 'Show Gallery Tab', 'passport' ); ?></label>
	</p>

    <p>
		<input class="checkbox" type="checkbox" <?php checked( $second_tab ); ?> id="<?php echo $this->get_field_id( 'second_tab' ); ?>" name="<?php echo $this->get_field_name( 'second_tab' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'second_tab' ); ?>"><?php esc_html_e( 'Show New Entries Tab', 'passport' ); ?></label>
	</p>

    <p>
		<input class="checkbox" type="checkbox" <?php checked( $third_tab ); ?> id="<?php echo $this->get_field_id( 'third_tab' ); ?>" name="<?php echo $this->get_field_name( 'third_tab' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'third_tab' ); ?>"><?php esc_html_e( 'Show Popular Posts Tab', 'passport' ); ?></label>
	</p>
<?php }
	
// Updating widget replacing old instances with new instances
public function update( $new_instance, $old_instance ) {
	$instance = $old_instance;

	//Update new instances
	$instance['first_tab']		= isset( $new_instance['first_tab'] ) ? (bool) $new_instance['first_tab'] : false;
    $instance['second_tab']		= isset( $new_instance['second_tab'] ) ? (bool) $new_instance['second_tab'] : false;
    $instance['third_tab']		= isset( $new_instance['third_tab'] ) ? (bool) $new_instance['third_tab'] : false;

	return $instance;
	}
		
} // Class widget ends here

// Register and load the widget
function passport_tabs_load_widget() {
	register_widget( 'Passport_Tabs_Widget' );
}
add_action( 'widgets_init', 'passport_tabs_load_widget' );