<?php
/*
 * Passport Slider Widget
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 */
class Passport_Slider_Widget extends WP_Widget {

function __construct() {
	$widget_ops = array( 'classname' => 'widget_slider clearfix', 'description' => esc_html__( 'Display posts in slider', 'passport' ) );
	parent::__construct( 'passport_slider_widget', 	esc_html__( 'Passport Slider', 'passport' ), $widget_ops );

    $this->alt_option_name = 'widget_slider';

}
// Creating widget front-end
// This is where the action happens
public function widget( $args, $instance ) {

	global $_wp_additional_image_sizes;
    global $passport_section_settings;
    global $passport_headline_column;

	$number				= ! empty( $instance['number'] ) ? absint( $instance['number'] ) : 5;
	$category_name		= ! empty( $instance['category_name'] ) ? $instance['category_name'] : 'uncategories';
	$exclude			= ! empty( $instance['exclude'] ) ? $instance['exclude'] : '';
	$excludeArry		= explode( ',', $exclude);
	$orderby			= ! empty( $instance['orderby'] ) ?  $instance['orderby'] : 'date';
	$order				= ! empty( $instance['order'] ) ? $instance['order'] : 'desc';
	$hide_indicator		= ! empty( $instance['hide_indicator'] ) ? $instance['hide_indicator'] : 'false';
	$theme_setting		= get_theme_mod( 'passport_theme_setting', 'full_width_container' );
	$image_size			= 'full_width_container' == $theme_setting ? 'large-image-1349-670' : 'large-image'; 
	$tags				= get_the_tags();
	$category_id		= get_cat_ID( $category_name );
	$post_id			= get_the_ID();
	$i					= 0;

	$widget_args = array(
		'post_type'			=> 'post',
		'category_name'		=> $category_name,
		'posts_per_page'	=> $number,
		'meta_key'			=> '_thumbnail_id',
		'order'				=> $order,
		'orderby'			=> $orderby,
		'post__not_in'		=> $excludeArry
	);

	$wp_query = new WP_Query( $widget_args ); ?>

	<?php echo $args['before_widget']; ?>
	<div id="carousel-<?php echo $category_id; ?>" class="carousel slide gallery hero space <?php if( 'true' == $hide_indicator ) { echo 'no-padding'; } ?>" data-ride="carousel" data-interval="5000">
		<!-- Indicators -->
		<?php if( 'true' != $hide_indicator  ) : ?>
			<ol class="carousel-indicators images">	
				<?php while( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
					<li data-target="#carousel-<?php echo $category_id; ?>" data-slide-to="<?php echo $i; ?>" class="hvr-slide-background element">
						<span class="badge"><?php echo $i; ?></span>
                        <figure class="aligncenter">
						    <?php the_post_thumbnail( 'small-120-70', array( 'alt' => 'indicator-'. $i .'' ) ); ?>
                        </figure>
					</li>
					<?php $i++; ?> 
				<?php endwhile; ?>
			</ol>
		<?php endif; ?>	
		<!-- Wrapper for slides -->
		<div class="carousel-inner" role="listbox">
		<?php while( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
			<div class="item">
                <figure class="aligncenter">
				    <a href="<?php the_permalink(); ?>">
					    <?php the_post_thumbnail( $image_size ); ?>
				    </a>
				    <figcaption class="carousel-caption">
						    <h3 class="carousel-title"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
					        <div class="carousel-excerpt"><?php echo passport_excerpt( '18' ); ?></div>
				    </figcaption>
                </figure>
                <div class="caption-background"></div>
			</div>
		<?php endwhile; ?>
		</div>	
		<!-- Controls -->
		<a class="left carousel-control hvr-sweep-to-left" href="#carousel-<?php echo $category_id; ?>" role="button" data-slide="prev" aria-label="Previous Slide"><i class="fa fa-angle-left" aria-hidden="true"></i></a>
		<a class="right carousel-control hvr-sweep-to-right" href="#carousel-<?php echo $category_id; ?>" role="button" data-slide="next" aria-label="Next Slide"><i class="fa fa-angle-right" aria-hidden="true"></i></a>
	</div>
	<?php wp_reset_postdata(); // Reset Post Data ?>
<?php echo $args['after_widget']; ?>
<?php }
		
// Widget Backend 
public function form( $instance ) {
	
//Set up some default widget settings.
		$instance			 = wp_parse_args( (array) $instance, array( 
			'number'		=> '7', 
			'category_name' => 'uncategories', 
			'exclude'		=> '', 
			'orderby'		=> 'date', 
			'order'			=> 'desc',
			'hide_indicator'=> '',
		) );
		$number				= $instance['number'];
		$exclude			= $instance['exclude'];
		$hide_indicator		= $instance['hide_indicator'];

// Widget admin form
?>
	<p>
		<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php esc_html_e( 'Number of posts to show:', 'passport' ); ?></label>
		<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" size="3" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'category_name' ); ?>"><?php esc_html_e( 'Category Name (Slug):', 'passport' ); ?></label>
		<small><a class="alignright" href="/wp-admin/edit-tags.php?taxonomy=category"><b><?php esc_html_e( 'Add new category', 'passport' ); ?></b></a></small>
		<select name="<?php echo $this->get_field_name( 'category_name' ); ?>" id="<?php echo $this->get_field_id( 'category_name' ); ?>">
			<?php $categories = get_categories(); ?>
			<?php foreach( $categories as $category) : $cat_name = $category->slug; ?>
				<option value="<?php echo $cat_name; ?>"<?php selected( $instance['category_name'], $cat_name ); ?>><?php echo $cat_name; ?></option>
			<?php endforeach; ?>
		</select>
		<br />
		<small><?php esc_html_e( 'This selection will display your new category when it has at least one post in that category.', 'passport' ); ?></small>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'exclude' ); ?>"><?php esc_html_e( 'Exclude:', 'passport' ); ?></label> 
        <input type="text" value="<?php echo esc_attr( $exclude ); ?>" name="<?php echo $this->get_field_name( 'exclude' ); ?>" id="<?php echo $this->get_field_id( 'exclude' ); ?>"  size="35"/>
		<br />
		<small><?php esc_html_e( 'Post IDs, separated by commas.', 'passport' ); ?></small>
	</p>

	<p>
		<select name="<?php echo $this->get_field_name( 'orderby' ); ?>" id="<?php echo $this->get_field_id( 'orderby', 'passport' ); ?>">
			<option value="none"<?php selected( $instance['orderby'], 'none' ); ?>><?php esc_html_e( 'None', 'passport' ); ?></option>
            <option value="date"<?php selected( $instance['orderby'], 'date' ); ?>><?php esc_html_e( 'Date', 'passport' ); ?></option>
            <option value="author"<?php selected( $instance['orderby'], 'author' ); ?>><?php esc_html_e( 'Author', 'passport' ); ?></option>
            <option value="title"<?php selected( $instance['orderby'], 'title' ); ?>><?php esc_html_e( 'Title', 'passport' ); ?></option>
            <option value="name"<?php selected( $instance['orderby'], 'name' ); ?>><?php esc_html_e( 'Name', 'passport' ); ?></option>
            <option value="type"<?php selected( $instance['orderby'], 'type' ); ?>><?php esc_html_e( 'Type', 'passport' ); ?></option>
            <option value="modified"<?php selected( $instance['orderby'], 'modified' ); ?>><?php esc_html_e( 'Modified', 'passport' ); ?></option>
            <option value="rand"<?php selected( $instance['orderby'], 'rand' ); ?>><?php esc_html_e( 'Rand', 'passport' ); ?></option>
		</select>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'order' ); ?>"><?php esc_html_e( 'Order:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'order' ); ?>" id="<?php echo $this->get_field_id( 'order' ); ?>">
			<option value="desc"<?php selected( $instance['order'], 'desc' ); ?>><?php esc_html_e( 'DESC', 'passport' ); ?></option>
			<option value="asc"<?php selected( $instance['order'], 'asc' ); ?>><?php esc_html_e( 'ASC', 'passport' ); ?></option>
		</select>
	</p>

	<p>
		<input class="checkbox" type="checkbox" <?php checked( $hide_indicator ); ?> id="<?php echo $this->get_field_id( 'hide_indicator' ); ?>" name="<?php echo $this->get_field_name( 'hide_indicator' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'hide_indicator' ); ?>"><?php esc_html_e( 'Hide Image Indicators', 'passport' ); ?></label>
		<br />
	</p>

<?php
}
	
// Updating widget replacing old instances with new instances
public function update( $new_instance, $old_instance ) {
	
	$instance = $old_instance;

	//Define Array
	$categories	= get_categories();
	foreach( $categories as $category ) {
		$catsArray[] = '' . $category->slug . '';
	}
	$orderbyArry = array( 'none', 'date', 'author', 'title', 'name', 'parent', 'type', 'modified', 'rand' );
	$orderArry	 = array( 'desc', 'asc' );
	
	//Update new instances
	$instance['number']				= (int) $new_instance['number'];
	if ( in_array( $new_instance['category_name'], $catsArray ) ) {
		$instance['category_name']	= $new_instance['category_name'];
	} else {
		$instance['category_name']	= 'uncategories';
	}
	if ( in_array( $new_instance['orderby'], $orderbyArry ) ) {
		$instance['orderby']		= $new_instance['orderby'];
	} else {
		$instance['orderby']		= 'date';
	}
	if ( in_array( $new_instance['order'], $orderArry ) ) {
		$instance['order']			= $new_instance['order'];
	} else {
		$instance['order']			= 'desc';
	}
    $instance['exclude']			= wp_filter_nohtml_kses( $new_instance['exclude'] );
    $instance['hide_indicator']		= isset( $new_instance['hide_indicator'] ) ? (bool) $new_instance['hide_indicator'] : false;

		return $instance;
    }

} // Class widget ends here

// Register and load the widget
function passport_slider_load_widget() {
	register_widget( 'Passport_Slider_Widget' );
}
add_action( 'widgets_init', 'passport_slider_load_widget' );