<?php
/*
 * Passport Recent Posts With Video Widget
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 */
class Passport_Recent_Posts_With_Video_Widget extends WP_Widget {

function __construct() {
	$widget_ops = array( 'classname' => 'widget_recent_posts_with_video', 'description' => esc_html__( 'Display most recent video posts.', 'passport' ) );
	parent::__construct( 'passport_recent_posts_with_video_widget', esc_html__( 'Passport Recent Posts with Video', 'passport' ), $widget_ops );

    $this->alt_option_name = 'widget_recent_posts_with_video';
    add_action( 'wp_enqueue_scripts', array( $this, 'passport_widget_inline_style' ) );

}


/**
 * Styling the widget
 */
public function passport_widget_inline_style() { 
    $i = 0;

    $widget_options = get_option( $this->option_name );

    $custom_widget_css = '';
        if( is_array( $widget_options ) && count( $widget_options ) > 0 ) {
			foreach ( $widget_options as $key => $widget_option ) {
     
                $widget_title_bgcolor_option = isset( $widget_option['widget_title_bgcolor'] ) ? $widget_option['widget_title_bgcolor'] : '';
 
                if ( isset( $widget_title_bgcolor_option ) ) {
                    $custom_widget_css .= "#{$this->id_base}-{$key} .widget-title {";
                    $custom_widget_css .= ! empty( $widget_title_bgcolor_option ) ? 'background-color:'. $widget_title_bgcolor_option .';' :'background-color: #333333;';
                    $custom_widget_css .= "}";
                    $custom_widget_css .= "#{$this->id_base}-{$key} .widget-title span {";
                    $custom_widget_css .= 'color: #ffffff;';
                    $custom_widget_css .= "}";
    	       }
            $i++;
	    }
    }
    wp_add_inline_style( PASSPORT_THEME_SLUG . '-custom-style', $custom_widget_css );   
}


// Creating widget front-end
// This is where the action happens
public function widget( $args, $instance ) {
	
	$title						= ! empty( $instance['title'] ) ? $instance['title'] : '';
	$number						= ! empty( $instance['number'] ) ? absint( $instance['number'] ) : 5;
	$show_title					= ! empty( $instance['show_title'] ) ? $instance['show_title'] : false;
	$show_video					= ! empty( $instance['show_video'] ) ? $instance['show_video'] : false;
	$show_date					= ! empty( $instance['show_date'] ) ? $instance['show_date'] : false;
	$show_excerpt				= ! empty( $instance['show_excerpt'] ) ? $instance['show_excerpt'] : false;
	$widget_icon				= ! empty( $instance['widget_icon'] ) ? $instance['widget_icon'] : '';

	$widget_args				= array(
		'posts_per_page'		=> $number,
		'no_found_rows'			=> true,
		'post_status'			=> 'publish',
		'ignore_sticky_posts'	=> true,
		'post__not_in'			=> array( get_the_ID() ), //Not include current post
		'tax_query'				=> array(
			'relation'			=> 'OR',
			array(
				'taxonomy'		=> 'category',
				'field'			=> 'slug',
				'terms'			=> array( 'video' ),
			),
			array(
				'taxonomy'		=> 'post_format',
				'field'			=> 'slug',
				'terms'			=> array( 'post-format-video' ),
			),
		),
	);
	
	$wp_query	= new WP_Query( $widget_args );
    ?>
	<?php if ( $wp_query->have_posts() ) : ?>
	    <?php echo $args['before_widget']; ?>
		<?php if ( ! empty( $title ) ) {  echo '<h4 class="widget-title"><i class="'. $widget_icon .'"></i> <span>'. $title .'</span></h4>'; } ?>
		<ul class="list-unstyled">
		<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
			<li class="widget-post-item clearfix">
			    <?php
                    global $passport_template_name;

				    $video_select	= get_post_meta( get_the_ID(), 'v_select', true );
				    $video_embed	= get_post_meta( get_the_ID(), 'v_embed', true );
                    $video_url      = get_post_meta( get_the_ID(), 'v_url', true );
	                $width			= 'blog-masonry.php' == $passport_template_name ? '276px' : ( "template-medium-image.php" == $passport_template_name || is_search() || is_archive() ? '570px' : '1349px' );
	                $height			= 'blog-masonry.php' == $passport_template_name ? '276px' : ( "template-medium-image.php" == $passport_template_name || is_search() || is_archive() ? '299.98px' : '710px' );
                    $poster         = wp_get_attachment_image_src( get_post_thumbnail_id(), 'poster' );
				    $archive_year	= get_the_time( 'Y' ); 
				    $archive_month	= get_the_time( 'm' ); 
				    $archive_day	= get_the_time( 'd' );
 	                $attr = array(
		                'src'		=> esc_url( $video_url ),
                        'poster'    => $poster['0'],
		                'loop'		=> '',
		                'autoplay'	=> '',
                        'preload'   => 'auto',
		                'width'		=> $width,
		                'height'	=> $height,
	                ); 
			    ?>
			    <?php if ( ! empty ( $show_video ) && ! empty ( $video_url ) && 'video_url' == $video_select ) : ?>
                    <?php echo wp_video_shortcode( $attr ); ?>
			    <?php elseif( ! empty ( $show_video ) && ! empty ( $video_embed ) && 'video_embed_code' == $video_select ) : ?>
				    <div class="embed-responsive embed-responsive-16by9">
					    <?php echo $video_embed; ?>
				    </div> 
			    <?php endif; ?>
			    <div class="post-content">
				    <?php if ( $show_title ) : ?>
					    <h4 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
				    <?php endif; ?>
				
				    <?php if ( $show_date ) : ?>
					    <p class="post-info clearfix">
						    <?php echo passport_get_simple_likes_button( get_the_ID() ); ?>

				    |	<i class="fa fa-user"></i>
					    <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><?php the_author(); ?></a>  
		
				    |	<i class="fa fa-clock-o"></i>
					    <a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><?php the_time( 'M j, Y' ) ?></a>
		
				    <?php if( ! empty( $category_list ) ) { ?>
				    |	<i class="fa fa-list-ul"></i>
					    <?php echo get_the_category_list( esc_html__( ', ', 'passport' ) ); ?> 
				    <?php } ?>

				    <?php if( ! empty( $tags ) ) { ?>
				    |	<i class="fa fa-tags"></i>
					    <?php the_tags( 'Tags: ', ', ', '' ); ?> 
				    <?php } ?>
					    </p>
				    <?php endif; ?>

				    <?php if ( $show_excerpt ) : ?>
					    <p class="post-excerpt"><?php echo get_the_excerpt(); ?></p>
				    <?php endif; ?>
			    </div>
			</li>
		<?php endwhile; ?>
		</ul>
	    <?php echo $args['after_widget']; ?>
<?php
		wp_reset_postdata();

		endif;
	}

		
// Widget Backend 
public function form( $instance ) {

//Set up some default widget settings.
	$instance			= wp_parse_args( (array) $instance, array( 
		'title'				=> '', 
		'number'			=> '5', 
		'show_title'		=> '1', 
		'show_video'		=> '1', 
		'show_date'			=> '1', 
		'show_excerpt'		=> '0', 
		'show_in_format'	=> '0', 
		'widget_icon'		=> '', 
		'widget_title_bgcolor'		=> '#333333' 
	) );
	$title				= $instance['title'];
	$number				= $instance['number'];
	$show_title			= $instance['show_title'];
	$show_video			= $instance['show_video'];
	$show_date			= $instance['show_date'];
	$show_excerpt		= $instance['show_excerpt'];
	$show_in_format		= $instance['show_in_format'];
	$widget_icon		= $instance['widget_icon'];
	$widget_title_bgcolor		= $instance['widget_title_bgcolor'];
// Widget admin form
?>
	<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Widget Title:', 'passport' ); ?></label>
	<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /></p>

	<p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php esc_html_e( 'Number of posts to show:', 'passport' ); ?></label>
	<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" size="3" /></p>

	<p><input class="checkbox" type="checkbox" <?php checked( $show_title ); ?> id="<?php echo $this->get_field_id( 'show_title' ); ?>" name="<?php echo $this->get_field_name( 'show_title' ); ?>" />
	<label for="<?php echo $this->get_field_id( 'show_title' ); ?>"><?php esc_html_e( 'Display title?', 'passport' ); ?></label></p>

	<p><input class="checkbox" type="checkbox" <?php checked( $show_video ); ?> id="<?php echo $this->get_field_id( 'show_video' ); ?>" name="<?php echo $this->get_field_name( 'show_video' ); ?>" />
	<label for="<?php echo $this->get_field_id( 'show_video' ); ?>"><?php esc_html_e( 'Display video?', 'passport' ); ?></label></p>

	<p><input class="checkbox" type="checkbox" <?php checked( $show_date ); ?> id="<?php echo $this->get_field_id( 'show_date' ); ?>" name="<?php echo $this->get_field_name( 'show_date' ); ?>" />
	<label for="<?php echo $this->get_field_id( 'show_date' ); ?>"><?php esc_html_e( 'Display post date?', 'passport' ); ?></label></p>

	<p><input class="checkbox" type="checkbox" <?php checked( $show_excerpt ); ?> id="<?php echo $this->get_field_id( 'show_excerpt' ); ?>" name="<?php echo $this->get_field_name( 'show_excerpt' ); ?>" />
	<label for="<?php echo $this->get_field_id( 'show_excerpt' ); ?>"><?php esc_html_e( 'Show the excerpt?', 'passport' ); ?></label></p>

	<h4><?php esc_html_e( 'Widget Style', 'passport' ); ?></h4>
	<p>
		<label for="<?php echo $this->get_field_id( 'widget_icon' ); ?>"><?php esc_html_e( 'Icon:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'widget_icon' ); ?>" name="<?php echo $this->get_field_name( 'widget_icon' ); ?>" type="text" value="<?php echo esc_attr( $widget_icon ); ?>" />
		<br />
		<small><?php esc_html_e( 'Please choose your  fontawesome icon. For example: fa fa-home.', 'passport' ); ?></small>
		<small><a href="<?php echo esc_url( 'https://fortawesome.github.io/Font-Awesome/cheatsheet/' ); ?>" target="_blank"><b><?php esc_html_e( 'Find your icon', 'passport' ); ?></b></a></small>
	</p>

	<label for="<?php echo $this->get_field_id( 'widget_title_bgcolor' ); ?>" style="display:block;"><?php esc_html_e( 'Widget Title Background Color:', 'passport' ); ?></label><br />
	<input class="widefat color" id="<?php echo $this->get_field_id( 'widget_title_bgcolor' ); ?>" name="<?php echo $this->get_field_name( 'widget_title_bgcolor' ); ?>" type="text" value="<?php echo esc_attr( $widget_title_bgcolor ); ?>" />
	<div class="colorpicker"></div>

<?php }
	
// Updating widget replacing old instances with new
public function update( $new_instance, $old_instance ) {

	$instance		= $old_instance;

	//Update new instances
	$instance['title']				  = wp_filter_nohtml_kses( $new_instance['title'] );
	$instance['number']				  = (int) $new_instance['number'];
	$instance['show_title']			  = isset( $new_instance['show_title'] ) ? (bool) $new_instance['show_title'] : false;
	$instance['show_video']			  = isset( $new_instance['show_video'] ) ? (bool) $new_instance['show_video'] : false;
	$instance['show_date']			  = isset( $new_instance['show_date'] ) ? (bool) $new_instance['show_date'] : false;
	$instance['show_excerpt']		  = isset( $new_instance['show_excerpt'] ) ? (bool) $new_instance['show_excerpt'] : false;
	$instance['widget_icon']		  = wp_filter_nohtml_kses( $new_instance['widget_icon'] );
	$instance['widget_title_bgcolor'] = wp_filter_nohtml_kses( $new_instance['widget_title_bgcolor'] );

	return $instance;
	}
		
} // Class widget ends here

// Register and load the widget
function passport_recent_posts_with_video_load_widget() {
	register_widget( 'Passport_Recent_Posts_With_Video_Widget' );
}
add_action( 'widgets_init', 'passport_recent_posts_with_video_load_widget' );