<?php
/*
 * Passport Recent Posts With Thumbnail Widget
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 */
class Passport_Recent_Posts_With_Thumbnails_Widget extends WP_Widget {

function __construct() {
	$widget_ops = array('classname' => 'widget_recent_posts_with_thumbnails', 'description' => esc_html__( 'Display most recent posts with thumbnails.', 'passport' ) );
	parent::__construct( 'passport_recent_posts_with_thumbnails_widget', esc_html__('Passport Recent Posts with Thumbnails', 'passport'), $widget_ops );

    $this->alt_option_name = 'widget_recent_posts_with_thumbnails';
    add_action( 'wp_enqueue_scripts', array( $this, 'passport_widget_inline_style' ) );

}


/**
 * Styling the widget
 */
public function passport_widget_inline_style() { 
    $i = 0;

    $widget_options = get_option( $this->option_name );

    $custom_widget_css = '';
        if( is_array( $widget_options ) && count( $widget_options ) > 0 ) {
			foreach ( $widget_options as $key => $widget_option ) {
     
                $widget_title_bgcolor_option = isset( $widget_option['widget_title_bgcolor'] ) ? $widget_option['widget_title_bgcolor'] : '';
 
                if ( isset( $widget_title_bgcolor_option ) ) {
                    $custom_widget_css .= "#{$this->id_base}-{$key} .widget-title {";
                    $custom_widget_css .= ! empty( $widget_title_bgcolor_option ) ? 'background-color:'. $widget_title_bgcolor_option .';' :'background-color: #333333;';
                    $custom_widget_css .= "}";
                    $custom_widget_css .= "#{$this->id_base}-{$key} .widget-title span {";
                    $custom_widget_css .= 'color: #ffffff;';
                    $custom_widget_css .= "}";
    	       }
            $i++;
	    }
    }
    wp_add_inline_style( PASSPORT_THEME_SLUG . '-custom-style', $custom_widget_css );   
}


// Creating widget front-end
// This is where the action happens
public function widget( $args, $instance ) {

	$title				= ! empty( $instance['title'] ) ? $instance['title'] : '';
	$content_column		= get_theme_mod( 'section_1_settings' );
	$number				= ! empty( $instance['number'] ) ? absint( $instance['number'] ) : 5;
	$show_title			= ! empty( $instance['show_title'] ) ? $instance['show_title'] : false;
	$show_image			= ! empty( $instance['show_image'] ) ? $instance['show_image'] : false;
	$image_position		= ! empty( $instance['image_position'] ) ? $instance['image_position'] : 'left' ;
	$show_date			= ! empty( $instance['show_date'] ) ? $instance['show_date'] : false;
	$show_excerpt		= ! empty( $instance['show_excerpt'] ) ? $instance['show_excerpt'] : false;
	$widget_icon		= ! empty( $instance['widget_icon'] ) ? $instance['widget_icon'] : '';

	$post_type		=	array( 'post' );
	$widget_args =	array(
		'post_type'				=> $post_type,
		'posts_per_page'		=> $number,
		'no_found_rows'			=> true,
		'post_status'			=> 'publish',
		'ignore_sticky_posts'	=> true,
		'post__not_in'			=> array( get_the_ID() ), //Not include current post
		'meta_query' => array(
			array(
				'key'			=> '_thumbnail_id',
				'compare'		=> '!=',
				'value'			=> ''
			)
		)
	);

	$wp_query = new WP_Query( $widget_args );
	?>
	<?php if ( $wp_query->have_posts() ) : ?>
		<?php echo $args['before_widget']; ?>
		<?php if ( ! empty( $title ) ) {  echo '<h4 class="widget-title"><i class="'. $widget_icon .'"></i> <span>'. $title .'</span></h4>'; } ?>
		<ul class="list-unstyled">
		<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); 
 			$archive_year		= get_the_time('Y'); 
			$archive_month		= get_the_time('m'); 
			$archive_day		= get_the_time('d');
		?>
			<li class="widget-post-item clearfix">
                <div class="<?php if( has_post_thumbnail() || 0 != $attachment_id ) { echo 'has-thumbnail'; } else { echo 'no-thumbnail'; } ?> list">
				    <?php if( ! empty( $show_image ) ) : ?>
					    <?php if( 'center' == $image_position ) : ?>
						    <figure class="bglayer aligncenter">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail( 'large-image' ); ?>
                                </a>
                            </figure>
					    <?php elseif( 'right' == $image_position ) : ?>
						    <figure class="bglayer alignright">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail( 'small-100-70' ); ?>
                                </a>
                            </figure>
					    <?php elseif( 'left' == $image_position ) : ?>
						    <figure class="bglayer alignleft">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail( 'small-100-70' ); ?>
                                </a>
                             </figure>
					    <?php endif; ?>
				    <?php endif; ?>
				    <div class="post-content">
					    <?php if ( $show_title ) : ?>
						    <h4 class="entry-title"><a href="<?php the_permalink(); ?>"><?php echo passport_short_title( get_the_title(), 40 ); ?></a></h4>
					    <?php endif; ?>
					    <?php if ( $show_date ) : ?>
						    <p class="post-info clearfix">
							     <a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><?php the_time('M j, Y') ?></a>
						    </p>
					    <?php endif; ?>
					    <?php if ( $show_excerpt ) : ?>
					        <p class="post-excerpt"><?php echo get_the_excerpt(); ?></p>
					    <?php endif; ?>
				    </div>
                </div>
			</li>
		<?php endwhile; ?>
		</ul>
		<?php echo $args['after_widget']; ?>
<?php
		// Reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();

		endif;
	}

// Widget Backend 
public function form( $instance ) {
	
//Set up some default widget settings.
	$instance			= wp_parse_args( (array) $instance, array( 
		'title'				=> '', 
		'number'			=> '5', 
		'show_title'		=> '1', 
		'show_image'		=> '1',
        'image_position'    => 'left',
		'show_date'			=> '1', 
		'show_excerpt'		=> '0', 
		'show_in_format'	=> '0', 
		'widget_icon'		=> '', 
		'widget_title_bgcolor'		=> '#333333'
	) );
	$title				  = $instance['title'];
	$number				  = $instance['number'];
	$show_title			  = $instance['show_title'];
	$show_image			  = $instance['show_image'];
    $image_position       = $instance['image_position'];
	$show_date			  = $instance['show_date'];
	$show_excerpt		  = $instance['show_excerpt'];
	$show_in_format		  = $instance['show_in_format'];
	$widget_icon		  = $instance['widget_icon'];
	$widget_title_bgcolor = $instance['widget_title_bgcolor'];

// Widget admin form
?>
	<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Widget Title:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>

    <p>
		<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php esc_html_e( 'Number of posts to show:', 'passport' ); ?></label>
		<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" size="3" />
	</p>

	<p>
		<input class="checkbox" type="checkbox" <?php checked( $show_title ); ?> id="<?php echo $this->get_field_id( 'show_title' ); ?>" name="<?php echo $this->get_field_name( 'show_title' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_title' ); ?>"><?php esc_html_e( 'Display title?', 'passport' ); ?></label>
	</p>

	<p>
		<input class="checkbox" type="checkbox" <?php checked( $show_image ); ?> id="<?php echo $this->get_field_id( 'show_image' ); ?>" name="<?php echo $this->get_field_name( 'show_image' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_image' ); ?>"><?php esc_html_e( 'Display featured image?', 'passport' ); ?></label>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id('image_position'); ?>"><?php esc_html_e( 'Featured image Position:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name('image_position'); ?>" id="<?php echo $this->get_field_id('image_position'); ?>">
			<option value="left"<?php selected( $instance['image_position'], 'left' ); ?>><?php esc_html_e( 'Left', 'passport' ); ?></option>
			<option value="right"<?php selected( $instance['image_position'], 'right' ); ?>><?php esc_html_e( 'Right', 'passport' ); ?></option>
			<option value="center"<?php selected( $instance['image_position'], 'center' ); ?>><?php esc_html_e( 'center', 'passport' ); ?></option>
		</select>
	</p>

	<p>
		<input class="checkbox" type="checkbox" <?php checked( $show_date ); ?> id="<?php echo $this->get_field_id( 'show_date' ); ?>" name="<?php echo $this->get_field_name( 'show_date' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_date' ); ?>"><?php esc_html_e( 'Display the post date?', 'passport' ); ?></label>
	</p>

	<p>
		<input class="checkbox" type="checkbox" <?php checked( $show_excerpt ); ?> id="<?php echo $this->get_field_id( 'show_excerpt' ); ?>" name="<?php echo $this->get_field_name( 'show_excerpt' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_excerpt' ); ?>"><?php esc_html_e( 'Show the excerpt?', 'passport' ); ?></label>
	</p>

	<h4><?php esc_html_e( 'Widget Style', 'passport' ); ?></h4>
	<p>
		<label for="<?php echo $this->get_field_id( 'widget_icon' ); ?>"><?php esc_html_e( 'Icon:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'widget_icon' ); ?>" name="<?php echo $this->get_field_name( 'widget_icon' ); ?>" type="text" value="<?php echo esc_attr( $widget_icon ); ?>" />
		<br />
		<small><?php esc_html_e( 'Please choose your  fontawesome icon. For example: fa fa-home.', 'passport' ); ?></small>
		<small><a href="<?php echo esc_url( 'https://fortawesome.github.io/Font-Awesome/cheatsheet/' ); ?>" target="_blank"><b><?php esc_html_e( 'Find your icon', 'passport' ); ?></b></a></small>
	</p>

	<label for="<?php echo $this->get_field_id( 'widget_title_bgcolor' ); ?>" style="display:block;"><?php esc_html_e( 'Widget Title Background Color:', 'passport' ); ?></label><br />
	<input class="widefat color" id="<?php echo $this->get_field_id( 'widget_title_bgcolor' ); ?>" name="<?php echo $this->get_field_name( 'widget_title_bgcolor' ); ?>" type="text" value="<?php echo esc_attr( $widget_title_bgcolor ); ?>" />
	<div class="colorpicker"></div>

<?php 
}

// Updating widget replacing old instances with new instances
public function update( $new_instance, $old_instance ) {

	$instance							= $old_instance;

	//Define Array
	$image_position_array	= array( 'left', 'right', 'center' );

	//Update new instances
	$instance['title']					= wp_filter_nohtml_kses( $new_instance['title']);
	$instance['number']					= (int) $new_instance['number'];
	$instance['show_title']				= isset( $new_instance['show_title'] ) ? (bool) $new_instance['show_title'] : false;
	$instance['show_image']				= isset( $new_instance['show_image'] ) ? (bool) $new_instance['show_image'] : false;
	if ( in_array( $new_instance['image_position'], $image_position_array ) ) {
		$instance['image_position']		= $new_instance['image_position'];
	} else {
		$instance['image_position']		= 'left';
	}
	$instance['show_excerpt']			= isset( $new_instance['show_excerpt'] ) ? (bool) $new_instance['show_excerpt'] : false;
	$instance['show_date']				= isset( $new_instance['show_date'] ) ? (bool) $new_instance['show_date'] : false;
	$instance['widget_icon']			= wp_filter_nohtml_kses( $new_instance['widget_icon']);
	$instance['widget_title_bgcolor']	= wp_filter_nohtml_kses( $new_instance['widget_title_bgcolor']);

	return $instance;
}

} // Class wn_widget ends here


// Register and load the widget
function passport_recent_posts_with_thumbnails_load_widget() {
	register_widget( 'Passport_Recent_Posts_With_Thumbnails_Widget');
}
add_action( 'widgets_init', 'passport_recent_posts_with_thumbnails_load_widget' );