<?php
/*
 * Passport Posts In Box Format Widget
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 */
class Passport_Posts_In_Box_Format_Widget extends WP_Widget {

function __construct() {
	$widget_ops = array( 'classname' => 'widget_posts_in_box_format clearfix', 'description' => esc_html__( 'Display posts in box format', 'passport' ) );
	parent::__construct( 'passport_posts_in_box_format_widget', esc_html__( 'Passport Posts in Box Format', 'passport' ), $widget_ops );

    $this->alt_option_name = 'widget_posts_in_box_format';

}
// Creating widget front-end
// This is where the action happens
public function widget( $args, $instance ) {

    global $passport_section_settings;
    global $passport_headline_column;

	$number				= ! empty( $instance['number'] ) ? absint( $instance['number'] ) : 7;
	$category_name		= ! empty( $instance['category_name'] ) ? $instance['category_name'] : 'uncategories';
	$image_position		= ! empty( $instance['image_position'] ) ? $instance['image_position'] : 'left' ;
	$exclude			= ! empty( $instance['exclude'] ) ? $instance['exclude'] : '';
	$excludeArry		= explode( ',', $exclude);
	$image_position		= ! empty( $instance['image_position'] ) ? $instance['image_position'] : 'left' ;
	$orderby			= ! empty( $instance['orderby'] ) ?  $instance['orderby'] : 'date';
	$order				= ! empty( $instance['order'] ) ? $instance['order'] : 'desc';
	$tags				= get_the_tags();
	$theme_setting		= get_theme_mod( 'passport_theme_setting', 'full_width_container' );
	$big_box			= 'full_width_container' == $theme_setting ? 'box-900-507' : 'box-760-400';
	$small_box			= 'full_width_container' == $theme_setting ? 'box-225-169' : 'box-240-168';

	$widget_args = array(
		'post_type'			=> 'post',
		'category_name'		=> $category_name,
		'posts_per_page'	=> $number,
		'meta_key'			=> '_thumbnail_id',
		'order'				=> $order,
		'orderby'			=> $orderby,
		'post__not_in'		=> $excludeArry
	);

	$wp_query = new WP_Query( $widget_args ); ?>

	<?php echo $args['before_widget']; ?>

<div class="col-xs-12 col-sm-12 col-md-8 col-lg-8 <?php if ( 'right' == $image_position ) { echo 'alignright'; } ?>">
	<div class="row">
		<?php if ( $wp_query->have_posts() ) : ?>
			<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
				<?php if ( $wp_query->current_post == 0 ) : ?>
					<div class="box-item clearfix">
						<div class="frame">
                            <figure class="bglayer aligncenter">
							    <a href="<?php the_permalink(); ?>">
    							    <?php the_post_thumbnail( $big_box ); ?>			
							    </a>
                                <figcaption class="box-caption">
							        <h3 class="caption-title">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </h3>
						            <div class="caption-excerpt"><?php echo passport_excerpt( '18' ); ?></div>
					            </figcaption>
                            </figure>
                            <div class="caption-background"></div>
						</div>
                    </div>
				<?php endif; ?>
			<?php endwhile; ?>
		<?php endif;?>
	</div>
</div>
<div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
	<div class="row">
		<?php if ( $wp_query->have_posts() ) : ?>
			<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
				<?php if ( $wp_query->current_post >= 1 ) : ?> 
					<div class="col-xxs-2 col-xs-4 col-sm-3 col-md-6">
						<div class="row">
							<div class="small box-item clearfix">
								<div class="frame">
									<figure class="bglayer aligncenter">
                                        <a href="<?php the_permalink(); ?>">
											<?php the_post_thumbnail( $small_box ); ?>		
										</a>	
                                        <figcaption class="box-caption">
										    <h5 class="caption-title">
                                                <a href="<?php the_permalink(); ?>">
                                                    <?php echo passport_short_title( get_the_title(), 30 ); ?>
                                                </a>
                                            </h5>
							            </figcaption>
                                    </figure>
                                    <div class="caption-background"></div>
								</div>
						    </div>
					    </div>
                    </div>
				<?php endif; ?>
			<?php endwhile; ?>
		<?php endif; ?>
	</div>
</div>

<?php echo $args['after_widget']; ?>
<?php }
		
// Widget Backend 
public function form( $instance ) {
	
//Set up some default widget settings.
		$instance			 = wp_parse_args( (array) $instance, array( 
			'number'		=> '7', 
			'category_name' => 'uncategories', 
			'exclude'		=> '', 
			'exclude'		=> '', 
			'image_position'=> 'left', 
			'orderby'		=> 'date', 
			'order'			=> 'desc' 
		) );
		$number				= $instance['number'];
		$exclude			= $instance['exclude'];

// Widget admin form
?>
	<p>
		<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php esc_html_e( 'Number of posts to show:', 'passport' ); ?></label>
		<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" size="3" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'category_name' ); ?>"><?php esc_html_e( 'Category Name (Slug):', 'passport' ); ?></label>
		<small><a class="alignright" href="/wp-admin/edit-tags.php?taxonomy=category"><b><?php esc_html_e( 'Add new category', 'passport' ); ?></b></a></small>
		<select name="<?php echo $this->get_field_name( 'category_name' ); ?>" id="<?php echo $this->get_field_id( 'category_name' ); ?>">
			<?php $categories = get_categories(); ?>
			<?php foreach( $categories as $category) : $cat_name = $category->slug; ?>
				<option value="<?php echo $cat_name; ?>"<?php selected( $instance['category_name'], $cat_name ); ?>><?php echo $cat_name; ?></option>
			<?php endforeach; ?>
		</select>
		<br />
		<small><?php esc_html_e( 'This selection will display your new category when it has at least one post in that category.', 'passport' ); ?></small>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'exclude' ); ?>"><?php esc_html_e( 'Exclude:', 'passport' ); ?></label> 
        <input type="text" value="<?php echo esc_attr( $exclude ); ?>" name="<?php echo $this->get_field_name( 'exclude' ); ?>" id="<?php echo $this->get_field_id( 'exclude' ); ?>"  size="35"/>
		<br />
		<small><?php esc_html_e( 'Post IDs, separated by commas.', 'passport' ); ?></small>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'image_position' ); ?>"><?php esc_html_e( 'Big Box Position:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'image_position' ); ?>" id="<?php echo $this->get_field_id( 'image_position' ); ?>">
			<option value="left"<?php selected( $instance['image_position'], 'left' ); ?>><?php esc_html_e( 'Left', 'passport' ); ?></option>
			<option value="right"<?php selected( $instance['image_position'], 'right' ); ?>><?php esc_html_e( 'Right', 'passport' ); ?></option>
		</select>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'orderby' ); ?>"><?php esc_html_e( 'Order by:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'orderby' ); ?>" id="<?php echo $this->get_field_id( 'orderby', 'passport' ); ?>">
			<option value="none"<?php selected( $instance['orderby'], 'none' ); ?>><?php esc_html_e( 'None', 'passport' ); ?></option>
            <option value="date"<?php selected( $instance['orderby'], 'date' ); ?>><?php esc_html_e( 'Date', 'passport' ); ?></option>
            <option value="author"<?php selected( $instance['orderby'], 'author' ); ?>><?php esc_html_e( 'Author', 'passport' ); ?></option>
            <option value="title"<?php selected( $instance['orderby'], 'title' ); ?>><?php esc_html_e( 'Title', 'passport' ); ?></option>
            <option value="name"<?php selected( $instance['orderby'], 'name' ); ?>><?php esc_html_e( 'Name', 'passport' ); ?></option>
            <option value="type"<?php selected( $instance['orderby'], 'type' ); ?>><?php esc_html_e( 'Type', 'passport' ); ?></option>
            <option value="modified"<?php selected( $instance['orderby'], 'modified' ); ?>><?php esc_html_e( 'Modified', 'passport' ); ?></option>
            <option value="rand"<?php selected( $instance['orderby'], 'rand' ); ?>><?php esc_html_e( 'Rand', 'passport' ); ?></option>
		</select>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'order' ); ?>"><?php esc_html_e( 'Order:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'order' ); ?>" id="<?php echo $this->get_field_id( 'order' ); ?>">
			<option value="desc"<?php selected( $instance['order'], 'desc' ); ?>><?php esc_html_e( 'DESC', 'passport' ); ?></option>
			<option value="asc"<?php selected( $instance['order'], 'asc' ); ?>><?php esc_html_e( 'ASC', 'passport' ); ?></option>
		</select>
	</p>

<?php
}
	
// Updating widget replacing old instances with new instances
public function update( $new_instance, $old_instance ) {
	
	$instance = $old_instance;

	//Define Array
	$categories				= get_categories();
	foreach( $categories as $category) {
		$catsArray[]				= '' . $category->slug . '';
	}
	$image_position_array	= array( 'left', 'right' );
	$orderbyArry			= array( 'none', 'date', 'author', 'title', 'name', 'parent', 'type', 'modified', 'rand' );
	$orderArry				= array( 'desc', 'asc' );
	
	//Update new instances
	$instance['number']				= (int) $new_instance['number'];
	if ( in_array( $new_instance['category_name'], $catsArray ) ) {
		$instance['category_name']	= $new_instance['category_name'];
	} else {
		$instance['category_name']	= 'uncategories';
	}
	$instance['exclude']			= wp_filter_nohtml_kses( $new_instance['exclude'] );
	if ( in_array( $new_instance['image_position'], $image_position_array ) ) {
		$instance['image_position']	= $new_instance['image_position'];
	} else {
		$instance['image_position']	= 'left';
	}
	if ( in_array( $new_instance['orderby'], $orderbyArry ) ) {
		$instance['orderby']		= $new_instance['orderby'];
	} else {
		$instance['orderby']		= 'date';
	}
	if ( in_array( $new_instance['order'], $orderArry ) ) {
		$instance['order']			= $new_instance['order'];
	} else {
		$instance['order']			= 'desc';
	}

		return $instance;
	}


} // Class widget ends here

// Register and load the widget
function passport_posts_in_box_format_load_widget() {
	register_widget( 'Passport_Posts_In_Box_Format_Widget' );
}
add_action( 'widgets_init', 'passport_posts_in_box_format_load_widget' );