<?php
/*
 * Passport Post List By Post Format Widget
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 */
class Passport_Post_List_By_Post_Format_Widget extends WP_Widget {

function __construct() {
	$widget_ops = array( 'classname' => 'widget_post_format_list', 'description' => esc_html__( 'Display post list by post format', 'passport' ) );
	parent::__construct( 'passport_post_list_by_post_format_widget', esc_html__( 'Passport Post List by Post Format', 'passport' ), $widget_ops );

	$this->alt_option_name = 'widget_post_format_list';
    add_action( 'wp_enqueue_scripts', array( $this, 'Passport_widget_inline_style' ) );

}


/**
 * Styling the widget
 */
public function passport_widget_inline_style() { 
    $i = 0;

    $widget_options = get_option( $this->option_name );

    $custom_widget_css = '';
        if( is_array( $widget_options ) && count( $widget_options ) > 0 ) {
			foreach ( $widget_options as $key => $widget_option ) {
     
                $widget_title_bgcolor_option = isset( $widget_option['widget_title_bgcolor'] ) ? $widget_option['widget_title_bgcolor'] : '';
 
                if ( isset( $widget_title_bgcolor_option ) ) {
                    $custom_widget_css .= "#{$this->id_base}-{$key} .widget-title {";
                    $custom_widget_css .= ! empty( $widget_title_bgcolor_option ) ? 'background-color:'. $widget_title_bgcolor_option .';' :'background-color: #333333;';
                    $custom_widget_css .= "}";
                    $custom_widget_css .= "#{$this->id_base}-{$key} .widget-title span {";
                    $custom_widget_css .= 'color: #ffffff;';
                    $custom_widget_css .= "}";
    	       }
            $i++;
	    }
    }
    wp_add_inline_style( PASSPORT_THEME_SLUG . '-custom-style', $custom_widget_css );   
}


// Creating widget front-end
public function widget( $args, $instance ) {
		
	$title				= ! empty( $instance['title'] ) ? $instance['title'] : '';
	$number				= ! empty( $instance['number'] ) ? absint( $instance['number'] ) : 5;
	$post_format		= ! empty( $instance['post_format'] ) ? $instance['post_format'] : 'post-format-image';
	$exclude			= ! empty( $instance['exclude'] ) ? $instance['exclude'] : '';
	$excludeArry		= explode( ',', $exclude );
	$orderby			= ! empty( $instance['orderby'] ) ?  $instance['orderby'] : 'date';
	$order				= ! empty( $instance['order'] ) ? $instance['order'] : 'desc';
	$layout				= ! empty( $instance['layout'] ) ? $instance['layout'] : 'full_1_and_list';
	$widget_icon		= ! empty( $instance['widget_icon'] ) ? $instance['widget_icon'] : '';

	$widget_args			= array(
		'post_type'			=> 'post',
		'posts_per_page'	=> $number,
		'order'				=> $order,
		'orderby'			=> $orderby,
		'post__not_in'		=> $excludeArry,
		'tax_query' => array(
		array(
			'taxonomy'	=> 'post_format',
			'field'		=> 'slug',
			'terms'		=> $post_format,
			)
		)
	);

	$frontpage_id		= get_option( 'page_on_front' );
	$attachment_id		= get_post_thumbnail_id( $frontpage_id );

	$wp_query	= new WP_Query( $widget_args );
    ?>
    <?php if ( $wp_query->have_posts() ) : ?>
		<?php echo $args['before_widget']; ?>
		<?php if ( ! empty( $title ) ) {  echo '<h4 class="widget-title"><i class="'. $widget_icon .'"></i> <span>'. $title .'</span></h4>'; } ?>
		<ul class="list-unstyled">
            <?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); 
 				$archive_year		= get_the_time( 'Y' ); 
				$archive_month		= get_the_time( 'm' ); 
				$archive_day		= get_the_time( 'd' );
            ?>
				<li class="widget-post-item clearfix">
					<?php if ( 'full' == $layout ) : ?><!-- Type 1 : Full Layout -->
					    <?php get_template_part( 'partials/partials', 'short-content' ); ?><!-- End of type 1 -->
					<?php elseif ( 'full_1_and_thumbnail_list' == $layout ): ?><!-- Type 2 : The first shows full information, the second shows thumbnail and title -->
						<?php if ( $wp_query->current_post == 0 ) : ?>
							<?php get_template_part( 'partials/partials', 'short-content' ); ?>
						<?php else : ?><!-- Thumbnail and title -->
						<div class="<?php if( has_post_thumbnail() || 0 != $attachment_id ) { echo 'has-thumbnail'; } else { echo 'no-thumbnail'; } ?> list">
							<figure class="bglayer alignleft">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail( 'small-100-70' ); ?>
                                </a>
                            </figure>
							<div class="post-content"> 
								<h4 class="entry-title"><a href="<?php the_permalink(); ?>"><?php echo passport_short_title( get_the_title(), 40 ); ?></a></h4>
								<a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><span class="post-info clearfix small"><?php echo get_the_date( 'M j, Y' ); ?></span></a>
							</div>
						</div>
						<?php endif; ?><!-- End of Type 2 -->
 					<?php elseif ( 'full_1_and_list' == $layout ) : ?><!-- Type 3 : The first shows full information, the second shows the title -->
						<?php if ( $wp_query->current_post == 0 ) : ?>
							<?php get_template_part( 'partials/partials', 'short-content' ); ?>
						<?php else : ?><!-- title -->
							<div class="post-content">
								<h4 class="entry-title"><a href="<?php the_permalink(); ?>"><?php echo passport_short_title( get_the_title(), 50 ); ?></a></h4>
							</div>
						<?php endif; ?> <!-- End of Type 3 -->
                    <?php elseif ( 'list_only' == $layout ) : ?> <!-- Type 4 : Show list only -->
						<div class="<?php if( has_post_thumbnail() || 0 != $attachment_id ) { echo 'has-thumbnail'; } else { echo 'no-thumbnail'; } ?> list">
							<figure class="bglayer alignleft">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail( 'small-100-70' ); ?>
                                </a>
                            </figure>
							<div class="post-content">
								<h4 class="entry-title"><a href="<?php the_permalink(); ?>"><?php echo passport_short_title( get_the_title(), 40 ); ?></a></h4>
							    <a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><span class="post-info clearfix small"><?php echo get_the_date( 'M j, Y' ); ?></span></a>
                            </div>
						</div>
 					<?php endif; ?> <!-- End of All Type -->
				</li>
			<?php endwhile; ?>
        </ul>
		<?php echo $args['after_widget']; ?>
		<?php wp_reset_postdata(); ?>
		<?php endif; ?>
<?php }
		
// Widget Backend 
public function form( $instance ) {
	
//Set up some default widget settings.
	$instance			= wp_parse_args( (array) $instance, array( 
		'title'				   => '', 
		'number'			   => 5, 
		'post_format'		   => 'post-format-image', 
		'exclude'			   => '', 
		'orderby'			   => 'date', 
		'order'				   => 'desc', 
		'layout'			   => 'full_1_and_list', 
		'widget_icon'		   => '', 
		'widget_title_bgcolor' => '#333333'
	) );
	$title				  = $instance['title'];
	$number				  = $instance['number'];
	$exclude			  = $instance['exclude'];
    $orderby              = $instance['orderby'];
    $order                = $instance['order'];
	$widget_icon		  = $instance['widget_icon'];
	$widget_title_bgcolor = $instance['widget_title_bgcolor'];

// Widget admin form
?>
	<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Widget Title:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php esc_html_e( 'Number of posts to show:', 'passport' ); ?></label>
		<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" size="3" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'post_format' ); ?>"><?php esc_html_e( 'Post Format:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'post_format' ); ?>" id="<?php echo $this->get_field_id( 'post_format' ); ?>">
			<?php $post_formats = array( 'aside', 'link', 'quote', 'image', 'gallery', 'audio', 'video' ); ?>
			<?php foreach( $post_formats as $post_format) : $term_name = 'post-format-'. $post_format .''; ?>
				<option value="<?php echo $term_name; ?>"<?php selected( $instance['post_format'], $term_name ); ?>><?php echo $term_name; ?></option>
			<?php endforeach; ?>
		</select>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'exclude' ); ?>"><?php esc_html_e( 'Exclude:', 'passport' ); ?></label> 
        <input type="text" value="<?php echo esc_attr( $exclude ); ?>" name="<?php echo $this->get_field_name( 'exclude' ); ?>" id="<?php echo $this->get_field_id( 'exclude' ); ?>"  size="35" />
		<br />
		<small><?php esc_html_e( 'Post IDs, separated by commas.', 'passport' ); ?></small>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'orderby' ); ?>"><?php esc_html_e( 'Order by:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'orderby' ); ?>" id="<?php echo $this->get_field_id( 'orderby', 'passport' ); ?>">
			<option value="none"<?php selected( $instance['orderby'], 'none' ); ?>><?php esc_html_e( 'None', 'passport' ); ?></option>
            <option value="date"<?php selected( $instance['orderby'], 'date' ); ?>><?php esc_html_e( 'Date', 'passport' ); ?></option>
            <option value="author"<?php selected( $instance['orderby'], 'author' ); ?>><?php esc_html_e( 'Author', 'passport' ); ?></option>
            <option value="title"<?php selected( $instance['orderby'], 'title' ); ?>><?php esc_html_e( 'Title', 'passport' ); ?></option>
            <option value="name"<?php selected( $instance['orderby'], 'name' ); ?>><?php esc_html_e( 'Name', 'passport' ); ?></option>
            <option value="type"<?php selected( $instance['orderby'], 'type' ); ?>><?php esc_html_e( 'Type', 'passport' ); ?></option>
            <option value="modified"<?php selected( $instance['orderby'], 'modified' ); ?>><?php esc_html_e( 'Modified', 'passport' ); ?></option>
            <option value="rand"<?php selected( $instance['orderby'], 'rand' ); ?>><?php esc_html_e( 'Rand', 'passport' ); ?></option>
		</select>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'order' ); ?>"><?php esc_html_e( 'Order:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'order' ); ?>" id="<?php echo $this->get_field_id( 'order' ); ?>">
			<option value="desc"<?php selected( $instance['order'], 'desc' ); ?>><?php esc_html_e( 'DESC', 'passport' ); ?></option>
			<option value="asc"<?php selected( $instance['order'], 'asc' ); ?>><?php esc_html_e( 'ASC', 'passport' ); ?></option>
		</select>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'layout' ); ?>"><?php esc_html_e( 'Format Layout:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'layout' ); ?>" id="<?php echo $this->get_field_id( 'layout' ); ?>">
			<option value="full"<?php selected( $instance['layout'], 'Full' ); ?>><?php esc_html_e( 'Full', 'passport' ); ?></option>
			<option value="full_1_and_thumbnail_list"<?php selected( $instance['layout'], 'full_1_and_thumbnail_list' ); ?>><?php esc_html_e( 'Full and thumbnail list', 'passport' ); ?></option>
			<option value="full_1_and_list"<?php selected( $instance['layout'], 'full_1_and_list' ); ?>><?php esc_html_e( 'Full and list', 'passport' ); ?></option>
		    <option value="list_only"<?php selected( $instance['layout'], 'list_only' ); ?>><?php esc_html_e( 'List only', 'passport' ); ?></option>
        </select>
	</p>

	<h4><?php esc_html_e( 'Widget Style', 'passport' ); ?></h4>
	<p>
		<label for="<?php echo $this->get_field_id( 'widget_icon' ); ?>"><?php esc_html_e( 'Icon:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'widget_icon' ); ?>" name="<?php echo $this->get_field_name( 'widget_icon' ); ?>" type="text" value="<?php echo esc_attr( $widget_icon ); ?>" />
		<br />
		<small><?php esc_html_e( 'Please choose your  fontawesome icon. For example: fa fa-home.', 'passport' ); ?></small>
		<small><a href="<?php echo esc_url( 'https://fortawesome.github.io/Font-Awesome/cheatsheet/' ); ?>" target="_blank"><b><?php esc_html_e( 'Find your icon', 'passport' ); ?></b></a></small>
	</p>

	<label for="<?php echo $this->get_field_id( 'widget_title_bgcolor' ); ?>" style="display:block;"><?php esc_html_e( 'Widget Title Background Color:', 'passport' ); ?></label><br />
	<input class="widefat color" id="<?php echo $this->get_field_id( 'widget_title_bgcolor' ); ?>" name="<?php echo $this->get_field_name( 'widget_title_bgcolor' ); ?>" type="text" value="<?php echo esc_attr( $widget_title_bgcolor ); ?>" />
	<div class="colorpicker"></div>

<?php }
	
// Updating widget replacing old instances with new instances
public function update( $new_instance, $old_instance ) {
	$instance = $old_instance;

	//Define Array
	$post_formats = array( 'aside', 'link', 'quote', 'image', 'gallery', 'audio', 'video' );
	foreach( $post_formats as $post_format ) {
		$term_name = 'post-format-'. $post_format .'';
		$term_names[] = '' . $term_name . '';
	}
	$orderbyArry = array( 'none', 'date', 'author', 'title', 'name', 'parent', 'type', 'modified', 'rand' );
	$orderArry	 = array( 'desc', 'asc' );
	$layoutArry  = array( 'full', 'full_1_and_thumbnail_list', 'full_1_and_list', 'list_only' );

	//Update new instances
	$instance['title'] = wp_filter_nohtml_kses( $new_instance['title']);
	$instance['number'] = (int) $new_instance['number'];
	if ( in_array( $new_instance['post_format'], $term_names ) ) {
			$instance['post_format']	= $new_instance['post_format'];
		} else {
			$instance['post_format']	= 'post-format-image';
		}
	$instance['exclude'] = wp_filter_nohtml_kses( $new_instance['exclude'] );	
	if ( in_array( $new_instance['orderby'], $orderbyArry ) ) {
			$instance['orderby']        = $new_instance['orderby'];
		} else {
			$instance['orderby']        = 'date';
		}
	if ( in_array( $new_instance['order'], $orderArry ) ) {
			$instance['order'] 	        = $new_instance['order'];
		} else {
			$instance['order']	        = 'desc';
		}
	if ( in_array( $new_instance['layout'], $layoutArry ) ) {
			$instance['layout']	        = $new_instance['layout'];
		} else {
			$instance['layout']	        = 'full_1_and_list';
		}
	$instance['widget_icon']	        = wp_filter_nohtml_kses( $new_instance['widget_icon'] );
	$instance['widget_title_bgcolor']	= wp_filter_nohtml_kses( $new_instance['widget_title_bgcolor'] );

	return $instance;
	}

} // Class widget ends here


// Register and load the widget
function passport_post_list_by_post_format_load_widget() {
	register_widget( 'Passport_Post_List_By_Post_Format_Widget' );
}
add_action( 'widgets_init', 'passport_post_list_by_post_format_load_widget' );